/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.zip;

import com.jronimo.collections.collection.types.nullfree.NullFreeMutableCollection;
import com.jronimo.documenter.gui.FileMethods;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.util.Logger;
import com.jronimo.util.StringWrapper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Zipper {
    private static final Logger logger = Logger.getLogger(Zipper.class);
    private ByteArrayOutputStream byteArrayOutputStream = null;
    private ZipOutputStream zipOutputStream = null;

    public Zipper(File file) throws FileNotFoundException {
        this.zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
    }

    public Zipper() {
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        this.zipOutputStream = new ZipOutputStream(this.byteArrayOutputStream);
    }

    public byte[] getBytes() {
        return this.byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addEntry(String string, File file) throws Exception {
        block14: {
            StringWrapper stringWrapper = null;
            byte[] byArray = null;
            FileInputStream fileInputStream = null;
            int n = 0;
            try {
                stringWrapper = new StringWrapper(string);
                stringWrapper.replaceAll("\\", "/");
                if (file.isDirectory() && !stringWrapper.endsWith("/")) {
                    stringWrapper.append("/");
                }
                if (stringWrapper.startsWith("/")) {
                    stringWrapper.deleteCharAt(0);
                }
                if (!stringWrapper.hasContent()) break block14;
                this.addEntry(stringWrapper.toString(), null, file.lastModified());
                if (!file.isFile()) break block14;
                byArray = new byte[1024000];
                fileInputStream = new FileInputStream(file);
                while ((n = fileInputStream.read(byArray)) > 0) {
                    this.addEntryBytes(byArray, 0, n);
                }
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.zipOutputStream.closeEntry();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public synchronized void addEntry(String string, byte[] byArray) throws Exception {
        this.addEntry(string, byArray, null);
    }

    private void addEntry(String string, byte[] byArray, Long l) throws Exception {
        ZipEntry zipEntry = null;
        try {
            this.zipOutputStream.closeEntry();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        zipEntry = new ZipEntry(string);
        if (l != null) {
            zipEntry.setTime(l);
        }
        this.zipOutputStream.putNextEntry(zipEntry);
        if (byArray != null) {
            this.addEntryBytes(byArray, 0, byArray.length);
        }
    }

    public synchronized void addEntryBytes(byte[] byArray, int n, int n2) throws Exception {
        if (byArray != null && byArray.length > 0) {
            this.zipOutputStream.write(byArray, n, n2);
        }
    }

    public synchronized void close() {
        try {
            this.zipOutputStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void zip(File file, File file2, boolean bl) {
        Zipper.zip(file, file2, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File file, File file2, boolean bl, boolean bl2) {
        Zipper zipper = null;
        Object var5_5 = null;
        Exception exception = null;
        try {
            zipper = new Zipper(file);
            for (File file3 : FileMethods.listFiles(file2, true, bl2)) {
                zipper.addEntry(Zipper.getInputFilePath(file2, file3, bl), file3);
            }
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        finally {
            zipper.close();
        }
        if (exception != null) {
            throw new UnexpectedErrorException(exception);
        }
    }

    private static void getFiles(NullFreeMutableCollection<File> nullFreeMutableCollection, File file) {
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                Zipper.getFiles(nullFreeMutableCollection, file2);
                continue;
            }
            nullFreeMutableCollection.add(file2);
        }
    }

    private static String getInputFilePath(File file, File file2, boolean bl) {
        String string = null;
        string = file2.getPath();
        if (!bl) {
            string = string.substring(file.getPath().length());
        }
        return string;
    }
}

