/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.zip;

import com.jronimo.collections.NullFreeMutableList;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.util.Logger;
import com.jronimo.util.NamedObject;
import com.jronimo.util.NamedObjects;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Unzipper {
    private static final Logger logger = Logger.getLogger(Unzipper.class);
    private File archive = null;
    private ZipFile zipFile = null;
    private NullFreeMutableList<ZipEntry> zipEntries = null;

    public Unzipper(File file) throws ZipException, IOException {
        Enumeration<? extends ZipEntry> enumeration = null;
        Object var3_3 = null;
        this.archive = file;
        this.zipFile = new ZipFile(file);
        this.zipEntries = new NullFreeMutableList();
        enumeration = this.zipFile.entries();
        while (enumeration.hasMoreElements()) {
            this.zipEntries.add(enumeration.nextElement());
        }
    }

    public File getArchive() {
        return this.archive;
    }

    public NullFreeMutableList<ZipEntry> getZipEntries() {
        return this.zipEntries;
    }

    public NamedObjects<byte[]> getZipEntryContents() throws IOException {
        NamedObjects<byte[]> namedObjects = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        namedObjects = new NamedObjects<byte[]>(this.zipEntries.size());
        for (ZipEntry zipEntry : this.zipEntries) {
            if (zipEntry.isDirectory()) {
                namedObjects.add(new NamedObject<Object>(zipEntry.getName(), null));
                continue;
            }
            byteArrayOutputStream = new ByteArrayOutputStream();
            this.getBytes(zipEntry, byteArrayOutputStream);
            namedObjects.add(new NamedObject<byte[]>(zipEntry.getName(), byteArrayOutputStream.toByteArray()));
        }
        return namedObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getBytes(ZipEntry zipEntry, OutputStream outputStream) throws IOException {
        byte[] byArray = null;
        InputStream inputStream = null;
        int n = 0;
        try {
            byArray = new byte[1024000];
            inputStream = this.zipFile.getInputStream(zipEntry);
            while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public void close() {
        try {
            this.zipFile.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File file, File file2) {
        Unzipper unzipper = null;
        SimpleDateFormat simpleDateFormat = null;
        NullFreeMutableList<ZipEntry> nullFreeMutableList = null;
        String string = null;
        Date date = null;
        File file3 = null;
        File file4 = null;
        FileOutputStream fileOutputStream = null;
        Exception exception = null;
        try {
            unzipper = new Unzipper(file);
            simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mma", Locale.getDefault());
            nullFreeMutableList = unzipper.getZipEntries();
            for (ZipEntry zipEntry : nullFreeMutableList) {
                string = zipEntry.getName();
                if (zipEntry.isDirectory()) {
                    new File(file2, string).mkdirs();
                    continue;
                }
                date = new Date(zipEntry.getTime());
                file3 = new File(file2, string);
                file4 = new File(file3.getParent());
                if (file4 != null && !file4.exists()) {
                    file4.mkdirs();
                }
                fileOutputStream = new FileOutputStream(file3);
                unzipper.getBytes(zipEntry, fileOutputStream);
                try {
                    fileOutputStream.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                file3.setLastModified(date.getTime());
            }
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        finally {
            unzipper.close();
            try {
                fileOutputStream.close();
            }
            catch (Throwable throwable) {}
        }
        if (exception != null) {
            throw new UnexpectedErrorException(exception);
        }
    }
}

