/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.zip;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.zip.ZipFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class FileIterator {
    private java.util.zip.ZipFile zipFile = null;
    private Enumeration entries = null;
    private ZipEntry next = null;

    public FileIterator(File file) throws ZipException, IOException {
        this.zipFile = new java.util.zip.ZipFile(file);
        this.entries = this.zipFile.entries();
        this.prepareNext();
    }

    public boolean hasNextFile() {
        return this.next != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipFile getNextFile() throws IOException {
        ZipFile zipFile = null;
        String string = null;
        byte[] byArray = null;
        byte[] byArray2 = null;
        InputStream inputStream = null;
        int n = 0;
        try {
            byArray2 = new byte[1024000];
            inputStream = this.zipFile.getInputStream(this.next);
            string = this.next.getName();
            this.prepareNext();
            byArray = new byte[]{};
            while ((n = inputStream.read(byArray2, 0, byArray2.length)) > 0) {
                byArray = CollectionUtils.concatArrays(byArray, byArray2, 0, n);
            }
            zipFile = new ZipFile(string, byArray);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Throwable throwable) {}
        }
        return zipFile;
    }

    public void close() {
        try {
            this.zipFile.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void prepareNext() {
        ZipEntry zipEntry = null;
        this.next = null;
        while (this.entries.hasMoreElements()) {
            zipEntry = (ZipEntry)this.entries.nextElement();
            if (zipEntry.isDirectory()) continue;
            this.next = zipEntry;
            break;
        }
    }
}

