/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.xml;

import com.jronimo.collections.MutableList;
import com.jronimo.collections.NullFreeMutableList;
import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.collections.collection.types.Collection;
import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.temporal.Date;
import com.jronimo.temporal.DateTime;
import com.jronimo.temporal.Time;
import com.jronimo.temporal.TimeOfDay;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.FileMethods;
import com.jronimo.util.Logger;
import com.jronimo.xml.ResourceTextIdentifiers;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import com.jronimo.xml.XmlException;
import com.jronimo.xml.XmlUtils;
import java.io.File;
import java.math.BigDecimal;
import java.net.URL;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlElementImpl
implements XmlElement {
    private static final Logger logger = Logger.getLogger(XmlElementImpl.class);
    private Document document;
    private Class exceptionClass;
    private Node node;

    XmlElementImpl(Document document, Class clazz, Node node) {
        Assert.errorParam(node == null, new ResourceTextPointer((Object)com.jronimo.text.ResourceTextIdentifiers.MUST_NOT_BE_NULL, "node"));
        this.document = document;
        this.exceptionClass = clazz;
        this.node = node;
    }

    @Override
    public String getName() {
        return this.node.getNodeName();
    }

    @Override
    public Node getW3cNode() {
        return this.node;
    }

    @Override
    public XmlElement setCData(String string) {
        Node node = null;
        node = XmlUtils.getCDataNode((Element)this.node);
        if (node == null) {
            node = this.document.createCDATASection(this.getValueString(string));
            ((Element)this.node).appendChild(node);
        } else {
            ((Element)node).setTextContent(string);
        }
        return this;
    }

    @Override
    public XmlElement setText(String string) {
        this.node.setTextContent(this.getValueString(string));
        return this;
    }

    @Override
    public XmlElement setBoolean(Boolean bl) {
        this.node.setTextContent(this.getValueString(bl));
        return this;
    }

    @Override
    public XmlElement setLong(Long l) {
        this.node.setTextContent(this.getValueString(l));
        return this;
    }

    @Override
    public XmlElement setInteger(Integer n) {
        this.node.setTextContent(this.getValueString(n));
        return this;
    }

    @Override
    public XmlElement setShort(Short s) {
        this.node.setTextContent(this.getValueString(s));
        return this;
    }

    @Override
    public XmlElement setByte(Byte by) {
        this.node.setTextContent(this.getValueString(by));
        return this;
    }

    @Override
    public XmlElement setBigDecimal(BigDecimal bigDecimal) {
        this.node.setTextContent(this.getValueString(bigDecimal));
        return this;
    }

    @Override
    public XmlElement setDouble(Double d) {
        this.node.setTextContent(this.getValueString(d));
        return this;
    }

    @Override
    public XmlElement setFloat(Float f) {
        this.node.setTextContent(this.getValueString(f));
        return this;
    }

    @Override
    public XmlElement setDate(Date date) {
        this.node.setTextContent(this.getValueString(date));
        return this;
    }

    @Override
    public XmlElement setDateTime(DateTime dateTime) {
        this.node.setTextContent(this.getValueString(dateTime));
        return this;
    }

    @Override
    public XmlElement setTimeOfDay(TimeOfDay timeOfDay) {
        this.node.setTextContent(this.getValueString(timeOfDay));
        return this;
    }

    @Override
    public XmlElement setTime(Time time) {
        this.node.setTextContent(this.getValueString(time));
        return this;
    }

    @Override
    public XmlElement setTimestamp(DateTime dateTime) {
        this.node.setTextContent(this.getTimestampValueString(dateTime));
        return this;
    }

    @Override
    public String getText() {
        return this.getText(this.node);
    }

    @Override
    public Boolean getBoolean() {
        return this.getBoolean(this.node);
    }

    @Override
    public Long getLong() {
        return this.getLong(this.node);
    }

    @Override
    public Integer getInteger() {
        return this.getInteger(this.node);
    }

    @Override
    public Short getShort() {
        return this.getShort(this.node);
    }

    @Override
    public Byte getByte() {
        return this.getByte(this.node);
    }

    @Override
    public BigDecimal getBigDecimal() {
        return this.getBigDecimal(this.node);
    }

    @Override
    public Double getDouble() {
        return this.getDouble(this.node);
    }

    @Override
    public Float getFloat() {
        return this.getFloat(this.node);
    }

    @Override
    public Date getDate() {
        return this.getDate(this.node);
    }

    @Override
    public DateTime getDateTime() {
        return this.getDateTime(this.node);
    }

    @Override
    public TimeOfDay getTimeOfDay() {
        return this.getTimeOfDay(this.node);
    }

    @Override
    public Time getTime() {
        return this.getTime(this.node);
    }

    @Override
    public DateTime getTimestamp() {
        return this.getTimestamp(this.node);
    }

    @Override
    public String getText(String string) {
        return this.getText(this.getNode(string, false));
    }

    @Override
    public Boolean getBoolean(String string) {
        return this.getBoolean(this.getNode(string, false));
    }

    @Override
    public Long getLong(String string) {
        return this.getLong(this.getNode(string, false));
    }

    @Override
    public Integer getInteger(String string) {
        return this.getInteger(this.getNode(string, false));
    }

    @Override
    public Short getShort(String string) {
        return this.getShort(this.getNode(string, false));
    }

    @Override
    public Byte getByte(String string) {
        return this.getByte(this.getNode(string, false));
    }

    @Override
    public BigDecimal getBigDecimal(String string) {
        return this.getBigDecimal(this.getNode(string, false));
    }

    @Override
    public Double getDouble(String string) {
        return this.getDouble(this.getNode(string, false));
    }

    @Override
    public Float getFloat(String string) {
        return this.getFloat(this.getNode(string, false));
    }

    @Override
    public Date getDate(String string) {
        return this.getDate(this.getNode(string, false));
    }

    @Override
    public DateTime getDateTime(String string) {
        return this.getDateTime(this.getNode(string, false));
    }

    @Override
    public TimeOfDay getTimeOfDay(String string) {
        return this.getTimeOfDay(this.getNode(string, false));
    }

    @Override
    public Time getTime(String string) {
        return this.getTime(this.getNode(string, false));
    }

    @Override
    public DateTime getTimestamp(String string) {
        return this.getTimestamp(this.getNode(string, false));
    }

    @Override
    public String getOptionalText(String string) {
        return this.getText(this.getNode(string, true));
    }

    @Override
    public Boolean getOptionalBoolean(String string) {
        return this.getBoolean(this.getNode(string, true));
    }

    @Override
    public Long getOptionalLong(String string) {
        return this.getLong(this.getNode(string, true));
    }

    @Override
    public Integer getOptionalInteger(String string) {
        return this.getInteger(this.getNode(string, true));
    }

    @Override
    public Short getOptionalShort(String string) {
        return this.getShort(this.getNode(string, true));
    }

    @Override
    public Byte getOptionalByte(String string) {
        return this.getByte(this.getNode(string, true));
    }

    @Override
    public BigDecimal getOptionalBigDecimal(String string) {
        return this.getBigDecimal(this.getNode(string, true));
    }

    @Override
    public Double getOptionalDouble(String string) {
        return this.getDouble(this.getNode(string, true));
    }

    @Override
    public Float getOptionalFloat(String string) {
        return this.getFloat(this.getNode(string, true));
    }

    @Override
    public Date getOptionalDate(String string) {
        return this.getDate(this.getNode(string, true));
    }

    @Override
    public DateTime getOptionalDateTime(String string) {
        return this.getDateTime(this.getNode(string, true));
    }

    @Override
    public TimeOfDay getOptionalTimeOfDay(String string) {
        return this.getTimeOfDay(this.getNode(string, true));
    }

    @Override
    public Time getOptionalTime(String string) {
        return this.getTime(this.getNode(string, true));
    }

    @Override
    public DateTime getOptionalTimestamp(String string) {
        return this.getTimestamp(this.getNode(string, true));
    }

    @Override
    public String getOptionalText(String string, String string2) {
        String string3 = null;
        string3 = this.getText(this.getNode(string, true));
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    @Override
    public Boolean getOptionalBoolean(String string, String string2) {
        return this.getBooleanValue(this.getOptionalText(string, string2));
    }

    @Override
    public Long getOptionalLong(String string, String string2) {
        return this.getLongValue(this.getOptionalText(string, string2));
    }

    @Override
    public Integer getOptionalInteger(String string, String string2) {
        return this.getIntegerValue(this.getOptionalText(string, string2));
    }

    @Override
    public Short getOptionalShort(String string, String string2) {
        return this.getShortValue(this.getOptionalText(string, string2));
    }

    @Override
    public Byte getOptionalByte(String string, String string2) {
        return this.getByteValue(this.getOptionalText(string, string2));
    }

    @Override
    public BigDecimal getOptionalBigDecimal(String string, String string2) {
        return this.getBigDecimalValue(this.getOptionalText(string, string2));
    }

    @Override
    public Double getOptionalDouble(String string, String string2) {
        return this.getDoubleValue(this.getOptionalText(string, string2));
    }

    @Override
    public Float getOptionalFloat(String string, String string2) {
        return this.getFloatValue(this.getOptionalText(string, string2));
    }

    @Override
    public Date getOptionalDate(String string, String string2) {
        return this.getDateValue(this.getOptionalText(string, string2));
    }

    @Override
    public DateTime getOptionalDateTime(String string, String string2) {
        return this.getDateTimeValue(this.getOptionalText(string, string2));
    }

    @Override
    public TimeOfDay getOptionalTimeOfDay(String string, String string2) {
        return this.getTimeOfDayValue(this.getOptionalText(string, string2));
    }

    @Override
    public Time getOptionalTime(String string, String string2) {
        return this.getTimeValue(this.getOptionalText(string, string2));
    }

    @Override
    public DateTime getOptionalTimestamp(String string, String string2) {
        return this.getTimestampValue(this.getOptionalText(string, string2));
    }

    @Override
    public boolean hasAttribute(String string) {
        return this.getAttribute(string) != null;
    }

    @Override
    public XmlElement removeAttribute(String string) {
        ((Element)this.node).removeAttribute(string);
        return this;
    }

    @Override
    public XmlElement setAttributeText(String string, String string2) {
        ((Element)this.node).setAttribute(string, this.getValueString(string2));
        return this;
    }

    @Override
    public XmlElement setAttributeBoolean(String string, Boolean bl) {
        ((Element)this.node).setAttribute(string, this.getValueString(bl));
        return this;
    }

    @Override
    public XmlElement setAttributeLong(String string, Long l) {
        ((Element)this.node).setAttribute(string, this.getValueString(l));
        return this;
    }

    @Override
    public XmlElement setAttributeInteger(String string, Integer n) {
        ((Element)this.node).setAttribute(string, this.getValueString(n));
        return this;
    }

    @Override
    public XmlElement setAttributeShort(String string, Short s) {
        ((Element)this.node).setAttribute(string, this.getValueString(s));
        return this;
    }

    @Override
    public XmlElement setAttributeByte(String string, Byte by) {
        ((Element)this.node).setAttribute(string, this.getValueString(by));
        return this;
    }

    @Override
    public XmlElement setAttributeBigDecimal(String string, BigDecimal bigDecimal) {
        ((Element)this.node).setAttribute(string, this.getValueString(bigDecimal));
        return this;
    }

    @Override
    public XmlElement setAttributeDouble(String string, Double d) {
        ((Element)this.node).setAttribute(string, this.getValueString(d));
        return this;
    }

    @Override
    public XmlElement setAttributeFloat(String string, Float f) {
        ((Element)this.node).setAttribute(string, this.getValueString(f));
        return this;
    }

    @Override
    public XmlElement setAttributeDate(String string, Date date) {
        ((Element)this.node).setAttribute(string, this.getValueString(date));
        return this;
    }

    @Override
    public XmlElement setAttributeDateTime(String string, DateTime dateTime) {
        ((Element)this.node).setAttribute(string, this.getValueString(dateTime));
        return this;
    }

    @Override
    public XmlElement setAttributeTimeOfDay(String string, TimeOfDay timeOfDay) {
        ((Element)this.node).setAttribute(string, this.getValueString(timeOfDay));
        return this;
    }

    @Override
    public XmlElement setAttributeTime(String string, Time time) {
        ((Element)this.node).setAttribute(string, this.getValueString(time));
        return this;
    }

    @Override
    public XmlElement setAttributeTimestamp(String string, DateTime dateTime) {
        ((Element)this.node).setAttribute(string, this.getTimestampValueString(dateTime));
        return this;
    }

    @Override
    public String getAttributeText(String string) {
        return this.getText(this.getAttribute(string));
    }

    @Override
    public Boolean getAttributeBoolean(String string) {
        return this.getBoolean(this.getAttribute(string));
    }

    @Override
    public Long getAttributeLong(String string) {
        return this.getLong(this.getAttribute(string));
    }

    @Override
    public Integer getAttributeInteger(String string) {
        return this.getInteger(this.getAttribute(string));
    }

    @Override
    public Short getAttributeShort(String string) {
        return this.getShort(this.getAttribute(string));
    }

    @Override
    public Byte getAttributeByte(String string) {
        return this.getByte(this.getAttribute(string));
    }

    @Override
    public BigDecimal getAttributeBigDecimal(String string) {
        return this.getBigDecimal(this.getAttribute(string));
    }

    @Override
    public Double getAttributeDouble(String string) {
        return this.getDouble(this.getAttribute(string));
    }

    @Override
    public Float getAttributeFloat(String string) {
        return this.getFloat(this.getAttribute(string));
    }

    @Override
    public Date getAttributeDate(String string) {
        return this.getDate(this.getAttribute(string));
    }

    @Override
    public DateTime getAttributeDateTime(String string) {
        return this.getDateTime(this.getAttribute(string));
    }

    @Override
    public TimeOfDay getAttributeTimeOfDay(String string) {
        return this.getTimeOfDay(this.getAttribute(string));
    }

    @Override
    public Time getAttributeTime(String string) {
        return this.getTime(this.getAttribute(string));
    }

    @Override
    public DateTime getAttributeTimestamp(String string) {
        return this.getTimestamp(this.getAttribute(string));
    }

    @Override
    public String getOptionalAttributeText(String string, String string2) {
        String string3 = null;
        string3 = this.hasAttribute(string) ? this.getText(this.getAttribute(string)) : string2;
        return string3;
    }

    @Override
    public Boolean getOptionalAttributeBoolean(String string, Boolean bl) {
        Boolean bl2 = null;
        bl2 = this.hasAttribute(string) ? this.getBoolean(this.getAttribute(string)) : bl;
        return bl2;
    }

    @Override
    public Long getOptionalAttributeLong(String string, Long l) {
        Long l2 = null;
        l2 = this.hasAttribute(string) ? this.getLong(this.getAttribute(string)) : l;
        return l2;
    }

    @Override
    public Integer getOptionalAttributeInteger(String string, Integer n) {
        Integer n2 = null;
        n2 = this.hasAttribute(string) ? this.getInteger(this.getAttribute(string)) : n;
        return n2;
    }

    @Override
    public Short getOptionalAttributeShort(String string, Short s) {
        Short s2 = null;
        s2 = this.hasAttribute(string) ? this.getShort(this.getAttribute(string)) : s;
        return s2;
    }

    @Override
    public Byte getOptionalAttributeByte(String string, Byte by) {
        Byte by2 = null;
        by2 = this.hasAttribute(string) ? this.getByte(this.getAttribute(string)) : by;
        return by2;
    }

    @Override
    public BigDecimal getOptionalAttributeBigDecimal(String string, BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = null;
        bigDecimal2 = this.hasAttribute(string) ? this.getBigDecimal(this.getAttribute(string)) : bigDecimal;
        return bigDecimal2;
    }

    @Override
    public Double getOptionalAttributeDouble(String string, Double d) {
        Double d2 = null;
        d2 = this.hasAttribute(string) ? this.getDouble(this.getAttribute(string)) : d;
        return d2;
    }

    @Override
    public Float getOptionalAttributeFloat(String string, Float f) {
        Float f2 = null;
        f2 = this.hasAttribute(string) ? this.getFloat(this.getAttribute(string)) : f;
        return f2;
    }

    @Override
    public Date getOptionalAttributeDate(String string, Date date) {
        Date date2 = null;
        date2 = this.hasAttribute(string) ? this.getDate(this.getAttribute(string)) : date;
        return date2;
    }

    @Override
    public DateTime getOptionalAttributeDateTime(String string, DateTime dateTime) {
        DateTime dateTime2 = null;
        dateTime2 = this.hasAttribute(string) ? this.getDateTime(this.getAttribute(string)) : dateTime;
        return dateTime2;
    }

    @Override
    public TimeOfDay getOptionalAttributeTimeOfDay(String string, TimeOfDay timeOfDay) {
        TimeOfDay timeOfDay2 = null;
        timeOfDay2 = this.hasAttribute(string) ? this.getTimeOfDay(this.getAttribute(string)) : timeOfDay;
        return timeOfDay2;
    }

    @Override
    public Time getOptionalAttributeTime(String string, Time time) {
        Time time2 = null;
        time2 = this.hasAttribute(string) ? this.getTime(this.getAttribute(string)) : time;
        return time2;
    }

    @Override
    public DateTime getOptionalAttributeTimestamp(String string, DateTime dateTime) {
        DateTime dateTime2 = null;
        dateTime2 = this.hasAttribute(string) ? this.getTimestamp(this.getAttribute(string)) : dateTime;
        return dateTime2;
    }

    private Attr getAttribute(String string) {
        return XmlUtils.getAttribute((Element)this.node, string);
    }

    @Override
    public XmlElement getParent() {
        return new XmlElementImpl(this.document, this.exceptionClass, this.node.getParentNode());
    }

    @Override
    public XmlElement getAncestor(String string) {
        XmlElement xmlElement = null;
        XmlElement xmlElement2 = null;
        xmlElement2 = this.getParent();
        xmlElement = xmlElement2.getName().equals(string) ? xmlElement2 : xmlElement2.getAncestor(string);
        return xmlElement;
    }

    @Override
    public XmlElement prependElement(String string) {
        XmlElementImpl xmlElementImpl = null;
        Element element = null;
        element = this.document.createElement(string);
        this.node.insertBefore(element, this.node.getFirstChild());
        xmlElementImpl = new XmlElementImpl(this.document, this.exceptionClass, element);
        return xmlElementImpl;
    }

    @Override
    public XmlElement prependElement(String string, String string2) {
        return this.prependElement(XmlElementFactory.create(string), string2);
    }

    @Override
    public XmlElement prependElement(XmlElement xmlElement, String string) {
        XmlElementImpl xmlElementImpl = null;
        Element element = null;
        Node node = null;
        element = (Element)xmlElement.getW3cNode();
        if (!this.node.getOwnerDocument().equals(element.getOwnerDocument())) {
            element = this.cloneElement(element);
        }
        if ((node = this.getNode(string, true)) == null) {
            this.node.appendChild(element);
        } else {
            this.node.insertBefore(element, node);
        }
        xmlElementImpl = new XmlElementImpl(this.document, this.exceptionClass, element);
        return xmlElementImpl;
    }

    @Override
    public XmlElement addElement(String string) {
        XmlElementImpl xmlElementImpl = null;
        Element element = null;
        element = this.document.createElement(string);
        this.node.appendChild(element);
        xmlElementImpl = new XmlElementImpl(this.document, this.exceptionClass, element);
        return xmlElementImpl;
    }

    @Override
    public XmlElement addElement(XmlElement xmlElement) {
        XmlElementImpl xmlElementImpl = null;
        xmlElementImpl = new XmlElementImpl(this.document, this.exceptionClass, this.addNodeToNode((Element)this.node, (Element)xmlElement.getW3cNode()));
        return xmlElementImpl;
    }

    @Override
    public XmlElement appendElementWithPotentialCData(String string, String string2) {
        XmlElement xmlElement = null;
        xmlElement = this.addElement(string);
        try {
            xmlElement.setText(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            xmlElement.setCData(string2);
        }
        return xmlElement;
    }

    private Element addNodeToNode(Element element, Element element2) {
        Element element3 = null;
        if (element.getOwnerDocument().equals(element2.getOwnerDocument())) {
            element.appendChild(element2);
            element3 = element2;
        } else {
            element3 = (Element)element.appendChild(this.cloneElement(element2));
        }
        return element3;
    }

    private Element cloneElement(Element element) {
        Element element2 = null;
        NullFreeMutableList<Element> nullFreeMutableList = null;
        String string = null;
        element2 = this.document.createElement(element.getNodeName());
        nullFreeMutableList = XmlUtils.getChildElements(element);
        for (Attr node : XmlUtils.getAttributes(element)) {
            element2.setAttribute(node.getName(), node.getValue());
        }
        if (nullFreeMutableList.isEmpty()) {
            string = element.getTextContent();
            if (XmlUtils.hasCDataSection(element)) {
                element2.appendChild(this.document.createCDATASection(string));
            } else {
                element2.setTextContent(string);
            }
        } else {
            for (Element element3 : nullFreeMutableList) {
                this.addNodeToNode(element2, element3);
            }
        }
        return element2;
    }

    @Override
    public boolean removeElement(String string) {
        boolean bl = false;
        Node node = null;
        node = this.getNode(string, true);
        if (node != null) {
            bl = true;
            this.node.removeChild(node);
        }
        return bl;
    }

    @Override
    public boolean removeElement(XmlElement xmlElement) {
        boolean bl = false;
        Node node = null;
        node = xmlElement.getW3cNode();
        bl = this.node.removeChild(node) != null;
        return bl;
    }

    @Override
    public int removeElements(String string) {
        int n = 0;
        NodeList nodeList = null;
        MutableList<Node> mutableList = null;
        Node node = null;
        nodeList = this.node.getChildNodes();
        mutableList = new MutableList<Node>(nodeList.getLength());
        int n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            node = nodeList.item(i);
            if (!node.getNodeName().equals(string)) continue;
            mutableList.add(node);
        }
        for (Node node2 : mutableList) {
            this.node.removeChild(node2);
        }
        n = mutableList.size();
        return n;
    }

    @Override
    public XmlElement cloneElement() {
        return XmlElementFactory.load(this.toBasicString());
    }

    @Override
    public boolean hasElement(String string) {
        return this.getNode(string, true) != null;
    }

    @Override
    public boolean hasElements(String ... stringArray) {
        boolean bl = true;
        Assert.errorParamMustNotBeNull("paths", stringArray);
        for (String string : stringArray) {
            if (this.hasElement(string)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    @Override
    public XmlElement getElement(String string) {
        return new XmlElementImpl(this.document, this.exceptionClass, this.getNode(string, false));
    }

    @Override
    public XmlElement getOptionalElement(String string) {
        XmlElementImpl xmlElementImpl = null;
        Node node = null;
        node = this.getNode(string, true);
        if (node != null) {
            xmlElementImpl = new XmlElementImpl(this.document, this.exceptionClass, node);
        }
        return xmlElementImpl;
    }

    @Override
    public NullFreeCollection<XmlElement> getElements() {
        return this.getElements("");
    }

    @Override
    public NullFreeCollection<XmlElement> getElements(String string) {
        return this.getElements(string, 1);
    }

    @Override
    public NullFreeCollection<XmlElement> getElements(String string, int n) {
        NullFreeMutableList<XmlElement> nullFreeMutableList = null;
        Collection<Node> collection = null;
        collection = this.getNodes(string);
        if (collection.size() < n) {
            XmlUtils.throwException(this.exceptionClass, new ResourceTextPointer((Object)ResourceTextIdentifiers.EXPECTED_ELEMENTS_NOT_FOUND, String.valueOf(n), String.valueOf(collection.size()), string).getText());
        }
        nullFreeMutableList = new NullFreeMutableList<XmlElement>(collection.size());
        for (Node node : collection) {
            nullFreeMutableList.add(new XmlElementImpl(this.document, this.exceptionClass, node));
        }
        return nullFreeMutableList;
    }

    @Override
    public NullFreeCollection<XmlElement> getOptionalElements() {
        return this.getOptionalElements("");
    }

    @Override
    public NullFreeCollection<XmlElement> getOptionalElements(String string) {
        return this.getElements(string, 0);
    }

    @Override
    public NullFreeCollection<String> getElementsText(String string) {
        return this.getElementsText(this.getElements(string, 1));
    }

    @Override
    public NullFreeCollection<String> getElementsText(String string, int n) {
        return this.getElementsText(this.getElements(string, n));
    }

    @Override
    public NullFreeCollection<String> getOptionalElementsText(String string) {
        return this.getElementsText(this.getOptionalElements(string));
    }

    private NullFreeCollection<String> getElementsText(NullFreeCollection<XmlElement> nullFreeCollection) {
        NullFreeMutableList<String> nullFreeMutableList = null;
        nullFreeMutableList = new NullFreeMutableList<String>(nullFreeCollection.size());
        for (XmlElement xmlElement : nullFreeCollection) {
            nullFreeMutableList.add(xmlElement.getText());
        }
        return nullFreeMutableList;
    }

    public NullFreeCollection<XmlElement> getChildElements() {
        NullFreeMutableList<XmlElement> nullFreeMutableList = null;
        Collection<Node> collection = null;
        collection = this.getChildNodes();
        nullFreeMutableList = new NullFreeMutableList<XmlElement>(collection.size());
        for (Node node : collection) {
            nullFreeMutableList.add(new XmlElementImpl(this.document, this.exceptionClass, node));
        }
        return nullFreeMutableList;
    }

    private String getValueString(Object object) {
        return String.valueOf(object == null ? "" : object);
    }

    private String getValueString(Date date) {
        return date.toString();
    }

    private String getValueString(DateTime dateTime) {
        return dateTime.toString();
    }

    private String getValueString(TimeOfDay timeOfDay) {
        return timeOfDay.toString();
    }

    private String getValueString(Time time) {
        return time.toString();
    }

    private String getTimestampValueString(DateTime dateTime) {
        return String.valueOf(dateTime.getTemporalValue());
    }

    private String getText(Node node) {
        String string = null;
        if (node != null) {
            string = node.getTextContent();
        }
        return string;
    }

    private Boolean getBoolean(Node node) {
        return this.getBooleanValue(this.getText(node));
    }

    private Long getLong(Node node) {
        return this.getLongValue(this.getText(node));
    }

    private Integer getInteger(Node node) {
        return this.getIntegerValue(this.getText(node));
    }

    private Short getShort(Node node) {
        return this.getShortValue(this.getText(node));
    }

    private Byte getByte(Node node) {
        return this.getByteValue(this.getText(node));
    }

    private BigDecimal getBigDecimal(Node node) {
        return this.getBigDecimalValue(this.getText(node));
    }

    private Double getDouble(Node node) {
        return this.getDoubleValue(this.getText(node));
    }

    private Float getFloat(Node node) {
        return this.getFloatValue(this.getText(node));
    }

    private Date getDate(Node node) {
        return this.getDateValue(this.getText(node));
    }

    private DateTime getDateTime(Node node) {
        return this.getDateTimeValue(this.getText(node));
    }

    private TimeOfDay getTimeOfDay(Node node) {
        return this.getTimeOfDayValue(this.getText(node));
    }

    private Time getTime(Node node) {
        return this.getTimeValue(this.getText(node));
    }

    private DateTime getTimestamp(Node node) {
        return this.getTimestampValue(this.getText(node));
    }

    private String getText(Attr attr) {
        return attr.getValue();
    }

    private Boolean getBoolean(Attr attr) {
        return this.getBooleanValue(this.getText(attr));
    }

    private Long getLong(Attr attr) {
        return this.getLongValue(this.getText(attr));
    }

    private Integer getInteger(Attr attr) {
        return this.getIntegerValue(this.getText(attr));
    }

    private Short getShort(Attr attr) {
        return this.getShortValue(this.getText(attr));
    }

    private Byte getByte(Attr attr) {
        return this.getByteValue(this.getText(attr));
    }

    private BigDecimal getBigDecimal(Attr attr) {
        return this.getBigDecimalValue(this.getText(attr));
    }

    private Double getDouble(Attr attr) {
        return this.getDoubleValue(this.getText(attr));
    }

    private Float getFloat(Attr attr) {
        return this.getFloatValue(this.getText(attr));
    }

    private Date getDate(Attr attr) {
        return this.getDateValue(this.getText(attr));
    }

    private DateTime getDateTime(Attr attr) {
        return this.getDateTimeValue(this.getText(attr));
    }

    private TimeOfDay getTimeOfDay(Attr attr) {
        return this.getTimeOfDayValue(this.getText(attr));
    }

    private Time getTime(Attr attr) {
        return this.getTimeValue(this.getText(attr));
    }

    private DateTime getTimestamp(Attr attr) {
        return this.getTimestampValue(this.getText(attr));
    }

    private Boolean getBooleanValue(String string) {
        Boolean bl = null;
        if (string != null && string.length() > 0) {
            bl = Boolean.valueOf(string);
        }
        return bl;
    }

    private Long getLongValue(String string) {
        Long l = null;
        if (string != null && string.length() > 0) {
            l = Long.valueOf(string);
        }
        return l;
    }

    private Integer getIntegerValue(String string) {
        Integer n = null;
        if (string != null && string.length() > 0) {
            n = Integer.valueOf(string);
        }
        return n;
    }

    private Short getShortValue(String string) {
        Short s = null;
        if (string != null && string.length() > 0) {
            s = Short.valueOf(string);
        }
        return s;
    }

    private Byte getByteValue(String string) {
        Byte by = null;
        if (string != null && string.length() > 0) {
            by = Byte.valueOf(string);
        }
        return by;
    }

    private BigDecimal getBigDecimalValue(String string) {
        BigDecimal bigDecimal = null;
        if (string != null && string.length() > 0) {
            bigDecimal = new BigDecimal(string);
        }
        return bigDecimal;
    }

    private Double getDoubleValue(String string) {
        Double d = null;
        if (string != null && string.length() > 0) {
            d = Double.valueOf(string);
        }
        return d;
    }

    private Float getFloatValue(String string) {
        Float f = null;
        if (string != null && string.length() > 0) {
            f = Float.valueOf(string);
        }
        return f;
    }

    private Date getDateValue(String string) {
        Date date = null;
        if (string != null && string.length() > 0) {
            date = new Date(string);
        }
        return date;
    }

    private DateTime getDateTimeValue(String string) {
        DateTime dateTime = null;
        if (string != null && string.length() > 0) {
            dateTime = new DateTime(string);
        }
        return dateTime;
    }

    private TimeOfDay getTimeOfDayValue(String string) {
        TimeOfDay timeOfDay = null;
        if (string != null && string.length() > 0) {
            timeOfDay = new TimeOfDay(string);
        }
        return timeOfDay;
    }

    private Time getTimeValue(String string) {
        Time time = null;
        if (string != null && string.length() > 0) {
            time = new Time(string);
        }
        return time;
    }

    private DateTime getTimestampValue(String string) {
        DateTime dateTime = null;
        if (string != null && string.length() > 0) {
            dateTime = new DateTime(Long.valueOf(string));
        }
        return dateTime;
    }

    private Node getNode(String string, boolean bl) {
        Node node = null;
        Collection<Node> collection = null;
        collection = this.getNodes(string);
        if (collection.size() == 0 && !bl) {
            XmlUtils.throwException(this.exceptionClass, new ResourceTextPointer((Object)ResourceTextIdentifiers.EXPECTED_ELEMENT_NOT_FOUND, string).getText());
        }
        node = (Node)CollectionUtils.getCollectionElement(collection, 0);
        return node;
    }

    private Collection<Node> getNodes(String string) {
        Collection<Node> collection = null;
        StringBuilder stringBuilder = null;
        String string2 = null;
        Node node = null;
        NodeList nodeList = null;
        Node node2 = null;
        stringBuilder = new StringBuilder(string);
        string2 = this.getNextPathElement(stringBuilder);
        if (stringBuilder.length() == 0) {
            nodeList = this.node.getChildNodes();
            collection = new NullFreeMutableList<Node>(Math.min(10, nodeList.getLength()));
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                node2 = nodeList.item(i);
                if (!(node2 instanceof Element) || !node2.getNodeName().equals(string2)) continue;
                collection.add(node2);
            }
        } else if (string2.equals("..")) {
            node = this.node.getParentNode();
        } else {
            nodeList = this.node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                node2 = nodeList.item(i);
                if (!(node2 instanceof Element) || !node2.getNodeName().equals(string2)) continue;
                node = node2;
                break;
            }
        }
        if (collection == null) {
            collection = node == null ? new NullFreeMutableList(0) : new XmlElementImpl(this.document, this.exceptionClass, node).getNodes(stringBuilder.toString());
        }
        return collection;
    }

    private Collection<Node> getChildNodes() {
        NullFreeMutableList<Node> nullFreeMutableList = null;
        NodeList nodeList = null;
        Node node = null;
        nodeList = this.node.getChildNodes();
        nullFreeMutableList = new NullFreeMutableList<Node>(nodeList.getLength());
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            nullFreeMutableList.add(node);
        }
        return nullFreeMutableList;
    }

    private String getNextPathElement(StringBuilder stringBuilder) {
        String string = null;
        int n = 0;
        n = stringBuilder.indexOf("/");
        if (n >= 0) {
            string = stringBuilder.substring(0, n);
            stringBuilder.delete(0, n + 1);
        } else {
            string = stringBuilder.toString();
            stringBuilder.delete(0, stringBuilder.length());
        }
        return string;
    }

    @Override
    public String getPath() {
        String string = null;
        string = this.getPath(this.node, "");
        return string;
    }

    private String getPath(Node node, String string) {
        String string2 = null;
        string = string.length() > 0 ? node.getNodeName() + "/" + string : node.getNodeName();
        string2 = node.getParentNode() == null ? string : this.getPath(node.getParentNode(), string);
        return string2;
    }

    @Override
    public String toBasicString() {
        return XmlUtils.nodeToString(this.node, false);
    }

    public String toString() {
        return XmlUtils.nodeToString(this.node, true);
    }

    @Override
    public void save(URL uRL) {
        try {
            this.save(new File(uRL.toURI()));
        }
        catch (Exception exception) {
            throw new XmlException(exception);
        }
    }

    @Override
    public void save(File file) {
        try {
            FileMethods.writeTextFile(file, this.toString());
        }
        catch (Exception exception) {
            throw new XmlException(exception);
        }
    }
}

