/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.temp.idmaker;

import com.jronimo.collections.NullFreeImmutableSet;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.util.Logger;
import com.jronimo.util.StringWrapper;
import com.jronimo.webdata.temp.idmaker.Config;
import com.jronimo.webdata.temp.idmaker.Configs;
import com.jronimo.webdata.temp.idmaker.Range;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;

public class IdMaker {
    private File directory = null;
    private static final Logger logger = Logger.getLogger(IdMaker.class);

    public IdMaker(File file) {
        this.directory = file;
    }

    public void execute() {
        Configs configs = null;
        configs = Configs.getInstance();
        this.handleCoreFiles(configs.getConfig("core"));
        this.handleChoresFiles(configs.getConfig("Chores"));
    }

    private void handleCoreFiles(Config config) {
        this.handleCoreTextFiles(config);
        this.handleRefDataFiles(config);
    }

    private void handleChoresFiles(Config config) {
    }

    private void handleCoreTextFiles(Config config) {
        File file = null;
        Range range = null;
        Range range2 = null;
        XmlElement xmlElement = null;
        file = new File(this.directory, "definition/imported/text");
        range = config.getRange("text-groups");
        range2 = config.getRange("text-elements");
        for (File file2 : file.listFiles()) {
            if (!file2.isFile()) continue;
            xmlElement = XmlElementFactory.load(file2);
            xmlElement.getElement("id").setLong(range.increment());
            for (XmlElement xmlElement2 : xmlElement.getOptionalElements("text-elements/text-element")) {
                xmlElement2.getElement("id").setLong(range2.increment());
            }
            xmlElement.save(file2);
        }
    }

    private void handleRefDataFiles(Config config) {
        File file = null;
        Range range = null;
        Range range2 = null;
        XmlElement xmlElement = null;
        file = new File(this.directory, "definition/imported/ref-data");
        range = config.getRange("ref-data-categories");
        for (File file2 : file.listFiles()) {
            if (!file2.isFile()) continue;
            xmlElement = XmlElementFactory.load(file2);
            range2 = config.getRange(xmlElement.getText("category/identifier"));
            if (range2 == null) {
                throw new UnexpectedErrorException("Range for RefDataCategory not found : " + xmlElement.getText("category/identifier"));
            }
            xmlElement.getElement("category/id").setLong(range.increment());
            for (XmlElement xmlElement2 : xmlElement.getOptionalElements("category/item")) {
                xmlElement2.getElement("id").setLong(range2.increment());
            }
            xmlElement.save(file2);
        }
    }

    private void hackTogetherStateRefDataIdentifiers() {
        NullFreeImmutableSet<Integer> nullFreeImmutableSet = null;
        File file = null;
        XmlElement xmlElement = null;
        StringWrapper stringWrapper = null;
        nullFreeImmutableSet = new NullFreeImmutableSet<Integer>(11063, 11064, 11065, 11066, 11067, 11068, 11069, 11070, 11071, 11072, 11073, 11074, 11075);
        file = new File(this.directory, "definition/imported/ref-data/CountryRegion.xml");
        xmlElement = XmlElementFactory.load(file);
        stringWrapper = new StringWrapper();
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("category/item")) {
            if (!nullFreeImmutableSet.contains(xmlElement2.getInteger("id"))) continue;
            if (!stringWrapper.isEmpty()) {
                stringWrapper.append(", ");
            }
            stringWrapper.append("CountryRegion.");
            stringWrapper.append(xmlElement2.getText("identifier"));
        }
        logger.debug(stringWrapper);
    }
}

