/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.temp.idmaker;

import com.jronimo.collections.NullFreeMutableList;
import com.jronimo.webdata.temp.idmaker.Config;
import com.jronimo.webdata.temp.idmaker.Range;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;

public class Configs {
    private static Configs instance = new Configs();
    private NullFreeMutableList<Config> configs = new NullFreeMutableList();

    private Configs() {
        this.load();
    }

    public static Configs getInstance() {
        return instance;
    }

    public Config getConfig(String string) {
        Config config = null;
        for (Config config2 : this.configs) {
            if (!config2.getName().equals(string)) continue;
            config = config2;
            break;
        }
        return config;
    }

    private void load() {
        XmlElement xmlElement = null;
        xmlElement = XmlElementFactory.load(Configs.class, "ids-config.xml");
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("config")) {
            this.configs.add(this.loadConfig(xmlElement2));
        }
    }

    private Config loadConfig(XmlElement xmlElement) {
        Config config = null;
        String[] stringArray = new String[]{"range", "text-groups", "text-elements", "ref-data-categories"};
        config = new Config(xmlElement.getText("name"));
        for (String string : stringArray) {
            if (!xmlElement.hasElement(string)) continue;
            config.addRange(this.loadRange(xmlElement.getElement(string)));
        }
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("ref-data-items/ref-data-category")) {
            config.addRange(this.loadRange(xmlElement2));
        }
        return config;
    }

    private Range loadRange(XmlElement xmlElement) {
        Range range = null;
        String string = null;
        long l = 0L;
        Long l2 = null;
        Byte by = null;
        string = xmlElement.getOptionalText("name");
        if (string == null) {
            string = xmlElement.getName();
        }
        l = xmlElement.getLong("start");
        l2 = xmlElement.getOptionalLong("end");
        by = xmlElement.getOptionalByte("increment");
        if (by == null) {
            by = l2 == null ? Byte.valueOf((byte)1) : Byte.valueOf((byte)(l2 >= l ? 1 : -1));
        }
        range = new Range(string, l, l2, by);
        return range;
    }
}

