/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.objectmodel;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.util.Logger;
import com.jronimo.webdata.objectmodel.TextElement;
import com.jronimo.xml.XmlElement;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextGroup {
    private static final Logger logger = Logger.getLogger(TextGroup.class);
    private Long id;
    private String identifier;
    private Map<String, TextElement> textElements;

    TextGroup(Long l, String string) {
        this.id = l;
        this.identifier = string;
    }

    public Long getId() {
        return this.id;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    TextElement getTextElement(String string) {
        return this.textElements.get(string);
    }

    Map<String, TextElement> getTextElements() {
        return this.textElements;
    }

    static TextGroup createInstance(XmlElement xmlElement) {
        TextGroup textGroup = null;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        TextElement textElement = null;
        nullFreeCollection = xmlElement.getOptionalElements("text-elements/text-element");
        textGroup = new TextGroup(xmlElement.getLong("id"), xmlElement.getText("identifier"));
        textGroup.textElements = CollectionUtils.getOrderedMap(new HashMap(nullFreeCollection.size()));
        for (XmlElement xmlElement2 : nullFreeCollection) {
            textElement = TextElement.createInstance(xmlElement2);
            textGroup.textElements.put(textElement.getName(), textElement);
        }
        return textGroup;
    }
}

