/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.objectmodel;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.collections.collection.types.nullfree.NullFreeImmutableCollection;
import com.jronimo.util.Logger;
import com.jronimo.webdata.core.Constants;
import com.jronimo.webdata.objectmodel.Entity;
import com.jronimo.webdata.objectmodel.System;
import com.jronimo.webdata.objectmodel.SystemField;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlUtils;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemFields {
    private static final Logger logger = Logger.getLogger(SystemFields.class);
    private System system;
    private Entity entity;
    private Map<Constants.SystemFieldIdentifier, SystemField> members;

    private SystemFields(System system, Entity entity) {
        this.system = system;
        this.entity = entity;
    }

    public System getSystem() {
        return this.system;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public Map<Constants.SystemFieldIdentifier, SystemField> getSystemFields() {
        return this.members;
    }

    public boolean isSystemField(String string) {
        return this.getSystemField(string) != null;
    }

    public boolean isSystemField(Constants.SystemFieldIdentifier systemFieldIdentifier) {
        return this.getSystemField(systemFieldIdentifier) != null;
    }

    public SystemField getSystemField(String string) {
        return this.getSystemField(Constants.SystemFieldIdentifier.get(string));
    }

    public SystemField getSystemField(Constants.SystemFieldIdentifier systemFieldIdentifier) {
        return this.members.get((Object)systemFieldIdentifier);
    }

    public boolean hasRecordStatusSystemField() {
        return this.getSystemField(Constants.SystemFieldIdentifier.RECORD_STATUS) != null;
    }

    public SystemField getRecordStatusSystemField() {
        return this.getSystemField(Constants.SystemFieldIdentifier.RECORD_STATUS);
    }

    public boolean hasRecordVersionSystemField() {
        return this.getSystemField(Constants.SystemFieldIdentifier.RECORD_VERSION) != null;
    }

    public SystemField getRecordVersionSystemField() {
        return this.getSystemField(Constants.SystemFieldIdentifier.RECORD_VERSION);
    }

    public boolean hasCreateUserSystemField() {
        return this.getSystemField(Constants.SystemFieldIdentifier.AUDIT_CREATE_USER_ID) != null || this.getSystemField(Constants.SystemFieldIdentifier.AUDIT_CREATE_USERNAME) != null;
    }

    public SystemField getCreateUserSystemField() {
        SystemField systemField = null;
        systemField = this.getSystemField(Constants.SystemFieldIdentifier.AUDIT_CREATE_USER_ID);
        if (systemField == null) {
            systemField = this.getSystemField(Constants.SystemFieldIdentifier.AUDIT_CREATE_USERNAME);
        }
        return systemField;
    }

    public boolean hasCreateTimestampSystemField() {
        return this.getSystemField(Constants.SystemFieldIdentifier.AUDIT_CREATE_TIMESTAMP) != null;
    }

    public SystemField getCreateTimestampSystemField() {
        return this.getSystemField(Constants.SystemFieldIdentifier.AUDIT_CREATE_TIMESTAMP);
    }

    public boolean hasUpdateUserSystemField() {
        return this.getSystemField(Constants.SystemFieldIdentifier.AUDIT_UPDATE_USER_ID) != null || this.getSystemField(Constants.SystemFieldIdentifier.AUDIT_UPDATE_USERNAME) != null;
    }

    public SystemField getUpdateUserSystemField() {
        SystemField systemField = null;
        systemField = this.getSystemField(Constants.SystemFieldIdentifier.AUDIT_UPDATE_USER_ID);
        if (systemField == null) {
            systemField = this.getSystemField(Constants.SystemFieldIdentifier.AUDIT_UPDATE_USERNAME);
        }
        return systemField;
    }

    public boolean hasUpdateTimestampSystemField() {
        return this.getSystemField(Constants.SystemFieldIdentifier.AUDIT_UPDATE_TIMESTAMP) != null;
    }

    public SystemField getUpdateTimestampSystemField() {
        return this.getSystemField(Constants.SystemFieldIdentifier.AUDIT_UPDATE_TIMESTAMP);
    }

    static SystemFields createInstance(System system, Entity entity, XmlElement xmlElement, XmlElement xmlElement2, XmlElement xmlElement3) {
        SystemFields systemFields = null;
        Map map = null;
        NullFreeImmutableCollection<String> nullFreeImmutableCollection = null;
        SystemField systemField = null;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        HashMap<Constants.SystemFieldIdentifier, XmlElement> hashMap = null;
        map = CollectionUtils.copyOrderedMap(system.getDefaultSystemFields());
        if (xmlElement != null) {
            nullFreeImmutableCollection = XmlUtils.getTextFromElements(xmlElement.getOptionalElements("system-field-identifier"));
            for (String object : nullFreeImmutableCollection) {
                map.remove((Object)Constants.SystemFieldIdentifier.get(object));
            }
        }
        if (xmlElement2 != null) {
            nullFreeImmutableCollection = XmlUtils.getTextFromElements(xmlElement2.getOptionalElements("system-field-identifier"));
            for (String string : nullFreeImmutableCollection) {
                systemField = system.getDefaultSystemFields().get((Object)Constants.SystemFieldIdentifier.get(string));
                map.put(systemField.getIdentifier(), systemField);
            }
        }
        if (xmlElement3 == null) {
            hashMap = new HashMap<Constants.SystemFieldIdentifier, XmlElement>(0);
        } else {
            nullFreeCollection = xmlElement3.getOptionalElements("system-field");
            hashMap = new HashMap(nullFreeCollection.size());
            for (XmlElement xmlElement4 : nullFreeCollection) {
                hashMap.put(Constants.SystemFieldIdentifier.get(xmlElement4.getText("identifier")), xmlElement4);
            }
        }
        systemFields = new SystemFields(system, entity);
        systemFields.members = CollectionUtils.getOrderedMap(new HashMap(map.size()));
        for (SystemField systemField2 : map.values()) {
            systemField = systemField2.cloneInstance(entity, (XmlElement)hashMap.get((Object)systemField2.getIdentifier()));
            systemFields.members.put(systemField.getIdentifier(), systemField);
        }
        return systemFields;
    }
}

