/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.objectmodel;

import com.jronimo.collections.NullFreeImmutableSet;
import com.jronimo.collections.NullFreeMutableSet;
import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.internationalization.Language;
import com.jronimo.internationalization.Languages;
import com.jronimo.temporal.Timezone;
import com.jronimo.util.Logger;
import com.jronimo.webdata.core.Constants;
import com.jronimo.webdata.objectmodel.Entities;
import com.jronimo.webdata.objectmodel.RefDataCategories;
import com.jronimo.webdata.objectmodel.Relationships;
import com.jronimo.webdata.objectmodel.SequenceSource;
import com.jronimo.webdata.objectmodel.SystemField;
import com.jronimo.webdata.objectmodel.TextGroups;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class System {
    private static final Logger logger = Logger.getLogger(System.class);
    private String identifier;
    private Timezone timezone;
    private NullFreeMutableSet<Language> languages = new NullFreeMutableSet();
    private SequenceSource sequenceSource;
    private Map<Constants.SystemFieldIdentifier, SystemField> recognizedSystemFields;
    private Map<Constants.SystemFieldIdentifier, SystemField> defaultSystemFields;
    private TextGroups textGroups;
    private RefDataCategories refDataCategories;
    private Entities entities;
    private Relationships relationships;

    public System(String string) {
        this.identifier = string;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Timezone getTimezone() {
        return this.timezone;
    }

    public NullFreeImmutableSet<Language> getLanguages() {
        return new NullFreeImmutableSet<Language>((Collection<Language>)this.languages);
    }

    public SequenceSource getSequenceSource() {
        return this.sequenceSource;
    }

    public Map<Constants.SystemFieldIdentifier, SystemField> getRecognizedSystemFields() {
        return this.recognizedSystemFields;
    }

    public Map<Constants.SystemFieldIdentifier, SystemField> getDefaultSystemFields() {
        return this.defaultSystemFields;
    }

    public TextGroups getTextGroups() {
        return this.textGroups;
    }

    public RefDataCategories getRefDataCategories() {
        return this.refDataCategories;
    }

    public Entities getEntities() {
        return this.entities;
    }

    public Relationships getRelationships() {
        return this.relationships;
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        System system = null;
        if (object instanceof System) {
            system = (System)object;
            if (system.identifier.equals(this.identifier)) {
                bl = true;
            }
        }
        return bl;
    }

    public static System createInstance(File file) {
        System system = null;
        XmlElement xmlElement = null;
        String string = null;
        String string2 = null;
        Language language = null;
        xmlElement = XmlElementFactory.load(new File(file, "system.xml"));
        system = new System(xmlElement.getText("identifier"));
        system.timezone = Timezone.getTimezone(xmlElement.getOptionalInteger("system-timezone-id", "0"));
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("supported-languages/language")) {
            string = xmlElement2.getText("language-code");
            string2 = xmlElement2.getOptionalText("language-variation-code");
            language = string2 == null ? Languages.getInstance().getPrimary(string) : Languages.getInstance().getVariation(string, string2);
            system.languages.add(language);
        }
        system.sequenceSource = SequenceSource.createInstance(xmlElement.getElement("sequence-source"));
        System.loadSystemFields(system, xmlElement.getElement("recognized-system-fields"), xmlElement.getElement("default-system-fields"));
        system.textGroups = TextGroups.createInstance(system, new File(file, "text"));
        system.refDataCategories = RefDataCategories.createInstance(system, new File(file, "ref-data"));
        system.entities = Entities.createInstance(system, new File(file, "entity"));
        system.relationships = Relationships.createInstance(system, new File(file, "relationships"));
        return system;
    }

    private static void loadSystemFields(System system, XmlElement xmlElement, XmlElement xmlElement2) {
        System.loadRecognizedSystemFields(system, xmlElement);
        System.loadDefaultSystemFields(system, xmlElement2);
    }

    private static void loadRecognizedSystemFields(System system, XmlElement xmlElement) {
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        SystemField systemField = null;
        Object var4_4 = null;
        nullFreeCollection = xmlElement.getOptionalElements("system-field");
        system.recognizedSystemFields = CollectionUtils.getOrderedMap(new HashMap(nullFreeCollection.size()));
        for (XmlElement xmlElement2 : nullFreeCollection) {
            systemField = SystemField.createInstance(system, xmlElement2);
            system.recognizedSystemFields.put(systemField.getIdentifier(), systemField);
        }
    }

    private static void loadDefaultSystemFields(System system, XmlElement xmlElement) {
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        Constants.SystemFieldIdentifier systemFieldIdentifier = null;
        nullFreeCollection = xmlElement.getOptionalElements("system-field-identifier");
        system.defaultSystemFields = CollectionUtils.getOrderedMap(new HashMap(nullFreeCollection.size()));
        for (XmlElement xmlElement2 : nullFreeCollection) {
            systemFieldIdentifier = Constants.SystemFieldIdentifier.get(xmlElement2.getText());
            system.defaultSystemFields.put(systemFieldIdentifier, system.recognizedSystemFields.get((Object)systemFieldIdentifier));
        }
    }
}

