/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.objectmodel;

import com.jronimo.util.Logger;
import com.jronimo.util.NameFormat;
import com.jronimo.xml.XmlElement;

public class SequenceSource {
    private static final Logger logger = Logger.getLogger(SequenceSource.class);
    private Type type;
    private String tableName;
    private String prefix;

    private SequenceSource() {
    }

    public Type getType() {
        return this.type;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isNone() {
        return this.type.isNone();
    }

    public boolean isTable() {
        return this.type.isTable();
    }

    public boolean isDatabase() {
        return this.type.isDatabase();
    }

    public static SequenceSource createInstance(XmlElement xmlElement) {
        SequenceSource sequenceSource = null;
        sequenceSource = new SequenceSource();
        sequenceSource.type = Type.get(xmlElement.getText("type"));
        sequenceSource.tableName = xmlElement.getOptionalText("table-name");
        sequenceSource.prefix = xmlElement.getOptionalText("prefix");
        return sequenceSource;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NONE,
        TABLE,
        DATABASE;


        public boolean isNone() {
            return this == NONE;
        }

        public boolean isTable() {
            return this == TABLE;
        }

        public boolean isDatabase() {
            return this == DATABASE;
        }

        public static Type get(String string) {
            Type type = null;
            string = new NameFormat(string).getUpperCase();
            for (Type type2 : Type.values()) {
                if (!type2.toString().equals(string)) continue;
                type = type2;
                break;
            }
            return type;
        }
    }
}

