/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.objectmodel;

import com.jronimo.collections.NullFreeImmutableSet;
import com.jronimo.collections.NullFreeMutableSet;
import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.collections.collection.types.nullfree.NullFreeSetCollection;
import com.jronimo.util.Logger;
import com.jronimo.util.NameFormat;
import com.jronimo.webdata.core.Constants;
import com.jronimo.webdata.objectmodel.System;
import com.jronimo.xml.XmlElement;
import java.util.Collection;

public class Relationship {
    private static final Logger logger = Logger.getLogger(Relationship.class);
    private System system;
    private String name;
    private String referer;
    private String referee;
    private Constants.RelationshipType type;
    private boolean ownerTypeMultiplicityIsMany;
    private boolean isBiDirectional;
    private boolean cascadeDelete;
    private Multiplicity forwardMultiplicity;
    private Multiplicity backwardMultiplicity;
    private String refererVirtualField;
    private String refereeVirtualField;
    private Link link;

    private Relationship(System system) {
        this.system = system;
    }

    public String getName() {
        return this.name;
    }

    public String getReferer() {
        return this.referer;
    }

    public String getReferee() {
        return this.referee;
    }

    public Constants.RelationshipType getType() {
        return this.type;
    }

    public boolean ownerTypeMultiplicityIsMany() {
        return this.ownerTypeMultiplicityIsMany;
    }

    public boolean isBiDirectional() {
        return this.isBiDirectional;
    }

    public boolean cascadeDelete() {
        return this.cascadeDelete;
    }

    public Multiplicity getForwardMultiplicity() {
        return this.forwardMultiplicity;
    }

    public Multiplicity getBackwardMultiplicity() {
        return this.backwardMultiplicity;
    }

    public boolean hasRefererVirtualField() {
        return this.refererVirtualField != null;
    }

    public String getRefererVirtualField() {
        return this.refererVirtualField;
    }

    public boolean hasRefereeVirtualField() {
        return this.refereeVirtualField != null;
    }

    public String getRefereeVirtualField() {
        return this.refereeVirtualField;
    }

    public Link getLink() {
        return this.link;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        Relationship relationship = null;
        if (object instanceof Relationship) {
            relationship = (Relationship)object;
            bl = relationship.name.equals(this.name);
        }
        return bl;
    }

    static Relationship createInstance(System system, XmlElement xmlElement) {
        Relationship relationship = null;
        Boolean bl = null;
        relationship = new Relationship(system);
        relationship.name = xmlElement.getText("name");
        relationship.referer = xmlElement.getText("referer");
        relationship.referee = xmlElement.getText("referee");
        relationship.type = Constants.RelationshipType.get(xmlElement.getText("type"));
        if (xmlElement.hasElement("owner-type-multiplicity")) {
            relationship.ownerTypeMultiplicityIsMany = xmlElement.getText("owner-type-multiplicity").equals("many");
        }
        if (relationship.type.isOwnership()) {
            bl = xmlElement.getBoolean("is-bi-directional");
        } else if (relationship.type.isReference()) {
            bl = false;
        } else if (relationship.type.isAssociation()) {
            bl = true;
        }
        relationship.isBiDirectional = bl;
        relationship.cascadeDelete = xmlElement.getOptionalBoolean("cascade-delete", "true");
        relationship.forwardMultiplicity = Relationship.createMultiplicityInstance(xmlElement.getElement("forward-multiplicity"));
        relationship.backwardMultiplicity = Relationship.createMultiplicityInstance(xmlElement.getElement("backward-multiplicity"));
        relationship.link = Relationship.createLinkInstance(xmlElement.getElement("link"));
        relationship.refererVirtualField = xmlElement.getOptionalText("virtual-fields/referer-virtual-field/field-name");
        relationship.refereeVirtualField = xmlElement.getOptionalText("virtual-fields/referee-virtual-field/field-name");
        return relationship;
    }

    private static Multiplicity createMultiplicityInstance(XmlElement xmlElement) {
        Multiplicity multiplicity = null;
        boolean bl = false;
        Integer n = null;
        Integer n2 = null;
        bl = xmlElement.getText("multiplicity").equals("many");
        if (bl) {
            n = xmlElement.getOptionalInteger("min", "0");
            n2 = xmlElement.getOptionalInteger("max");
        } else {
            n = xmlElement.getOptionalBoolean("optional", "true") != false ? 0 : 1;
            n2 = 1;
        }
        multiplicity = new Multiplicity(bl, n, n2);
        return multiplicity;
    }

    private static Link createLinkInstance(XmlElement xmlElement) {
        Link link = null;
        LinkType linkType = null;
        LinkMechanism linkMechanism = null;
        String string = null;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        NullFreeMutableSet<Mapping> nullFreeMutableSet = null;
        linkType = LinkType.get(xmlElement.getText("type"));
        linkMechanism = xmlElement.hasElement("mechanism") ? LinkMechanism.get(xmlElement.getText("mechanism")) : (linkType.isRefererHeld() || linkType.isRefereeHeld() ? LinkMechanism.FIELD : LinkMechanism.LINK_ENTITY);
        if (linkMechanism.isLinkEntity()) {
            string = xmlElement.getText("link-entity");
        }
        nullFreeCollection = xmlElement.getElements("field-mappings/mapping");
        nullFreeMutableSet = new NullFreeMutableSet<Mapping>(nullFreeCollection.size());
        for (XmlElement xmlElement2 : nullFreeCollection) {
            nullFreeMutableSet.add(Relationship.createMappingInstance(xmlElement2));
        }
        link = new Link(linkType, linkMechanism, string, nullFreeMutableSet);
        return link;
    }

    private static Mapping createMappingInstance(XmlElement xmlElement) {
        Mapping mapping = null;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        nullFreeCollection = xmlElement.getElements("member");
        mapping = new Mapping(Relationship.createMappingElementInstance((XmlElement)nullFreeCollection.get(0)), Relationship.createMappingElementInstance((XmlElement)nullFreeCollection.get(1)));
        return mapping;
    }

    private static MappingMember createMappingElementInstance(XmlElement xmlElement) {
        MappingMember mappingMember = null;
        mappingMember = new MappingMember(xmlElement.getText("entity-name"), xmlElement.getText("field-name"));
        return mappingMember;
    }

    public static class MappingMember {
        private String entityName;
        private String fieldName;

        MappingMember(String string, String string2) {
            this.entityName = string;
            this.fieldName = string2;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public int hashCode() {
            int n = 17;
            n = n * 37 + this.entityName.hashCode();
            n = n * 37 + this.fieldName.hashCode();
            return n;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            MappingMember mappingMember = null;
            if (object instanceof MappingMember) {
                mappingMember = (MappingMember)object;
                if (mappingMember.entityName.equals(this.entityName) && mappingMember.fieldName.equals(this.fieldName)) {
                    bl = true;
                }
            }
            return bl;
        }
    }

    public static class Mapping {
        private MappingMember memberOne;
        private MappingMember memberTwo;

        Mapping(MappingMember mappingMember, MappingMember mappingMember2) {
            this.memberOne = mappingMember;
            this.memberTwo = mappingMember2;
        }

        public MappingMember getMemberOne() {
            return this.memberOne;
        }

        public MappingMember getMemberTwo() {
            return this.memberTwo;
        }

        public int hashCode() {
            int n = 17;
            n = n * 37 + this.memberOne.hashCode();
            n = n * 37 + this.memberTwo.hashCode();
            return n;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            Mapping mapping = null;
            if (object instanceof Mapping) {
                mapping = (Mapping)object;
                if (mapping.memberOne.equals(this.memberOne) && mapping.memberTwo.equals(this.memberTwo)) {
                    bl = true;
                }
            }
            return bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Link {
        private LinkType type;
        private LinkMechanism mechanism;
        private String linkEntity;
        private NullFreeImmutableSet<Mapping> mappings;

        Link(LinkType linkType, LinkMechanism linkMechanism, String string, NullFreeSetCollection<Mapping> nullFreeSetCollection) {
            this.type = linkType;
            this.mechanism = linkMechanism;
            this.linkEntity = string;
            this.mappings = new NullFreeImmutableSet<Mapping>((Collection<Mapping>)nullFreeSetCollection);
        }

        public LinkType getType() {
            return this.type;
        }

        public LinkMechanism getMechanism() {
            return this.mechanism;
        }

        public String getLinkEntity() {
            return this.linkEntity;
        }

        public NullFreeImmutableSet<Mapping> getMappings() {
            return this.mappings;
        }
    }

    public static class Multiplicity {
        private boolean isMany;
        private int min;
        private Integer max;

        Multiplicity(boolean bl, int n, Integer n2) {
            this.isMany = bl;
            this.min = n;
            this.max = n2;
        }

        public boolean isMany() {
            return this.isMany;
        }

        public int getMin() {
            return this.min;
        }

        public Integer getMax() {
            return this.max;
        }

        private boolean isUnbounded() {
            return this.max == null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LinkMechanism {
        FIELD,
        LINK_ENTITY;


        public boolean isField() {
            return this == FIELD;
        }

        public boolean isLinkEntity() {
            return this == LINK_ENTITY;
        }

        public static LinkMechanism get(String string) {
            LinkMechanism linkMechanism = null;
            string = new NameFormat(string).getUpperCase();
            for (LinkMechanism linkMechanism2 : LinkMechanism.values()) {
                if (!linkMechanism2.toString().equals(string)) continue;
                linkMechanism = linkMechanism2;
                break;
            }
            return linkMechanism;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LinkType {
        REFERER_HELD,
        REFEREE_HELD,
        DEDICATED_LINK,
        SHARED_LINK;


        public boolean isRefererHeld() {
            return this == REFERER_HELD;
        }

        public boolean isRefereeHeld() {
            return this == REFEREE_HELD;
        }

        public boolean isDedicatedLink() {
            return this == DEDICATED_LINK;
        }

        public boolean isSharedLink() {
            return this == SHARED_LINK;
        }

        public static LinkType get(String string) {
            LinkType linkType = null;
            string = new NameFormat(string).getUpperCase();
            for (LinkType linkType2 : LinkType.values()) {
                if (!linkType2.toString().equals(string)) continue;
                linkType = linkType2;
                break;
            }
            return linkType;
        }
    }
}

