/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.objectmodel;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.util.Logger;
import com.jronimo.webdata.objectmodel.RefDataCategory;
import com.jronimo.webdata.objectmodel.RefDataItem;
import com.jronimo.webdata.objectmodel.System;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class RefDataCategories {
    private static final Logger logger = Logger.getLogger(RefDataCategories.class);
    private Map<Long, RefDataItem> index = new HashMap<Long, RefDataItem>(1000);
    private Map<String, RefDataCategory> categories;

    private RefDataCategories() {
    }

    public RefDataCategory getRefDataCategory(String string) {
        return this.categories.get(string);
    }

    public RefDataItem getRefDataItem(String string) {
        RefDataItem refDataItem = null;
        int n = 0;
        RefDataCategory refDataCategory = null;
        n = string.lastIndexOf(".");
        refDataCategory = this.getRefDataCategory(string.substring(0, n));
        refDataItem = refDataCategory.get(string.substring(n + 1));
        return refDataItem;
    }

    public RefDataItem getRefDataItem(long l) {
        return this.index.get(l);
    }

    static RefDataCategories createInstance(System system, File file) {
        RefDataCategories refDataCategories = null;
        File[] fileArray = null;
        RefDataCategory refDataCategory = null;
        fileArray = file.listFiles();
        refDataCategories = new RefDataCategories();
        refDataCategories.categories = CollectionUtils.getOrderedMap(new HashMap(fileArray.length));
        for (File file2 : fileArray) {
            if (!file2.isFile()) continue;
            refDataCategory = RefDataCategory.createInstance(system, XmlElementFactory.load(file2));
            refDataCategories.categories.put(refDataCategory.getName(), refDataCategory);
            for (RefDataItem refDataItem : refDataCategory.getItems().values()) {
                refDataCategories.index.put(refDataItem.getId(), refDataItem);
            }
        }
        return refDataCategories;
    }
}

