/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.objectmodel;

import com.jronimo.collections.NullFreeMutableSet;
import com.jronimo.collections.collection.decorations.NullFreeImmutableSet_U;
import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.util.Logger;
import com.jronimo.webdata.core.Constants;
import com.jronimo.webdata.objectmodel.Entity;
import com.jronimo.webdata.objectmodel.Field;
import com.jronimo.webdata.objectmodel.System;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlUtils;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimaryKey {
    private static final Logger logger = Logger.getLogger(PrimaryKey.class);
    private System system;
    private Constants.PrimaryKeyType type;
    private String sequenceName;
    private NullFreeImmutableSet_U<String> fieldNames;

    public PrimaryKey(System system, Constants.PrimaryKeyType primaryKeyType, String string) {
        this.system = system;
        this.type = primaryKeyType;
        this.sequenceName = string;
    }

    public System getSystem() {
        return this.system;
    }

    public Constants.PrimaryKeyType getType() {
        return this.type;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public NullFreeImmutableSet_U<String> getFieldNames() {
        return this.fieldNames;
    }

    public int getFieldCount() {
        return this.fieldNames.size();
    }

    public Field getSingleField(Entity entity) {
        Field field = null;
        field = entity.getField(this.getSingleFieldName());
        return field;
    }

    public String getSingleFieldName() {
        return (String)this.fieldNames.getFirst();
    }

    public NullFreeImmutableSet_U<Field> getFields(Entity entity) {
        NullFreeImmutableSet_U<Field> nullFreeImmutableSet_U = null;
        NullFreeMutableSet<Field> nullFreeMutableSet = null;
        nullFreeMutableSet = new NullFreeMutableSet<Field>(this.fieldNames.size());
        for (String string : this.fieldNames) {
            nullFreeMutableSet.add(entity.getField(string));
        }
        nullFreeImmutableSet_U = new NullFreeImmutableSet_U<Field>((Collection<Field>)nullFreeMutableSet);
        return nullFreeImmutableSet_U;
    }

    public boolean isPrimaryKeyField(String string) {
        return this.fieldNames.contains(string);
    }

    public boolean isSystemManaged() {
        return this.type.isSystemManaged();
    }

    public boolean isAutoNumber() {
        return this.type.isAutoNumber();
    }

    public boolean isCompoundImmutable() {
        return this.type.isCompoundImmutable();
    }

    public boolean isCompoundMutable() {
        return this.type.isCompoundMutable();
    }

    public static PrimaryKey createInstance(System system, XmlElement xmlElement) {
        PrimaryKey primaryKey = null;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        primaryKey = new PrimaryKey(system, Constants.PrimaryKeyType.get(xmlElement.getText("type")), xmlElement.getOptionalText("sequence-name"));
        nullFreeCollection = xmlElement.getOptionalElements("fields/field-name");
        primaryKey.fieldNames = new NullFreeImmutableSet_U<String>((Collection<String>)XmlUtils.getTextFromElements(nullFreeCollection));
        return primaryKey;
    }
}

