/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.objectmodel;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.util.Logger;
import com.jronimo.util.NameFormat;
import com.jronimo.webdata.objectmodel.FieldConstraints;
import com.jronimo.webdata.objectmodel.System;
import com.jronimo.xml.XmlElement;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintSet {
    private static final Logger logger = Logger.getLogger(ConstraintSet.class);
    private System system;
    private String name;
    private boolean isDefault;
    private Map<String, FieldConstraints> allFieldConstraints;

    public ConstraintSet(System system, String string) {
        this.name = string;
        this.system = system;
        if (new NameFormat(string).getCamelCase().equals("Default")) {
            this.isDefault = true;
        }
    }

    public System getSystem() {
        return this.system;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public Map<String, FieldConstraints> getAllFieldConstraints() {
        return this.allFieldConstraints;
    }

    public FieldConstraints getFieldConstraints(String string) {
        return this.allFieldConstraints.get(string);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        ConstraintSet constraintSet = null;
        if (object instanceof ConstraintSet) {
            constraintSet = (ConstraintSet)object;
            bl = constraintSet.name.equals(this.name);
        }
        return bl;
    }

    public static ConstraintSet createInstance(System system, XmlElement xmlElement) {
        ConstraintSet constraintSet = null;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        FieldConstraints fieldConstraints = null;
        constraintSet = new ConstraintSet(system, xmlElement.getText("name"));
        nullFreeCollection = xmlElement.getOptionalElements("fields/field");
        constraintSet.allFieldConstraints = CollectionUtils.getOrderedMap(new HashMap(nullFreeCollection.size()));
        for (XmlElement xmlElement2 : nullFreeCollection) {
            fieldConstraints = FieldConstraints.createInstance(system, xmlElement2);
            constraintSet.allFieldConstraints.put(fieldConstraints.getFieldName(), fieldConstraints);
        }
        return constraintSet;
    }
}

