/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.objectmodel;

import com.jronimo.util.Logger;
import com.jronimo.webdata.core.Constants;
import com.jronimo.webdata.objectmodel.System;
import com.jronimo.xml.XmlElement;
import java.util.Map;

public abstract class AbstractRefData {
    private static final Logger logger = Logger.getLogger(AbstractRefData.class);
    private System system;
    private Long id;
    private String name;
    private String parentIdentifier;
    private Long displayTextId;
    private String displayTextIdentifier;
    private Constants.Status status;
    protected Map<String, String> properties;

    protected AbstractRefData() {
    }

    public System getSystem() {
        return this.system;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Long getDisplayTextId() {
        return this.displayTextId;
    }

    public String getDisplayTextIdentifier() {
        return this.displayTextIdentifier;
    }

    public Constants.Status getStatus() {
        return this.status;
    }

    public boolean isActive() {
        return this.status.isActive();
    }

    public boolean isExpired() {
        return this.status.isExpired();
    }

    public boolean isHidden() {
        return this.status.isHidden();
    }

    public String getProperty(String string) {
        return this.properties.get(string);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        AbstractRefData abstractRefData = null;
        if (object instanceof AbstractRefData) {
            abstractRefData = (AbstractRefData)object;
            bl = abstractRefData.id == this.id;
        }
        return bl;
    }

    protected static void populatedInstance(AbstractRefData abstractRefData, System system, XmlElement xmlElement) {
        abstractRefData.system = system;
        abstractRefData.id = xmlElement.getLong("id");
        abstractRefData.name = xmlElement.getText("identifier");
        abstractRefData.displayTextIdentifier = xmlElement.getText("display-text-identifier");
        abstractRefData.status = Constants.Status.get(xmlElement.getText("active"));
        abstractRefData.displayTextIdentifier = xmlElement.getName().equals("category") ? "refdata.categories." + abstractRefData.name : "refdata." + xmlElement.getParent().getText("identifier") + ".items." + abstractRefData.name;
        abstractRefData.displayTextId = system.getTextGroups().getTextElement(abstractRefData.displayTextIdentifier).getId();
    }
}

