/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.generate.xmlengine;

import com.jronimo.util.Logger;
import com.jronimo.webdata.generate.xmlengine.Project;
import com.jronimo.webdata.generate.xmlengine.TextGroup;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class TextGroups {
    private static final Logger logger = Logger.getLogger(TextGroups.class);
    private Project project;
    private File destinationTextDirectory;
    private Map<String, TextGroup> textGroups = new HashMap<String, TextGroup>();

    TextGroups(Project project) {
        this.project = project;
        this.destinationTextDirectory = new File(project.getBuildDirectory(), "text");
        this.init();
    }

    private void init() {
        TextGroup textGroup = null;
        for (File file : this.destinationTextDirectory.listFiles()) {
            textGroup = TextGroup.createInstance(this.project, file);
            this.textGroups.put(textGroup.getIdentifier(), textGroup);
        }
    }

    public TextGroup getTextGroup(String string) {
        TextGroup textGroup = null;
        File file = null;
        textGroup = this.textGroups.get(string);
        if (textGroup == null) {
            file = new File(this.destinationTextDirectory, string + ".xml");
            textGroup = new TextGroup(this.project, file, this.project.retrieveProjectId("textgroup." + string), string);
        }
        return textGroup;
    }

    public void deleteTextGroup(String string) {
        TextGroup textGroup = null;
        textGroup = this.textGroups.get(string);
        if (textGroup != null) {
            textGroup.delete();
            this.textGroups.remove(string);
        }
    }
}

