/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.generate.xmlengine;

import com.jronimo.util.Logger;
import com.jronimo.webdata.generate.xmlengine.Project;
import com.jronimo.webdata.generate.xmlengine.TextElement;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TextGroup {
    private static final Logger logger = Logger.getLogger(TextGroup.class);
    private Project project;
    private File file;
    private Long id;
    private String identifier;
    private List<TextElement> textElements = new ArrayList<TextElement>();

    TextGroup(Project project, File file, Long l, String string) {
        this.project = project;
        this.file = file;
        this.id = l;
        this.identifier = string;
    }

    public Long getId() {
        return this.id;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public synchronized void setTextElement(String string, String string2) {
        TextElement textElement = null;
        textElement = this.retrieveTextElement(string);
        if (textElement == null) {
            textElement = new TextElement(this.project.retrieveProjectId("textelement." + this.identifier + "." + string), string, string2);
            this.textElements.add(textElement);
        }
        textElement.setDefaultText(string2);
    }

    public synchronized void removeTextElement(String string) {
        int n = 0;
        n = this.indexOfTextElement(string);
        if (n >= 0) {
            this.textElements.remove(n);
        }
    }

    public synchronized TextGroup clear() {
        this.textElements.clear();
        return this;
    }

    synchronized void delete() {
        this.textElements.clear();
        this.file.delete();
    }

    public synchronized void save() {
        XmlElement xmlElement = null;
        XmlElement xmlElement2 = null;
        XmlElement xmlElement3 = null;
        xmlElement = XmlElementFactory.create("text-group");
        xmlElement.addElement("id").setLong(this.id);
        xmlElement.addElement("identifier").setText(this.identifier);
        xmlElement2 = xmlElement.addElement("text-elements");
        for (TextElement textElement : this.textElements) {
            xmlElement3 = xmlElement2.addElement("text-element");
            xmlElement3.addElement("id").setLong(textElement.getId());
            xmlElement3.addElement("name").setText(textElement.getName());
            xmlElement3.addElement("default-text").setText(textElement.getDefaultText());
        }
        xmlElement.save(this.file);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        TextGroup textGroup = null;
        if (object instanceof TextGroup) {
            textGroup = (TextGroup)object;
            bl = this.id == textGroup.id;
        }
        return bl;
    }

    private int indexOfTextElement(String string) {
        int n = -1;
        int n2 = -1;
        boolean bl = false;
        for (TextElement textElement : this.textElements) {
            ++n2;
            if (!textElement.getName().equals(string)) continue;
            bl = true;
            break;
        }
        if (bl) {
            n = n2;
        }
        return n;
    }

    private TextElement retrieveTextElement(String string) {
        TextElement textElement = null;
        for (TextElement textElement2 : this.textElements) {
            if (!textElement2.getName().equals(string)) continue;
            textElement = textElement2;
            break;
        }
        return textElement;
    }

    static TextGroup createInstance(Project project, File file) {
        TextGroup textGroup = null;
        XmlElement xmlElement = null;
        xmlElement = XmlElementFactory.load(file);
        textGroup = new TextGroup(project, file, xmlElement.getLong("id"), xmlElement.getText("identifier"));
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("text-elements/text-element")) {
            textGroup.textElements.add(TextElement.createInstance(xmlElement2));
        }
        return textGroup;
    }
}

