/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.generate.xmlengine;

import com.jronimo.collections.NullFreeImmutableSet;
import com.jronimo.collections.NullFreeMutableSet;
import com.jronimo.collections.collection.types.Collection;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.util.DateUtils;
import com.jronimo.util.FileMethods;
import com.jronimo.util.Logger;
import com.jronimo.webdata.generate.xmlengine.AssignedIds;
import com.jronimo.webdata.generate.xmlengine.CleanPre;
import com.jronimo.webdata.generate.xmlengine.IdSource;
import com.jronimo.webdata.generate.xmlengine.Module;
import com.jronimo.webdata.generate.xmlengine.ProcessedFiles;
import com.jronimo.webdata.generate.xmlengine.TextGroups;
import com.jronimo.webdata.generate.xmlengine.generate.ProcessEntities;
import com.jronimo.webdata.generate.xmlengine.generate.ProcessRefData;
import com.jronimo.webdata.generate.xmlengine.generate.ProcessRelationships;
import com.jronimo.webdata.generate.xmlengine.originalhack.ReverseGenerateRefDataSkeleton;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project {
    private static final Logger logger = Logger.getLogger(Project.class);
    private File projectDirectory;
    private XmlElement xmlDocument;
    private File sourceDirectory;
    private File destinationDirectory;
    private File buildDirectory;
    private File backupDirectory;
    private File outDirectory;
    private String name;
    private NullFreeMutableSet<String> imports = new NullFreeMutableSet();
    private NullFreeMutableSet<Module> modules = new NullFreeMutableSet();
    private NullFreeMutableSet<String> exports = new NullFreeMutableSet();
    private IdSource projectIds;
    private NullFreeMutableSet<IdSource> refDataItemsIdSources = new NullFreeMutableSet();
    private AssignedIds assignedIds;
    private ProcessedFiles processedFiles;
    private TextGroups textGroups;

    private Project(File file, XmlElement xmlElement) {
        String string = null;
        this.projectDirectory = file;
        this.xmlDocument = xmlElement;
        string = String.valueOf(DateUtils.getUniqueDateTimeTemporalValue(true));
        this.sourceDirectory = new File(file, "definition/A");
        this.destinationDirectory = new File(file, "definition/B");
        this.buildDirectory = new File(file, "build/" + string);
        this.backupDirectory = new File(file, "build/backup/" + string);
        this.outDirectory = new File(file, "out");
        this.destinationDirectory.mkdir();
        new File(this.destinationDirectory, "ref-data").mkdir();
        new File(this.destinationDirectory, "entity").mkdir();
        new File(this.destinationDirectory, "relationships").mkdir();
        new File(this.destinationDirectory, "text").mkdir();
        this.outDirectory.mkdir();
        new File(this.outDirectory, "client-artifacts").mkdir();
        new File(this.outDirectory, "server-artifacts").mkdir();
        new File(this.outDirectory, "system").mkdir();
    }

    public String getName() {
        return this.name;
    }

    public boolean isCore() {
        return this.name.equals("Core");
    }

    public File getProjectDirectory() {
        return this.projectDirectory;
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public File getBuildDirectory() {
        return this.buildDirectory;
    }

    public IdSource getRefDataIdSource(String string) {
        IdSource idSource = null;
        for (IdSource idSource2 : this.refDataItemsIdSources) {
            if (!idSource2.getName().equals(string)) continue;
            idSource = idSource2;
            break;
        }
        return idSource;
    }

    public ProcessedFiles getProcessedFiles() {
        return this.processedFiles;
    }

    public TextGroups getTextGroups() {
        return this.textGroups;
    }

    Module getModule(String string) {
        Module module = null;
        for (Module module2 : this.modules) {
            if (!module2.getName().equals(string)) continue;
            module = module2;
            break;
        }
        return module;
    }

    public synchronized void reverseRefDataSkeleton(NullFreeImmutableSet<String> nullFreeImmutableSet) {
        for (String string : nullFreeImmutableSet) {
            new ReverseGenerateRefDataSkeleton(this.projectDirectory, string).execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void generate() {
        long l = System.currentTimeMillis();
        File file = null;
        File file2 = null;
        Exception exception = null;
        try {
            this.buildDirectory.mkdir();
            new File(this.buildDirectory, "ref-data").mkdir();
            new File(this.buildDirectory, "entity").mkdir();
            new File(this.buildDirectory, "relationships").mkdir();
            new File(this.buildDirectory, "text").mkdir();
            FileMethods.copyDirectoryContentsTo(this.destinationDirectory, this.buildDirectory);
            this.textGroups = new TextGroups(this);
            new CleanPre(this).execute();
            new ProcessRefData(this).execute();
            new ProcessEntities(this).execute();
            new ProcessRelationships(this).execute();
            this.backupDirectory.mkdir();
            FileMethods.copyDirectoryContentsTo(this.destinationDirectory, this.backupDirectory);
            FileMethods.deleteFolderContents(this.destinationDirectory, false);
            FileMethods.copyDirectoryContentsTo(this.buildDirectory, this.destinationDirectory);
            file = new File(this.outDirectory, "system");
            file2 = new File(file, "system.xml");
            FileMethods.deleteFolderContents(file, false);
            FileMethods.copyDirectoryContentsTo(this.buildDirectory, file);
            FileMethods.copyFileTo(new File(this.projectDirectory, "system.xml"), file2);
            file2.setReadOnly();
            this.xmlDocument.save(new File(this.projectDirectory, "project.xml"));
            this.assignedIds.save();
            this.processedFiles.save();
        }
        catch (Exception exception2) {
            exception = exception2;
            exception2.printStackTrace();
        }
        finally {
            try {
                FileMethods.deleteFolderContents(this.buildDirectory, true);
            }
            catch (Exception exception3) {}
        }
        logger.debug("Duration: " + (System.currentTimeMillis() - l));
        if (exception != null) {
            throw new UnexpectedErrorException(exception);
        }
    }

    public synchronized Long retrieveProjectId(String string) {
        Long l = null;
        l = this.assignedIds.get(string);
        if (l == null) {
            l = this.projectIds.next();
            this.assignedIds.lodge(string, l);
        }
        return l;
    }

    public synchronized Long retrieveRefDataItemId(String string, String string2) {
        Long l = null;
        IdSource idSource = null;
        String string3 = null;
        idSource = this.getRefDataIdSource(string);
        if (idSource == null) {
            string3 = "refdataitem." + string + "." + string2;
            l = this.assignedIds.get(string3);
            if (l == null) {
                l = this.projectIds.next();
                this.assignedIds.lodge(string3, l);
            }
        } else {
            l = idSource.next();
        }
        return l;
    }

    static Project createInstance(File file) {
        Project project = null;
        XmlElement xmlElement = null;
        xmlElement = XmlElementFactory.load(new File(file, "project.xml"));
        project = new Project(file, xmlElement);
        project.name = xmlElement.getText("name");
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("import-modules/module-identifier")) {
            project.imports.add(xmlElement2.getText());
        }
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("modules/module")) {
            project.modules.add(Module.createInstance(xmlElement2));
        }
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("export-modules/module-name")) {
            project.exports.add(xmlElement2.getText());
        }
        project.projectIds = IdSource.createInstance(xmlElement.getElement("ids-config/project-ids"));
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("ids-config/ref-data-items/ref-data-category")) {
            project.refDataItemsIdSources.add(IdSource.createInstance(xmlElement2));
        }
        project.assignedIds = new AssignedIds(project);
        project.processedFiles = new ProcessedFiles(project);
        return project;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestProxy {
        private Project instance;

        public TestProxy(Project project) {
            this.instance = project;
        }

        public Project getInstance() {
            return this.instance;
        }

        public Collection<String> getImports() {
            return this.instance.imports;
        }

        public Collection<Module> getModules() {
            return this.instance.modules;
        }

        public Collection<String> getExports() {
            return this.instance.exports;
        }

        public IdSource getProjectIdSource() {
            return this.instance.projectIds;
        }

        public Collection<IdSource> getRefDataItemsIdSources() {
            return this.instance.refDataItemsIdSources;
        }

        public Module getModule(String string) {
            return this.instance.getModule(string);
        }
    }
}

