/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.generate.xmlengine;

import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import com.jronimo.util.NamedValuePairFile;
import com.jronimo.util.StringWrapper;
import com.jronimo.webdata.generate.xmlengine.Project;
import java.io.File;

public class ProcessedFiles {
    private static final Logger logger = Logger.getLogger(ProcessedFiles.class);
    private Project project;
    private String directoryPrefix;
    private NamedValuePairFile namedValuePairFile;

    ProcessedFiles(Project project) {
        this.project = project;
        this.directoryPrefix = project.getSourceDirectory().getPath();
        this.namedValuePairFile = new NamedValuePairFile(new File(this.project.getProjectDirectory(), "processed-files.txt"));
    }

    public boolean isModified(File file) {
        boolean bl = false;
        StringWrapper stringWrapper = null;
        Assert.errorParamMustNotBeNull("file", file);
        stringWrapper = new StringWrapper(file.getPath()).deleteFirst(this.directoryPrefix);
        bl = !this.namedValuePairFile.has(stringWrapper.toString(), String.valueOf(file.lastModified()));
        return bl;
    }

    public void lodge(File file) {
        StringWrapper stringWrapper = null;
        Assert.errorParamMustNotBeNull("file", file);
        stringWrapper = new StringWrapper(file.getPath()).deleteFirst(this.directoryPrefix);
        this.namedValuePairFile.lodge(stringWrapper.toString(), String.valueOf(file.lastModified()));
    }

    void save() {
        this.namedValuePairFile.save();
    }
}

