/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.generate.xmlengine;

import com.jronimo.util.FileMethods;
import com.jronimo.util.Logger;
import com.jronimo.webdata.generate.xmlengine.Project;
import com.jronimo.webdata.generate.xmlengine.TextGroup;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanPre {
    private static final Logger logger = Logger.getLogger(CleanPre.class);
    private Project project;
    private File sourceRefDataDirectory;
    private File sourceEntityDirectory;
    private File sourceRelationshipsDirectory;
    private File destinationRefDataDirectory;
    private File destinationEntityDirectory;
    private File destinationRelationshipsDirectory;
    private TextGroup refDataCategoriesTextGroup;
    private List<String> unwantedRefDataCategories = new ArrayList<String>();
    private List<String> unwantedEntities = new ArrayList<String>();

    CleanPre(Project project) {
        this.project = project;
        this.sourceRefDataDirectory = new File(project.getSourceDirectory(), "ref-data");
        this.sourceEntityDirectory = new File(project.getSourceDirectory(), "entity");
        this.sourceRelationshipsDirectory = new File(project.getSourceDirectory(), "relationships");
        this.destinationRefDataDirectory = new File(project.getBuildDirectory(), "ref-data");
        this.destinationEntityDirectory = new File(project.getBuildDirectory(), "entity");
        this.destinationRelationshipsDirectory = new File(project.getBuildDirectory(), "relationships");
        this.refDataCategoriesTextGroup = project.getTextGroups().getTextGroup("refdata.categories");
    }

    void execute() {
        this.assembleUnwanteds(this.sourceRefDataDirectory, this.destinationRefDataDirectory, this.unwantedRefDataCategories);
        this.assembleUnwanteds(this.sourceEntityDirectory, this.destinationEntityDirectory, this.unwantedEntities);
        this.assembleUnwanteds(this.sourceRelationshipsDirectory, this.destinationRelationshipsDirectory, null);
        this.cleanRefDataCategoriesTextGroup();
        this.deleteUnwantedRefDataTextGroups();
        this.deleteUnwantedEntityTextGroups();
        this.checkRelationships();
    }

    private void assembleUnwanteds(File file, File file2, List<String> list) {
        ArrayList<String> arrayList = null;
        String string = null;
        if (list == null) {
            list = new ArrayList<String>();
        }
        arrayList = new ArrayList<String>();
        for (File file3 : file.listFiles()) {
            if (!file3.isFile()) continue;
            arrayList.add(FileMethods.extractNameFromFilename(file3.getName()));
        }
        for (File file3 : file2.listFiles()) {
            if (!file3.isFile() || arrayList.contains(string = FileMethods.extractNameFromFilename(file3.getName()))) continue;
            file3.delete();
            list.add(string);
        }
    }

    private void cleanRefDataCategoriesTextGroup() {
        for (String string : this.unwantedRefDataCategories) {
            this.refDataCategoriesTextGroup.removeTextElement(string);
        }
        this.refDataCategoriesTextGroup.save();
    }

    private void deleteUnwantedRefDataTextGroups() {
        String string = null;
        for (String string2 : this.unwantedRefDataCategories) {
            string = "refdata." + string2;
            this.project.getTextGroups().deleteTextGroup(string);
        }
    }

    private void deleteUnwantedEntityTextGroups() {
        String string = null;
        for (String string2 : this.unwantedEntities) {
            string = "entity." + string2;
            this.project.getTextGroups().deleteTextGroup(string);
            this.project.getTextGroups().deleteTextGroup(string + ".fields");
        }
    }

    private void checkRelationships() {
        String string = null;
        block0: for (File file : this.sourceRelationshipsDirectory.listFiles()) {
            string = FileMethods.extractNameFromFilename(file.getName());
            for (String string2 : this.unwantedEntities) {
                if (!string.startsWith(string2 + "_") && !string.endsWith("_" + string2)) continue;
                logger.warning("Relationship with non-existing entity: " + string);
                continue block0;
            }
        }
    }
}

