/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.core;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import com.jronimo.webdata.core.CodeType;
import com.jronimo.webdata.core.DataType;
import com.jronimo.webdata.core.DatabaseEngine;
import com.jronimo.webdata.core.DatabaseType;
import com.jronimo.webdata.core.EngineDatabaseType;
import com.jronimo.xml.XmlElement;
import java.util.HashMap;
import java.util.Map;

public final class TypeDefinition {
    private static final Logger logger = Logger.getLogger(TypeDefinition.class);
    private DataType dataType;
    private CodeType codeType;
    private DatabaseType databaseType;
    private Integer capacity;
    private String characterSet;
    private String collation;
    private Integer precision;
    private Integer scale;
    private Map<String, String> parameters = CollectionUtils.getOrderedMap(new HashMap(3));

    private TypeDefinition() {
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public CodeType getCodeType() {
        return this.codeType;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public EngineDatabaseType getEngineDatabaseType(DatabaseEngine databaseEngine) {
        return databaseEngine.getEngineDatabaseType(this.databaseType);
    }

    public boolean hasCapacity() {
        return this.capacity != null;
    }

    public Integer getCapacity() {
        return this.capacity;
    }

    public boolean hasCharacterSet() {
        return this.characterSet != null;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public boolean hasCollation() {
        return this.collation != null;
    }

    public String getCollation() {
        return this.collation;
    }

    public boolean hasPrecision() {
        return this.precision != null;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public boolean hasScale() {
        return this.scale != null;
    }

    public Integer getScale() {
        return this.scale;
    }

    public static TypeDefinition createInstance(XmlElement xmlElement) {
        TypeDefinition typeDefinition = null;
        XmlElement xmlElement2 = null;
        Assert.errorParamMustNotBeNull("rootElement", xmlElement);
        xmlElement2 = xmlElement.getElement("data-type");
        typeDefinition.dataType = DataType.get(xmlElement2.getText("name"));
        typeDefinition = new TypeDefinition();
        TypeDefinition.setDefaults(typeDefinition, typeDefinition.dataType);
        if (xmlElement.hasElement("code-type")) {
            typeDefinition.codeType = CodeType.get(xmlElement.getText("code-type"));
        }
        if (xmlElement.hasElement("database-type")) {
            typeDefinition.databaseType = DatabaseType.get(xmlElement.getText("database-type"));
        }
        typeDefinition.capacity = xmlElement2.getOptionalInteger("capacity");
        typeDefinition.characterSet = xmlElement2.getOptionalText("character-set");
        typeDefinition.collation = xmlElement2.getOptionalText("collation");
        typeDefinition.precision = xmlElement2.getOptionalInteger("precision");
        typeDefinition.scale = xmlElement2.getOptionalInteger("scale");
        for (XmlElement xmlElement3 : xmlElement2.getOptionalElements("parameters/parameter")) {
            typeDefinition.parameters.put(xmlElement3.getText("name"), xmlElement3.getText("value"));
        }
        return typeDefinition;
    }

    private static void setDefaults(TypeDefinition typeDefinition, DataType dataType) {
        for (DataType.Parameter parameter : dataType.getParameters()) {
            if (!parameter.hasDefaultValue()) continue;
            typeDefinition.parameters.put(parameter.getName(), parameter.getDefaultValue());
        }
        typeDefinition.codeType = dataType.getDefaultCodeType();
        typeDefinition.databaseType = dataType.getDefaultDatabaseType();
    }
}

