/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.core;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.util.Logger;
import com.jronimo.webdata.core.Constants;
import com.jronimo.webdata.core.TypeDefinition;
import com.jronimo.webdata.core.resources.PackageMarker;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.util.HashMap;
import java.util.Map;

public final class SystemFieldType {
    private static final Logger logger = Logger.getLogger(SystemFieldType.class);
    private static Map<Constants.SystemFieldIdentifier, SystemFieldType> members;
    private Constants.SystemFieldIdentifier identifier;
    private String defaultFieldName;
    private String defaultPersistenceName;
    private Map<String, TypeDefinition> typeDefinitions;
    private TypeDefinition defaultTypeDefinition;

    private SystemFieldType() {
    }

    public Constants.SystemFieldIdentifier getIdentifier() {
        return this.identifier;
    }

    public String getDefaultFieldName() {
        return this.defaultFieldName;
    }

    public String getDefaultPersistenceName() {
        return this.defaultPersistenceName;
    }

    public TypeDefinition getTypeDefinition(String string) {
        return this.typeDefinitions.get(string);
    }

    public TypeDefinition getDefaultTypeDefinition() {
        return this.defaultTypeDefinition;
    }

    public boolean isSystemManagedId() {
        return this.identifier.isSystemManagedId();
    }

    public boolean isRecordStatus() {
        return this.identifier.isRecordStatus();
    }

    public boolean isRecordVersion() {
        return this.identifier.isRecordVersion();
    }

    public boolean isAuditCreateUserId() {
        return this.identifier.isAuditCreateUserId();
    }

    public boolean isAuditCreateUsername() {
        return this.identifier.isAuditCreateUsername();
    }

    public boolean isAuditCreateTimestamp() {
        return this.identifier.isAuditCreateTimestamp();
    }

    public boolean isAuditUpdateUserId() {
        return this.identifier.isAuditUpdateUserId();
    }

    public boolean isAuditUpdateUsername() {
        return this.identifier.isAuditUpdateUsername();
    }

    public boolean isAuditUpdateTimestamp() {
        return this.identifier.isAuditUpdateTimestamp();
    }

    public static SystemFieldType get(String string) {
        return SystemFieldType.get(Constants.SystemFieldIdentifier.get(string));
    }

    public static SystemFieldType get(Constants.SystemFieldIdentifier systemFieldIdentifier) {
        return members.get((Object)systemFieldIdentifier);
    }

    private static void load() {
        Map map = null;
        XmlElement xmlElement = null;
        SystemFieldType systemFieldType = null;
        try {
            map = CollectionUtils.getOrderedMap(new HashMap(10));
            xmlElement = XmlElementFactory.load(PackageMarker.class, "SystemFieldTypes.xml");
            for (XmlElement xmlElement2 : xmlElement.getOptionalElements("system-field-type")) {
                systemFieldType = SystemFieldType.loadType(xmlElement2);
                map.put(systemFieldType.getIdentifier(), systemFieldType);
            }
            members = map;
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
    }

    private static SystemFieldType loadType(XmlElement xmlElement) {
        SystemFieldType systemFieldType = null;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        TypeDefinition typeDefinition = null;
        systemFieldType = new SystemFieldType();
        systemFieldType.identifier = Constants.SystemFieldIdentifier.get(xmlElement.getText("identifier"));
        systemFieldType.defaultFieldName = xmlElement.getText("name");
        systemFieldType.defaultPersistenceName = xmlElement.getText("persistence-name");
        nullFreeCollection = xmlElement.getOptionalElements("types/type");
        systemFieldType.typeDefinitions = new HashMap<String, TypeDefinition>(nullFreeCollection.size());
        for (XmlElement xmlElement2 : nullFreeCollection) {
            typeDefinition = TypeDefinition.createInstance(xmlElement2);
            systemFieldType.typeDefinitions.put(typeDefinition.getDataType().getName(), typeDefinition);
        }
        systemFieldType.defaultTypeDefinition = systemFieldType.typeDefinitions.get(xmlElement.getText("types/default-type"));
        return systemFieldType;
    }

    static {
        SystemFieldType.load();
    }
}

