/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webdata.core;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.util.Logger;
import com.jronimo.webdata.core.DataType;
import com.jronimo.webdata.core.resources.PackageMarker;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.util.HashMap;
import java.util.Map;

public final class DatabaseType {
    private static final Logger logger = Logger.getLogger(DatabaseType.class);
    private static Map<String, DatabaseType> members;
    private String name;
    private String sqlType;
    private DataType defaultDataType;
    private String broadType;

    private DatabaseType(String string, String string2, DataType dataType, String string3) {
        this.name = string;
        this.sqlType = string2;
        this.defaultDataType = dataType;
        this.broadType = string3;
    }

    public static DatabaseType get(String string) {
        return members.get(string);
    }

    public String getName() {
        return this.name;
    }

    public String getSqlType() {
        return this.sqlType;
    }

    public DataType getDefaultDataType() {
        return this.defaultDataType;
    }

    public String getBroadType() {
        return this.broadType;
    }

    public boolean isTinyInt() {
        return this.name.equals("TinyInt");
    }

    public boolean isSmallInt() {
        return this.name.equals("SmallInt");
    }

    public boolean isInt() {
        return this.name.equals("Int");
    }

    public boolean isBigInt() {
        return this.name.equals("BigInt");
    }

    public boolean isFloat() {
        return this.name.equals("Float");
    }

    public boolean isDouble() {
        return this.name.equals("Double");
    }

    public boolean isDecimal() {
        return this.name.equals("Decimal");
    }

    public boolean isChar() {
        return this.name.equals("Char");
    }

    public boolean isVarChar() {
        return this.name.equals("VarChar");
    }

    public boolean isTinyText() {
        return this.name.equals("TinyText");
    }

    public boolean isText() {
        return this.name.equals("Text");
    }

    public boolean isMediumText() {
        return this.name.equals("MediumText");
    }

    public boolean isLongText() {
        return this.name.equals("LongText");
    }

    public boolean isTinyBlob() {
        return this.name.equals("TinyBlob");
    }

    public boolean isBlob() {
        return this.name.equals("Blob");
    }

    public boolean isMediumBlob() {
        return this.name.equals("MediumBlob");
    }

    public boolean isLongBlob() {
        return this.name.equals("LongBlob");
    }

    public boolean isDate() {
        return this.name.equals("Date");
    }

    public boolean isDateTime() {
        return this.name.equals("DateTime");
    }

    public boolean isTime() {
        return this.name.equals("Time");
    }

    public boolean isBoolean() {
        return this.name.equals("Boolean");
    }

    public boolean isWholeNumberBroadType() {
        return this.broadType.equals("WholeNumber");
    }

    public boolean isDecimalNumberBroadType() {
        return this.broadType.equals("DecimalNumber");
    }

    public boolean isTextBroadType() {
        return this.broadType.equals("Text");
    }

    public boolean isBinaryBroadType() {
        return this.broadType.equals("Binary");
    }

    public boolean isTemporalBroadType() {
        return this.broadType.equals("Temporal");
    }

    public boolean isBooleanBroadType() {
        return this.broadType.equals("Boolean");
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        DatabaseType databaseType = null;
        if (object instanceof DatabaseType) {
            databaseType = (DatabaseType)object;
            if (databaseType.name.equals(this.name)) {
                bl = true;
            }
        }
        return bl;
    }

    private static void load() {
        XmlElement xmlElement = null;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        DatabaseType databaseType = null;
        xmlElement = XmlElementFactory.load(PackageMarker.class, "DatabaseTypes.xml");
        nullFreeCollection = xmlElement.getOptionalElements("type");
        members = CollectionUtils.getOrderedMap(new HashMap(nullFreeCollection.size()));
        for (XmlElement xmlElement2 : nullFreeCollection) {
            databaseType = new DatabaseType(xmlElement2.getText("name"), xmlElement2.getText("sql-type"), DataType.get(xmlElement2.getText("default-data-type")), xmlElement2.getText("broad-type"));
            members.put(databaseType.getName(), databaseType);
        }
    }

    static {
        DatabaseType.load();
    }
}

