/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webappserver.server;

import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.documenter.gui.FileMethods;
import com.jronimo.http.VerifyRecaptcha;
import com.jronimo.temporal.DateTime;
import com.jronimo.util.DateUtils;
import com.jronimo.util.Logger;
import com.jronimo.util.StringWrapper;
import com.jronimo.webappserver.server.WebApp;
import com.jronimo.webappserver.server.WebAppFile;
import com.jronimo.webappserver.util.Methods;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppServer
extends HttpServlet {
    private static final Logger logger = Logger.getLogger(WebAppServer.class);
    private ServletConfig servletConfig;
    private File tempDir;
    private int counter;
    private String host;
    private String captchaKey;
    private Map<String, WebApp> webApps = new HashMap<String, WebApp>(3);

    public void init(ServletConfig servletConfig) throws ServletException {
        logger.info("Start: Init for WebAppServer...");
        this.servletConfig = servletConfig;
        this.tempDir = (File)this.servletConfig.getServletContext().getAttribute("javax.servlet.context.tempdir");
        this.tempDir = new File(this.tempDir, servletConfig.getInitParameter("name"));
        this.tempDir.mkdirs();
        this.host = servletConfig.getInitParameter("host");
        this.captchaKey = servletConfig.getInitParameter("captchaKey");
        this.loadWebApps();
        logger.info("End: Init for WebAppServer.");
    }

    public void doHead(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        if (Methods.getString(httpServletRequest.getPathInfo()).endsWith("/ping")) {
            this.processPing(httpServletResponse);
        }
    }

    private void processPing(HttpServletResponse httpServletResponse) throws ServletException {
        httpServletResponse.setHeader("Access-Control-Allow-Origin", "*");
        try {
            httpServletResponse.getOutputStream().flush();
        }
        catch (Exception exception) {
            logger.error(exception);
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        if (Methods.getString(httpServletRequest.getPathInfo()).endsWith("/ping")) {
            this.processPing(httpServletResponse);
        } else {
            this.processRequest(httpServletRequest, httpServletResponse);
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    private void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        long l = System.currentTimeMillis();
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        boolean bl = true;
        StringWrapper stringWrapper = null;
        WebApp webApp = null;
        String string = null;
        byte[] byArray = null;
        WebAppFile webAppFile = null;
        int n = 0;
        String string2 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        String string3 = null;
        try {
            stringWrapper = new StringWrapper(Methods.getString(httpServletRequest.getPathInfo()));
            if (!this.checkForAliases(httpServletRequest, httpServletResponse, stringWrapper.toString())) {
                webApp = this.getWebApp(stringWrapper);
                if (webApp == null) {
                    this.sendNotFound(httpServletRequest, httpServletResponse, webApp, stringWrapper.toString());
                } else {
                    if (!webApp.getPath().equals("/")) {
                        stringWrapper.deleteFirst(webApp.getPath());
                    }
                    if (this.ensureSession(httpServletRequest, httpServletResponse, stringWrapper, webApp, string = Methods.getCookieValue(httpServletRequest, "location"))) {
                        n = webApp.getCacheDuration();
                        string2 = DateUtils.getHttpDateString(DateTime.addSeconds(DateTime.now(0), n));
                        if (stringWrapper.isEmpty() || stringWrapper.endsWith("/")) {
                            this.sendRedirect(httpServletRequest, httpServletResponse, webApp, "index.html");
                        } else if (stringWrapper.endsWith("/search")) {
                            byArray = this.handleSearch(httpServletRequest, webApp);
                            string3 = "text/html";
                            bl2 = true;
                        } else if (stringWrapper.endsWith("/submit")) {
                            this.handleSubmit(httpServletRequest, webApp, string);
                            this.sendRedirect(httpServletRequest, httpServletResponse, webApp, "Confirmation.html");
                        } else if (stringWrapper.endsWith(".html") && httpServletRequest.getParameter("u") != null) {
                            this.sendRedirect(httpServletRequest, httpServletResponse, webApp, stringWrapper.toString());
                        } else {
                            if (stringWrapper.endsWith(".html")) {
                                webApp.refresh();
                            }
                            if ((webAppFile = webApp.getWebAppFile(stringWrapper.toString())) == null) {
                                this.sendNotFound(httpServletRequest, httpServletResponse, webApp, stringWrapper.toString());
                            } else {
                                bl2 = true;
                                if (stringWrapper.endsWith("clear.html")) {
                                    bl3 = true;
                                } else {
                                    hashMap.put("Cache-Control", "private, max-age=" + n + ", s-maxage=0");
                                    hashMap.put("Expires", string2);
                                }
                                string3 = webAppFile.getContentType();
                                byArray = webAppFile.getContent();
                            }
                        }
                        if (bl2) {
                            Methods.applyHeaders(httpServletResponse, string3, bl3, hashMap);
                            httpServletResponse.getOutputStream().write(byArray);
                        }
                    } else {
                        httpServletResponse.getOutputStream().write(Methods.toBytes("<p/>This view of the website requires that the session begin with a URL containing a recognized username and password.<p/>This message is never shown in production.<p/>This authentication scheme requires that cookies are enabled in your web browser."));
                    }
                }
            }
        }
        catch (Throwable throwable) {
            bl = false;
            logger.error(throwable);
        }
        if (!bl) {
            httpServletResponse.setStatus(500);
        }
        try {
            httpServletResponse.getOutputStream().flush();
        }
        catch (Exception exception) {
            logger.error(exception);
        }
    }

    public void destroy() {
        try {
            super.destroy();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean checkForAliases(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException {
        String[] stringArray = new String[]{"swseq.com.au"};
        boolean bl = false;
        StringWrapper stringWrapper = null;
        String string2 = null;
        String string3 = null;
        if (string.endsWith(".html")) {
            stringWrapper = new StringWrapper(httpServletRequest.getRequestURL());
            for (String string4 : stringArray) {
                if (!stringWrapper.contains(string4)) continue;
                string3 = string4;
                bl = true;
                break;
            }
            if (bl) {
                string2 = "www." + string3;
                if (stringWrapper.contains(string2)) {
                    stringWrapper.replace(string2, "www.swbris.com.au");
                } else {
                    string2 = string3;
                    if (stringWrapper.contains(string2)) {
                        stringWrapper.replace(string2, "swbris.com.au");
                    }
                }
                string2 = httpServletRequest.getQueryString();
                if (string2 != null) {
                    stringWrapper.append("?").append(httpServletRequest.getQueryString());
                }
                httpServletResponse.sendRedirect(stringWrapper.toString());
            }
        }
        return bl;
    }

    private void sendRedirect(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, WebApp webApp, String string) throws IOException {
        StringWrapper stringWrapper = null;
        stringWrapper = new StringWrapper(httpServletRequest.getRequestURL()).deleteLast(Methods.getString(httpServletRequest.getPathInfo(), "")).append(webApp.getPath()).append("/", !webApp.getPath().endsWith("/")).append(new StringWrapper(string).deleteFirst(string.startsWith("/")));
        httpServletResponse.sendRedirect(stringWrapper.toString());
    }

    private void sendNotFound(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, WebApp webApp, String string) throws IOException {
        logger.debug("NOT FOUND: " + string);
        if (webApp == null || string.endsWith("404.html")) {
            httpServletResponse.sendError(404);
        } else {
            this.sendRedirect(httpServletRequest, httpServletResponse, webApp, "404.html");
        }
    }

    private WebApp getWebApp(StringWrapper stringWrapper) {
        WebApp webApp = null;
        for (String string : this.webApps.keySet()) {
            if (string.equals("/")) continue;
            if (!stringWrapper.startsWith(string)) continue;
            webApp = this.webApps.get(string);
            break;
        }
        if (webApp == null) {
            webApp = this.webApps.get("/");
        }
        return webApp;
    }

    private boolean ensureSession(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, StringWrapper stringWrapper, WebApp webApp, String string) {
        boolean bl = true;
        HttpSession httpSession = null;
        String string2 = null;
        String string3 = null;
        httpSession = httpServletRequest.getSession();
        if (httpSession.getAttribute("id") == null) {
            httpSession.setAttribute("id", (Object)DateTime.now(true).getTemporalValue());
        }
        if (webApp.authenticationRequired()) {
            string2 = this.getParameter(httpServletRequest, "u");
            if (webApp.hasUser(string2, string3 = this.getParameter(httpServletRequest, "p"))) {
                httpSession.setAttribute("username", (Object)string2);
                httpSession.setAttribute("password", (Object)string3);
                if (stringWrapper.endsWith(".html")) {
                    httpServletResponse.addCookie(Methods.createCookie("u", string2));
                    httpServletResponse.addCookie(Methods.createCookie("p", string3));
                }
            } else {
                bl = false;
            }
        } else {
            httpSession.setAttribute("username", (Object)"user");
        }
        if (bl && stringWrapper.endsWith(".html")) {
            this.logUserInteraction(httpServletRequest, httpSession, stringWrapper.toString(), webApp, string);
        }
        return bl;
    }

    private String getParameter(HttpServletRequest httpServletRequest, String string) {
        String string2 = null;
        string2 = httpServletRequest.getParameter(string);
        if (string2 == null) {
            string2 = Methods.getStringAttribute(httpServletRequest.getSession(), string);
        }
        if (string2 == null) {
            string2 = Methods.getCookieValue(httpServletRequest, string);
        }
        return string2;
    }

    private void logUserInteraction(HttpServletRequest httpServletRequest, HttpSession httpSession, String string, WebApp webApp, String string2) {
        StringWrapper stringWrapper = new StringWrapper();
        File file = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        try {
            file = new File(this.tempDir, webApp.getEnvironment() + "/" + "logs/" + httpSession.getAttribute("id") + "-" + httpSession.getAttribute("username") + ".txt");
            file.getParentFile().mkdirs();
            if (!file.exists()) {
                stringWrapper.append("ip\t\t").append(httpServletRequest.getRemoteAddr());
                stringWrapper.append("location\t\t").append(string2);
                FileMethods.writeTextFile(file, stringWrapper.toString());
                stringWrapper.clear();
            }
            if (file.exists()) {
                if (httpSession.getAttribute("lastTimestamp") != null) {
                    l2 = Long.parseLong(httpSession.getAttribute("lastTimestamp").toString());
                }
                l = System.currentTimeMillis();
                httpSession.setAttribute("lastTimestamp", (Object)l);
                if (l2 != 0L) {
                    l3 = (l - l2) / 1000L;
                }
                stringWrapper.append(l3).append("\t\t").append(string).append(string2).append("\n");
                FileMethods.writeTextFile(file, stringWrapper.toString(), true, true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void loadWebApps() {
        File file = null;
        file = new File(this.servletConfig.getServletContext().getRealPath("/"), "WEB-INF/webapps");
        for (File file2 : file.listFiles()) {
            this.loadWebApp(file2);
        }
    }

    private void loadWebApp(File file) {
        XmlElement xmlElement = null;
        String string = null;
        String string2 = null;
        xmlElement = XmlElementFactory.load(file);
        string = xmlElement.getText("name");
        string2 = xmlElement.getText("css-path");
        this.loadWebApp(string, xmlElement.getElement("development"), string2);
        this.loadWebApp(string, xmlElement.getElement("preview"), string2);
        this.loadWebApp(string, xmlElement.getElement("production"), string2);
    }

    private void loadWebApp(String string, XmlElement xmlElement, String string2) {
        XmlElement xmlElement2 = null;
        String string3 = null;
        String string4 = null;
        File file = null;
        List<WebApp.User> list = null;
        WebApp webApp = null;
        boolean bl = true;
        xmlElement2 = this.getLocationXml(xmlElement.getElement("locations"));
        if (xmlElement2 != null) {
            string3 = xmlElement2.getText("file-system-path");
            string4 = xmlElement2.getText("http-path");
            if (this.webApps.keySet().contains(string4)) {
                logger.error("Error loading web app (" + string + "). Duplicate path(" + string4 + ")");
            } else {
                file = this.getLocation(string3, string);
                if (file != null) {
                    bl = xmlElement2.getOptionalAttributeBoolean("authenticationRequired", true);
                    if (bl && xmlElement.hasElement("users")) {
                        list = this.getUsers(xmlElement.getElement("users"));
                    }
                    webApp = new WebApp(string, xmlElement.getName(), string4, string2, xmlElement2.getInteger("cache-duration"), file, bl, list);
                    this.webApps.put(string4, webApp);
                }
                logger.debug("SUCCESS: " + string4);
            }
        }
    }

    private XmlElement getLocationXml(XmlElement xmlElement) {
        XmlElement xmlElement2 = null;
        for (XmlElement xmlElement3 : xmlElement.getElements("location")) {
            if (!xmlElement3.getText("host").equals(this.host)) continue;
            xmlElement2 = xmlElement3;
            break;
        }
        return xmlElement2;
    }

    private File getLocation(String string, String string2) {
        File file = null;
        file = string.startsWith("./") ? new File(this.servletConfig.getServletContext().getRealPath("/"), string) : new File(string);
        if (file == null) {
            logger.error("Web app (" + string2 + "). No location found.");
        } else if (!file.isDirectory()) {
            file = null;
            logger.error("Web app (" + string2 + "). The path (" + string2 + ") was not found.");
        }
        return file;
    }

    private List<WebApp.User> getUsers(XmlElement xmlElement) {
        ArrayList<WebApp.User> arrayList = null;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        nullFreeCollection = xmlElement.getOptionalElements("user");
        if (!nullFreeCollection.isEmpty()) {
            arrayList = new ArrayList<WebApp.User>(5);
            for (XmlElement xmlElement2 : nullFreeCollection) {
                arrayList.add(new WebApp.User(xmlElement2.getText("username"), xmlElement2.getText("password")));
            }
        }
        return arrayList;
    }

    private byte[] handleSearch(HttpServletRequest httpServletRequest, WebApp webApp) {
        StringWrapper stringWrapper = new StringWrapper();
        byte[] byArray = null;
        String string = null;
        try {
            string = URLDecoder.decode(Methods.getCookieValue(httpServletRequest, "search"), "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!Methods.isEmpty(string)) {
            stringWrapper.append("<div class=\"result\">");
            stringWrapper.append("<div class=\"top\">");
            stringWrapper.append("<div>1.</div><div><a href=\"AluminiumWindows.html\">AluminiumWindows.html</a></div>");
            stringWrapper.append("</div>");
            stringWrapper.append("<div class=\"snippet\">");
            stringWrapper.append("...complete range of <strong>aluminium windows</strong>. All of our...");
            stringWrapper.append("</div>");
            stringWrapper.append("</div>");
        }
        byArray = Methods.toBytes(stringWrapper.toString());
        return byArray;
    }

    private void handleSubmit(HttpServletRequest httpServletRequest, WebApp webApp, String string) {
        StringWrapper stringWrapper = new StringWrapper();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        boolean bl = false;
        File file = null;
        string2 = httpServletRequest.getParameter("name");
        string3 = httpServletRequest.getParameter("phone");
        string4 = httpServletRequest.getParameter("email");
        string5 = httpServletRequest.getParameter("message");
        string6 = httpServletRequest.getParameter("g-recaptcha-response");
        bl = VerifyRecaptcha.verify(this.captchaKey, string6, httpServletRequest.getRemoteHost());
        stringWrapper.append("Verified: ").append(bl).append("\n");
        stringWrapper.append("Location: ").append(string).append("\n");
        stringWrapper.append("Name: ").append(string2).append("\n");
        stringWrapper.append("Phone: ").append(string3).append("\n");
        stringWrapper.append("Email: ").append(string4).append("\n");
        stringWrapper.append("Message:\n\n").append(string5).append("\n");
        file = new File(this.tempDir, webApp.getEnvironment() + "/" + "contact-forms/" + DateTime.now(true).getTemporalValue() + ".txt");
        FileMethods.writeTextFile(file, stringWrapper.toString());
    }
}

