/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webappserver.server;

import com.jronimo.http.MimeTypes;
import com.jronimo.util.FileMethods;
import com.jronimo.util.Logger;
import com.jronimo.webappserver.util.Methods;
import java.io.File;

public final class WebAppFile {
    private static final Logger logger = Logger.getLogger(WebAppFile.class);
    private File file;
    private long lastModified;
    private String contentType;
    private boolean hasStringContent = true;
    private boolean cache = true;
    private byte[] content;
    private boolean isConstructor = true;

    public WebAppFile(File file) {
        this.file = file;
        this.lastModified = file.lastModified();
        this.contentType = MimeTypes.getInstance().getMimeType(file.getPath());
        if (Methods.isImageFile(file.getPath())) {
            this.hasStringContent = false;
        }
        if (file.getName().endsWith(".pdf")) {
            this.hasStringContent = false;
            this.cache = false;
        }
        if (this.cache) {
            this.content = this.readFromFile();
        }
        this.isConstructor = false;
    }

    public File getFile() {
        return this.file;
    }

    public String getContentType() {
        return this.contentType;
    }

    public synchronized boolean hasChanged() {
        return this.file.lastModified() != this.lastModified;
    }

    public synchronized byte[] getContent() {
        byte[] byArray = null;
        if (this.file != null && this.file.isFile()) {
            byArray = this.hasChanged() ? this.readFromFile() : (this.cache ? this.content : this.readFromFile());
            if (this.cache && byArray != null) {
                this.content = byArray;
            }
        } else {
            byArray = new byte[]{};
        }
        return byArray;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        WebAppFile webAppFile = null;
        if (object instanceof WebAppFile) {
            webAppFile = (WebAppFile)object;
            if (webAppFile.file.equals(this.file)) {
                bl = true;
            }
        }
        return bl;
    }

    private byte[] readFromFile() {
        byte[] byArray = null;
        if (this.content == null || this.cache && this.hasChanged()) {
            byArray = this.hasStringContent ? Methods.toBytes(FileMethods.readTextFile(this.file)) : FileMethods.readBinaryFile(this.file);
            this.lastModified = this.file.lastModified();
            if (!this.isConstructor) {
                logger.debug("FILE: " + this.file.getName());
            }
        }
        return byArray;
    }
}

