/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webappengines.core.client;

import com.jronimo.util.Logger;
import com.jronimo.webappengines.core.client.AbstractClientSession;
import com.jronimo.webappengines.core.client.ClientSession;
import com.jronimo.webappengines.core.client.ResponseError;
import com.jronimo.xml.XmlElement;

public final class ClientSessionResponse {
    private static final Logger logger = Logger.getLogger(ClientSessionResponse.class);
    private XmlElement responseElement;
    private AbstractClientSession clientSession;
    private ResponseError error;
    private XmlElement serviceResponseElement;

    public ClientSessionResponse(AbstractClientSession abstractClientSession, XmlElement xmlElement) {
        this.clientSession = abstractClientSession;
        this.responseElement = xmlElement;
        this.unpackNode();
    }

    public ClientSession getClientSession() {
        return this.clientSession;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public ResponseError getError() {
        return this.error;
    }

    public XmlElement getServiceResponseElement() {
        return this.serviceResponseElement;
    }

    private void unpackNode() {
        if (this.responseElement.hasElement("error")) {
            this.error = new ResponseError(this.responseElement.getElement("error"));
        }
        if (this.responseElement.hasElement("tickets")) {
            this.clientSession.handleTickets(this.responseElement.getElement("tickets"));
        }
        if (this.responseElement.hasElement("permissions")) {
            this.clientSession.handleTickets(this.responseElement.getElement("permissions"));
        }
        if (this.error == null) {
            if (this.responseElement.hasElement("data-service")) {
                this.serviceResponseElement = this.responseElement.getElement("data-service");
            } else if (this.responseElement.hasElement("file-service")) {
                this.serviceResponseElement = this.responseElement.getElement("file-service");
            }
        }
    }
}

