/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webappengines.core.client;

import com.jronimo.constraints.ValidationOutcome;
import com.jronimo.constraints.ValidationOutcomes;
import com.jronimo.engines.dataservice.exceptions.DataServiceException;
import com.jronimo.engines.dataservice.exceptions.ValidationException;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.util.Logger;
import com.jronimo.webappengines.core.Methods;
import com.jronimo.webappengines.exceptions.ClientInteractionException;
import com.jronimo.xml.XmlElement;

public abstract class AbstractResponseError {
    private static final Logger logger = Logger.getLogger(AbstractResponseError.class);
    private XmlElement errorElement;
    private String type;
    private String message;
    private String operationId;
    private String target;
    private String operation;
    protected Class exceptionClass;
    protected ValidationOutcomes validationOutcomes;

    public AbstractResponseError(XmlElement xmlElement) {
        this.errorElement = xmlElement;
        this.unpackNode();
    }

    public XmlElement getErrorElement() {
        return this.errorElement;
    }

    public String getErrorXml() {
        return this.errorElement.toString();
    }

    public String getErrorType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public String getTarget() {
        return this.target;
    }

    public String getOperation() {
        return this.operation;
    }

    public boolean isClientInteractionException() {
        return Methods.hasSuperClass(this.exceptionClass, ClientInteractionException.class);
    }

    public boolean isDataServiceException() {
        return Methods.hasSuperClass(this.exceptionClass, DataServiceException.class);
    }

    public boolean isUnrecognizedException() {
        return !this.isClientInteractionException();
    }

    private void unpackNode() {
        if (this.errorElement.hasElement("exception")) {
            this.unpackExceptionNode();
        } else if (this.errorElement.hasElement("validation-errors")) {
            this.unpackValidationErrorsNode();
        }
    }

    private void unpackExceptionNode() {
        XmlElement xmlElement = null;
        xmlElement = this.errorElement.getElement("exception");
        this.type = xmlElement.getText("type");
        this.message = xmlElement.getText("message");
        this.operationId = xmlElement.getOptionalText("operationId");
        this.target = xmlElement.getOptionalText("target");
        this.operation = xmlElement.getOptionalText("operation");
        try {
            this.exceptionClass = Class.forName(this.type);
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
        this.type = this.type.substring(this.type.lastIndexOf(".") + 1);
        xmlElement.getElement("type").setText(this.type);
    }

    private void unpackValidationErrorsNode() {
        ValidationOutcome validationOutcome = null;
        this.exceptionClass = ValidationException.class;
        this.validationOutcomes = new ValidationOutcomes();
        for (XmlElement xmlElement : this.errorElement.getOptionalElements("validation-errors/validation-error")) {
            validationOutcome = new ValidationOutcome(xmlElement.getText("field-name"));
            validationOutcome.setErrorMessage(xmlElement.getText("error-message"));
            this.validationOutcomes.add(validationOutcome);
        }
    }
}

