/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webappengines.core.client;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.engines.dataservice.Permission;
import com.jronimo.nameformat.SimpleNameFormat;
import com.jronimo.util.Logger;
import com.jronimo.webappengines.core.Constants;
import com.jronimo.webappengines.core.client.ClientSession;
import com.jronimo.webappengines.core.client.ClientSessionResponse;
import com.jronimo.webappengines.core.client.ConnectionError;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClientSession
implements ClientSession {
    private static final Logger logger = Logger.getLogger(AbstractClientSession.class);
    protected String systemIdentifier;
    protected String sessionId;
    protected int numberOfTickets;
    protected long userId;
    protected Set<String> systemRoles;
    protected Map<String, String> securityProperties;
    protected Set<Permission> permissions;
    protected Set<String> tickets;

    protected AbstractClientSession(String string) {
        this.systemIdentifier = string;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public long getUserId() {
        return this.userId;
    }

    @Override
    public Set<String> getSystemRoles() {
        return CollectionUtils.collectionToSet(this.systemRoles);
    }

    @Override
    public boolean hasSystemRole(String string) {
        return this.systemRoles.contains(string);
    }

    @Override
    public String getSecurityProperty(String string) {
        return this.securityProperties == null ? null : this.securityProperties.get(string);
    }

    @Override
    public Set<Permission> getPermissions() {
        return CollectionUtils.collectionToSet(this.permissions);
    }

    @Override
    public ClientSessionResponse sendRequest(Constants.DataServiceRequestType dataServiceRequestType, String string) {
        ClientSessionResponse clientSessionResponse = null;
        clientSessionResponse = this.sendRequest(dataServiceRequestType, XmlElementFactory.load(string));
        return clientSessionResponse;
    }

    protected XmlElement getNewSessionRequestElement(String string, String string2, String string3, String string4, String string5) {
        XmlElement xmlElement = null;
        XmlElement xmlElement2 = null;
        XmlElement xmlElement3 = null;
        xmlElement2 = XmlElementFactory.create("new-session");
        xmlElement3 = xmlElement2.addElement("credentials");
        xmlElement3.addElement("username").setText(string);
        xmlElement3.addElement("password").setText(string2);
        if (string3 != null) {
            xmlElement2.addElement("language").setText(string3);
        }
        if (string4 != null) {
            xmlElement2.addElement("language-variation").setText(string4);
        }
        if (string5 != null) {
            xmlElement2.addElement("locale").setText(string5);
        }
        xmlElement2.addElement("return-security-context").setText("true");
        xmlElement2.addElement("permission-ids").setText("");
        xmlElement = this.getRequestElement(Constants.DataServiceRequestType.NEW_SESSION, xmlElement2);
        return xmlElement;
    }

    protected XmlElement getRequestElement(Constants.DataServiceRequestType dataServiceRequestType, XmlElement xmlElement) {
        XmlElement xmlElement2 = null;
        HashSet<String> hashSet = null;
        int n = 0;
        xmlElement2 = XmlElementFactory.create("request");
        xmlElement2.addElement("request-type").setText(new SimpleNameFormat(dataServiceRequestType.toString()).getCamelCase());
        xmlElement2.addElement("system").setText(this.systemIdentifier);
        switch (dataServiceRequestType) {
            case DATA_SERVICE: {
                xmlElement2.addElement("session-id").setText(this.sessionId);
                if (this.numberOfTickets <= 0) break;
                hashSet = new HashSet<String>(this.numberOfTickets);
                for (String string : this.tickets) {
                    hashSet.add(string);
                    this.tickets.remove(string);
                    if (++n != this.numberOfTickets) continue;
                    break;
                }
                xmlElement2.addElement("tickets").setText(CollectionUtils.collectionToCommaDelimitedList(hashSet));
            }
        }
        xmlElement2.addElement(xmlElement);
        return xmlElement2;
    }

    protected void handleNewSessionResponse(String string) throws Exception {
        this.handleNewSessionResponse(XmlElementFactory.load(string));
    }

    protected ConnectionError handleNewSessionResponse(XmlElement xmlElement) {
        ConnectionError connectionError = null;
        XmlElement xmlElement2 = null;
        XmlElement xmlElement3 = null;
        XmlElement xmlElement4 = null;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        if (xmlElement.hasElement("error")) {
            connectionError = new ConnectionError(xmlElement.getElement("error"));
        } else {
            xmlElement2 = xmlElement.getElement("new-session");
            this.sessionId = xmlElement2.getText("session-id");
            this.numberOfTickets = xmlElement2.getOptionalInteger("number-of-tickets", "0");
            xmlElement3 = xmlElement2.getElement("security-context");
            if (xmlElement3 != null) {
                this.userId = xmlElement3.getLong("user-id");
                this.systemRoles = CollectionUtils.getOrderedSet(new HashSet(3));
                for (XmlElement xmlElement5 : xmlElement3.getOptionalElements("system-roles/system-role")) {
                    this.systemRoles.add(xmlElement5.getText());
                }
                if (xmlElement3.hasElement("security-properties")) {
                    nullFreeCollection = xmlElement4.getOptionalElements("security-properties/property");
                    this.securityProperties = CollectionUtils.getOrderedMap(new HashMap(nullFreeCollection.size()));
                    for (XmlElement xmlElement5 : nullFreeCollection) {
                        this.securityProperties.put(xmlElement5.getText("name"), xmlElement5.getText("value"));
                    }
                }
            }
            this.handleTickets(xmlElement);
            this.handlePermissions(xmlElement);
        }
        return connectionError;
    }

    protected synchronized void handleTickets(XmlElement xmlElement) {
        if (xmlElement.hasElement("tickets")) {
            this.handleTickets(xmlElement.getElement("tickets").getText());
        }
    }

    protected synchronized void handleTickets(String string) {
        String[] stringArray = null;
        stringArray = string.split(",");
        if (this.tickets == null) {
            this.tickets = new HashSet<String>(stringArray.length);
        }
        for (String string2 : stringArray) {
            this.tickets.add(string2);
        }
    }

    protected void handlePermissions(XmlElement xmlElement) {
        XmlElement xmlElement2 = null;
        if (xmlElement.hasElement("permissions")) {
            xmlElement2 = xmlElement.getElement("permissions");
        }
    }
}

