/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webappengines.core;

import com.jronimo.exceptions.BaseException;
import com.jronimo.exceptions.BaseRuntimeException;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.util.ComputerResourceUsage;
import com.jronimo.util.LibraryLifecycle;
import com.jronimo.util.Logger;
import com.jronimo.webappengines.BaseServlet;
import com.jronimo.webappengines.Constants;
import com.jronimo.webappengines.RequestPathPortions;
import com.jronimo.webappengines.core.DataServiceRequest;
import com.jronimo.webappengines.core.ErrorRequest;
import com.jronimo.webappengines.core.FileServiceRequest;
import com.jronimo.webappengines.core.RequestDirector;
import com.jronimo.webappengines.core.SystemsContainerDeployment;
import com.jronimo.webappengines.exceptions.EarlyException;
import com.jronimo.webappengines.exceptions.ServerStateNotReadyException;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class RouterServlet
extends BaseServlet {
    private static final Logger logger = Logger.getLogger(RouterServlet.class);
    private SystemsContainerDeployment systemsContainerDeployment;

    public void init(ServletConfig servletConfig) throws ServletException {
        logger.debug("SystemsContainer RouterServlet loading...");
        try {
            this.init(servletConfig, "SystemsContainer.xml");
            this.systemsContainerDeployment = SystemsContainerDeployment.createInstance(this.externalRootDirectory, servletConfig.getServletContext().getContextPath());
            RequestDirector.createInstance();
            this.acceptRequests = true;
        }
        catch (BaseRuntimeException baseRuntimeException) {
            LibraryLifecycle.shutdown();
            throw new ServletException((Throwable)baseRuntimeException);
        }
        catch (Exception exception) {
            LibraryLifecycle.shutdown();
            logger.fatal(exception);
            throw new ServletException((Throwable)exception);
        }
        logger.debug("SystemsContainer RouterServlet loaded.");
    }

    protected void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        XmlElement xmlElement = null;
        RequestPathPortions requestPathPortions = null;
        try {
            if (!this.acceptRequests) {
                throw new ServerStateNotReadyException();
            }
            requestPathPortions = new RequestPathPortions(httpServletRequest, this.systemsContainerDeployment);
            httpServletRequest.setAttribute(Constants.AttributeKeys.REQUEST_PATH_PORTIONS.toString(), (Object)requestPathPortions);
            switch (requestPathPortions.getResourcePathConstant()) {
                case STATE: {
                    xmlElement = this.processState(httpServletRequest);
                    break;
                }
                case FILE_SERVICE_VERSION_CHECK: 
                case FILE_SERVICE_FILE_REQUEST: {
                    xmlElement = this.processFileServiceRequest(httpServletRequest, httpServletResponse);
                    break;
                }
                case DATA_SERVICE_GET: {
                    xmlElement = this.processGet(httpServletRequest);
                    break;
                }
                case DATA_SERVICE_POST: {
                    xmlElement = this.processPost(httpServletRequest);
                    break;
                }
                case DATA_SERVICE_WS: {
                    xmlElement = this.processWs(httpServletRequest);
                }
            }
        }
        catch (EarlyException earlyException) {
            xmlElement = RequestDirector.getInstance().processRequest(ErrorRequest.createInstance(httpServletRequest, earlyException));
        }
        catch (BaseRuntimeException baseRuntimeException) {
            xmlElement = baseRuntimeException.getXml();
        }
        catch (BaseException baseException) {
            xmlElement = baseException.getXml();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            xmlElement = new UnexpectedErrorException(exception).getXml();
        }
        if (xmlElement != null) {
            this.writeResponse(httpServletResponse, xmlElement);
        }
    }

    private XmlElement processState(HttpServletRequest httpServletRequest) throws Exception {
        XmlElement xmlElement = null;
        Byte by = null;
        Byte by2 = null;
        try {
            by = ComputerResourceUsage.getInstance().getCpuUsage();
            by2 = ComputerResourceUsage.getInstance().getMemoryUsage();
        }
        catch (Exception exception) {
            logger.error(exception);
        }
        xmlElement = XmlElementFactory.create("response");
        xmlElement.addElement("available").setBoolean(this.acceptRequests);
        if (by != null && by2 != null) {
            xmlElement.addElement("cpu-usage").setByte(by);
            xmlElement.addElement("memory-usage").setByte(by2);
        }
        return xmlElement;
    }

    private XmlElement processFileServiceRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        XmlElement xmlElement = null;
        Object object = null;
        RequestPathPortions requestPathPortions = null;
        object = RequestDirector.getInstance().processRequest(FileServiceRequest.createInstance(httpServletRequest));
        if (object instanceof byte[]) {
            requestPathPortions = (RequestPathPortions)httpServletRequest.getAttribute(Constants.AttributeKeys.REQUEST_PATH_PORTIONS.toString());
            this.writeResponse(httpServletResponse, (byte[])object, requestPathPortions.getContentType().getContentType());
        } else {
            xmlElement = (XmlElement)object;
        }
        return xmlElement;
    }

    private XmlElement processGet(HttpServletRequest httpServletRequest) throws Exception {
        XmlElement xmlElement = null;
        return xmlElement;
    }

    private XmlElement processPost(HttpServletRequest httpServletRequest) throws Exception {
        XmlElement xmlElement = null;
        xmlElement = RequestDirector.getInstance().processRequest(DataServiceRequest.createInstance(httpServletRequest));
        logger.debug("returnValue: " + xmlElement);
        return xmlElement;
    }

    private XmlElement processWs(HttpServletRequest httpServletRequest) throws Exception {
        XmlElement xmlElement = null;
        return xmlElement;
    }

    public void destroy() {
        RequestDirector.getInstance().destroy();
        this.systemsContainerDeployment.destroy();
        super.destroy();
    }
}

