/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webappengines;

import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.text.ResourceText;
import com.jronimo.util.Logger;
import com.jronimo.webappengines.Constants;
import com.jronimo.webappengines.ResourceTextIdentifiers;
import com.jronimo.webappengines.SystemsInfoManager;
import com.jronimo.webappengines.exceptions.UnsupportedHttpMethodException;
import com.jronimo.webappengines.exceptions.UriException;
import javax.servlet.http.HttpServletRequest;

public final class RequestPathPortions {
    private static final Logger logger = Logger.getLogger(RequestPathPortions.class);
    private String httpMethod;
    private String contextPath;
    private String resourcePath;
    private Constants.ResourcePath resourcePathConstant;
    private String systemIdentifier;
    private String systemName;
    private String version;
    private String rendition;
    private String wbwContext;
    private String file;
    private Constants.ContentType contentType;

    public RequestPathPortions(HttpServletRequest httpServletRequest, SystemsInfoManager systemsInfoManager) {
        this.init(httpServletRequest, systemsInfoManager);
    }

    private void init(HttpServletRequest httpServletRequest, SystemsInfoManager systemsInfoManager) {
        String string = null;
        int n = 0;
        this.httpMethod = httpServletRequest.getMethod().toUpperCase();
        this.contextPath = httpServletRequest.getContextPath().length() == 1 ? "" : httpServletRequest.getContextPath();
        string = httpServletRequest.getRequestURI().substring(this.contextPath.length());
        if (string.length() < 2 || !string.startsWith("/")) {
            throw UriException.createInstance(httpServletRequest.getRequestURI(), httpServletRequest.getContextPath());
        }
        n = string.indexOf("/", 1);
        if (n < 0) {
            this.resourcePath = string;
        } else {
            this.resourcePath = string.substring(0, n);
            if ((string = string.substring(n)).length() > 1) {
                this.systemName = string.substring(1);
            }
        }
        this.resourcePathConstant = Constants.ResourcePath.get(this.resourcePath);
        if (!this.resourcePathConstant.isSupportedMethod(httpServletRequest.getMethod())) {
            throw new UnsupportedHttpMethodException(this.resourcePath, httpServletRequest.getMethod());
        }
        if (this.resourcePathConstant == Constants.ResourcePath.FILE_SERVICE_FILE_REQUEST || this.resourcePathConstant == Constants.ResourcePath.FILE_SERVICE_VERSION_CHECK) {
            try {
                if (this.resourcePathConstant == Constants.ResourcePath.FILE_SERVICE_FILE_REQUEST) {
                    this.file = httpServletRequest.getParameter("file");
                    if (this.file == null) {
                        throw new UnexpectedErrorException(ResourceText.getText((Object)ResourceTextIdentifiers.MISSING_QUERY_STRING_ELEMENT, (Object[])new String[]{"file"}));
                    }
                    n = this.file.indexOf("?");
                    if (n >= 0) {
                        this.file = this.file.substring(0, n);
                    }
                    this.contentType = Constants.ContentType.get(this.file.substring(this.file.lastIndexOf(".") + 1));
                } else {
                    this.contentType = Constants.ContentType.XML;
                    this.version = httpServletRequest.getParameter("version");
                    this.rendition = httpServletRequest.getParameter("rendition");
                    this.wbwContext = httpServletRequest.getParameter("context");
                    if (this.version == null) {
                        throw new UnexpectedErrorException(ResourceText.getText((Object)ResourceTextIdentifiers.MISSING_QUERY_STRING_ELEMENT, (Object[])new String[]{"version"}));
                    }
                    if (this.rendition == null) {
                        throw new UnexpectedErrorException(ResourceText.getText((Object)ResourceTextIdentifiers.MISSING_QUERY_STRING_ELEMENT, (Object[])new String[]{"rendition"}));
                    }
                    if (this.wbwContext == null) {
                        throw new UnexpectedErrorException(ResourceText.getText((Object)ResourceTextIdentifiers.MISSING_QUERY_STRING_ELEMENT, (Object[])new String[]{"context"}));
                    }
                }
            }
            catch (UnexpectedErrorException unexpectedErrorException) {
                throw unexpectedErrorException;
            }
            catch (Exception exception) {
                throw new UnexpectedErrorException(exception);
            }
        }
        if (this.systemName == null) {
            this.systemName = httpServletRequest.getParameter("sn");
        }
        if (this.systemName == null) {
            this.systemIdentifier = httpServletRequest.getParameter("si");
        }
        if (this.httpMethod.equals("GET")) {
            this.completeSystemInformation(httpServletRequest, systemsInfoManager);
        }
    }

    private void completeSystemInformation(HttpServletRequest httpServletRequest, SystemsInfoManager systemsInfoManager) {
        if (this.systemIdentifier == null && this.systemName == null) {
            if (systemsInfoManager.getDefaultSystem() == null) {
                throw UriException.createInstance(httpServletRequest.getRequestURI(), httpServletRequest.getContextPath());
            }
            this.systemIdentifier = systemsInfoManager.getDefaultSystem().getIdentifier();
            this.systemName = systemsInfoManager.getDefaultSystem().getName();
        } else if (this.systemIdentifier == null) {
            this.systemIdentifier = systemsInfoManager.getSystemByName(this.systemName).getIdentifier();
        } else {
            this.systemName = systemsInfoManager.getSystemByIdentifier(this.systemIdentifier).getName();
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public Constants.ResourcePath getResourcePathConstant() {
        return this.resourcePathConstant;
    }

    public String getSystemIdentifier() {
        if (!this.httpMethod.equals("GET")) {
            throw new UnexpectedErrorException(ResourceText.getText((Object)ResourceTextIdentifiers.METHOD_NO_GO_FOR_HTTP_METHOD));
        }
        return this.systemIdentifier;
    }

    public String getSystemName() {
        if (!this.httpMethod.equals("GET")) {
            throw new UnexpectedErrorException(ResourceText.getText((Object)ResourceTextIdentifiers.METHOD_NO_GO_FOR_HTTP_METHOD));
        }
        return this.systemName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getRendition() {
        return this.rendition;
    }

    public String getWbwContext() {
        return this.wbwContext;
    }

    public String getFile() {
        return this.file;
    }

    public Constants.ContentType getContentType() {
        return this.contentType;
    }
}

