/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webappengines;

import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.text.ResourceText;
import com.jronimo.util.LibraryLifecycle;
import com.jronimo.util.Logger;
import com.jronimo.webappengines.ResourceTextIdentifiers;
import com.jronimo.xml.XmlElement;
import java.io.File;
import java.net.URL;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseServlet
extends HttpServlet {
    private static final Logger logger = Logger.getLogger(BaseServlet.class);
    protected ServletConfig config;
    protected File externalRootDirectory;
    protected boolean acceptRequests;

    protected void init(ServletConfig servletConfig, String string) throws Exception {
        URL uRL = null;
        Class.forName("com.jronimo.util.LibraryLifecycle");
        this.config = servletConfig;
        uRL = ((Object)((Object)this)).getClass().getClassLoader().getResource(string);
        if (uRL == null) {
            throw new UnexpectedErrorException(ResourceText.getText((Object)ResourceTextIdentifiers.WEB_APP_ROOT_NOT_FOUND_ERROR_MESSAGE));
        }
        this.externalRootDirectory = new File(uRL.toURI()).getParentFile();
    }

    public final void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        try {
            this.processRequest(httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            logger.error(exception);
            throw new ServletException((Throwable)exception);
        }
    }

    public final void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        try {
            this.processRequest(httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            logger.error(exception);
            throw new ServletException((Throwable)exception);
        }
    }

    protected abstract void processRequest(HttpServletRequest var1, HttpServletResponse var2) throws Exception;

    public void destroy() {
        LibraryLifecycle.shutdown();
    }

    protected void writeResponse(HttpServletResponse httpServletResponse, XmlElement xmlElement) throws Exception {
        this.writeResponse(httpServletResponse, xmlElement.toBasicString().getBytes("UTF-8"), "text/xml;charset=UTF-8");
    }

    protected void writeResponse(HttpServletResponse httpServletResponse, byte[] byArray, String string) throws Exception {
        httpServletResponse.setContentLength(byArray.length);
        httpServletResponse.setContentType(string);
        httpServletResponse.getOutputStream().write(byArray);
    }
}

