/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.webapp;

import com.jronimo.webapp.Methods;
import com.jronimo.webapp.RequestHandlerURL;
import com.jronimo.webapp.URL;
import com.jronimo.webapp.ViewURL;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class RequestHandler {
    protected ServletContext context = null;
    protected HttpSession session = null;
    protected HttpServlet servlet = null;
    protected HttpServletRequest request = null;
    protected HttpServletResponse response = null;
    protected Map validationErrors = null;
    protected String alert = null;
    protected String confirmation = null;

    protected RequestHandler(ServletContext servletContext, HttpServlet httpServlet, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = null;
        String string2 = null;
        this.context = servletContext;
        this.session = httpServletRequest.getSession();
        this.servlet = httpServlet;
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.validationErrors = new HashMap();
        string = (String)httpServletRequest.getAttribute("alert");
        if (string == null) {
            string = httpServletRequest.getParameter("alert");
            if (string != null && string.length() > 0) {
                this.alert = string;
            }
        } else if (string.length() > 0) {
            this.alert = string;
        }
        if ((string2 = (String)httpServletRequest.getAttribute("confirmation")) == null) {
            string2 = httpServletRequest.getParameter("confirmation");
            if (string2 != null && string2.length() > 0) {
                this.confirmation = string2;
            }
        } else if (string2.length() > 0) {
            this.confirmation = string2;
        }
    }

    public abstract void execute();

    protected abstract void retrieveParameters();

    protected abstract void validateParameters();

    protected abstract void handle() throws Exception;

    protected void setAttributes() {
        this.request.setAttribute("validationErrors", (Object)this.validationErrors);
        this.request.setAttribute("alert", (Object)this.alert);
        this.request.setAttribute("confirmation", (Object)this.confirmation);
    }

    public final ServletContext getContext() {
        return this.context;
    }

    public final HttpServlet getServlet() {
        return this.servlet;
    }

    public final HttpServletRequest getRequest() {
        return this.request;
    }

    public final HttpServletResponse getResponse() {
        return this.response;
    }

    protected void executeURL(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, URL uRL) throws ServletException {
        if (uRL instanceof RequestHandlerURL) {
            this.executeRequestHandlerURL(httpServletRequest, httpServletResponse, uRL);
        } else if (uRL instanceof ViewURL) {
            this.executeViewURL(httpServletRequest, httpServletResponse, uRL);
        }
    }

    private void executeRequestHandlerURL(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, URL uRL) throws ServletException {
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 0;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        RequestHandlerURL requestHandlerURL = null;
        string2 = httpServletRequest.getContextPath();
        string3 = httpServletRequest.getRequestURI();
        n = string3.indexOf(string2);
        string4 = string3.substring(0, string2.length());
        string = string4 + uRL.getURL();
        string5 = (String)httpServletRequest.getAttribute("alert");
        if (string5 != null && string5.length() > 0) {
            string = Methods.addQueryStringElement(string, "alert", string5);
        }
        if ((string6 = (String)httpServletRequest.getAttribute("confirmation")) != null && string6.length() > 0) {
            string = Methods.addQueryStringElement(string, "confirmation", string6);
        }
        requestHandlerURL = new RequestHandlerURL(string);
        try {
            httpServletResponse.sendRedirect(requestHandlerURL.getURL());
        }
        catch (IOException iOException) {
            throw new ServletException((Throwable)iOException);
        }
    }

    private void executeViewURL(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, URL uRL) throws ServletException {
        RequestDispatcher requestDispatcher = null;
        requestDispatcher = httpServletRequest.getRequestDispatcher(uRL.getURL());
        try {
            requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        catch (IOException iOException) {
            throw new ServletException((Throwable)iOException);
        }
    }
}

