/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class UnicodeUtils {
    public static byte[] convert(byte[] byArray, String string) throws Exception {
        int n;
        UnicodeInputStream unicodeInputStream = new UnicodeInputStream(new ByteArrayInputStream(byArray), "ASCII");
        boolean bl = UnicodeUtils.getBOM(string) != null;
        String string2 = unicodeInputStream.getEncoding();
        String string3 = UnicodeUtils.getBOM(string2);
        if (string3 == null) {
            string3 = UnicodeUtils.getBOM(string);
        }
        unicodeInputStream.close();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(byArray, unicodeInputStream.getBOMOffset(), byArray.length), string2));
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, string));
        if (string3 == null || bl) {
            // empty if block
        }
        char[] cArray = new char[4096];
        while ((n = bufferedReader.read(cArray)) != -1) {
            ((Writer)bufferedWriter).write(cArray, 0, n);
        }
        bufferedReader.close();
        ((Writer)bufferedWriter).close();
        return byteArrayOutputStream.toByteArray();
    }

    public static String getBOM(String string) throws UnsupportedEncodingException {
        if ("UTF-8".equals(string)) {
            byte[] byArray = new byte[]{-17, -69, -65};
            return new String(byArray, string);
        }
        if ("UTF-16BE".equals(string)) {
            byte[] byArray = new byte[]{-2, -1};
            return new String(byArray, string);
        }
        if ("UTF-16LE".equals(string)) {
            byte[] byArray = new byte[]{-1, -2};
            return new String(byArray, string);
        }
        if ("UTF-32BE".equals(string)) {
            byte[] byArray = new byte[]{0, 0, -2, -1};
            return new String(byArray, string);
        }
        if ("UTF-32LE".equals(string)) {
            byte[] byArray = new byte[]{0, 0, -1, -2};
            return new String(byArray, string);
        }
        return null;
    }

    public static class UnicodeInputStream
    extends InputStream {
        private PushbackInputStream internalIn;
        private boolean isInited = false;
        private int BOMOffset = -1;
        private String defaultEnc;
        private String encoding;
        public static final int BOM_SIZE = 4;

        public UnicodeInputStream(InputStream inputStream, String string) {
            this.internalIn = new PushbackInputStream(inputStream, 4);
            this.defaultEnc = string;
        }

        public String getDefaultEncoding() {
            return this.defaultEnc;
        }

        public String getEncoding() {
            if (!this.isInited) {
                try {
                    this.init();
                }
                catch (IOException iOException) {
                    IllegalStateException illegalStateException = new IllegalStateException("Init method failed.");
                    illegalStateException.initCause(illegalStateException);
                    throw illegalStateException;
                }
            }
            return this.encoding;
        }

        protected void init() throws IOException {
            int n;
            if (this.isInited) {
                return;
            }
            byte[] byArray = new byte[4];
            int n2 = this.internalIn.read(byArray, 0, byArray.length);
            if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == -2 && byArray[3] == -1) {
                this.encoding = "UTF-32BE";
                n = n2 - 4;
            } else if (byArray[0] == -1 && byArray[1] == -2 && byArray[2] == 0 && byArray[3] == 0) {
                this.encoding = "UTF-32LE";
                n = n2 - 4;
            } else if (byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
                this.encoding = "UTF-8";
                n = n2 - 3;
            } else if (byArray[0] == -2 && byArray[1] == -1) {
                this.encoding = "UTF-16BE";
                n = n2 - 2;
            } else if (byArray[0] == -1 && byArray[1] == -2) {
                this.encoding = "UTF-16LE";
                n = n2 - 2;
            } else {
                this.encoding = this.defaultEnc;
                n = n2;
            }
            this.BOMOffset = 4 - n;
            if (n > 0) {
                this.internalIn.unread(byArray, n2 - n, n);
            }
            this.isInited = true;
        }

        public void close() throws IOException {
            this.isInited = true;
            this.internalIn.close();
        }

        public int read() throws IOException {
            this.isInited = true;
            return this.internalIn.read();
        }

        public int getBOMOffset() {
            return this.BOMOffset;
        }
    }
}

