/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.util;

import com.jronimo.collections.NullFreeMutableList;
import com.jronimo.collections.NullFreeMutableSet;
import com.jronimo.collections.collection.hidden.impl.ListIterator;
import com.jronimo.text.ResourceText;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.util.Assert;
import com.jronimo.util.FileMethods;
import com.jronimo.util.Logger;
import com.jronimo.util.StringIterator;
import com.jronimo.util.ranges.Ranges;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringWrapper
implements Comparable<Object>,
Iterable<String> {
    private static final Logger logger = Logger.getLogger(StringWrapper.class);
    protected StringBuilder string;
    protected OperationResult operationResult;

    public StringWrapper() {
        this.string = new StringBuilder();
    }

    public StringWrapper(Object object) {
        Assert.errorParamMustNotBeNull("object", object);
        this.string = new StringBuilder(object.toString());
    }

    public StringWrapper(File file, boolean bl) {
        Assert.errorParamMustNotBeNull("file", file);
        this.string = new StringBuilder(FileMethods.readTextFile(file, bl));
    }

    public OperationResult getOperationResult() {
        return this.operationResult;
    }

    private OperationResult clearOperationResult() {
        this.operationResult = new OperationResult();
        return this.operationResult;
    }

    public int capacity() {
        return this.string.capacity();
    }

    public void ensureCapacity(int n) {
        this.string.ensureCapacity(n);
    }

    public void trimToSize() {
        this.string.trimToSize();
    }

    public int length() {
        return this.string.length();
    }

    public int indexOf(String string, Ranges ranges) {
        return this.indexOf(string, 0, ranges);
    }

    public int indexOf(String string, int n, Ranges ranges) {
        int n2 = -1;
        int n3 = 0;
        Assert.errorParamMustNotBeNull("string", string);
        Assert.errorParamMustNotBeNull("exclusionRanges", ranges);
        n3 = n;
        while ((n3 = this.string.indexOf(string, n3)) >= 0) {
            if (ranges.contains(n3)) {
                ++n3;
                continue;
            }
            n2 = n3;
            break;
        }
        return n2;
    }

    public int indexOf(String string) {
        Assert.errorParamMustNotBeNull("string", string);
        return this.indexOf(string, 0);
    }

    public int indexOf(String ... stringArray) {
        return this.indexOf(0, stringArray);
    }

    public int indexOf(int n, String ... stringArray) {
        int n2 = -1;
        int n3 = -1;
        Assert.errorParamMustNotBeNull("string", stringArray);
        for (String string : stringArray) {
            n3 = this.indexOf(string, n);
            if (n3 < 0) continue;
            n2 = n2 == -1 ? n3 : Math.min(n3, n2);
        }
        return n2;
    }

    public int indexOf(String string, int n) {
        int n2 = -1;
        int n3 = 0;
        Assert.errorParamMustNotBeNull("substring", string);
        n3 = n - 1;
        ++n3;
        n3 = this.string.indexOf(string, n3);
        if (n3 >= 0) {
            n2 = n3;
        }
        return n2;
    }

    public int lastIndexOf(String string) {
        Assert.errorParamMustNotBeNull("string", string);
        return this.lastIndexOf(string, this.length());
    }

    public int lastIndexOf(String string, int n) {
        int n2 = -1;
        int n3 = 0;
        Assert.errorParamMustNotBeNull("substring", string);
        n3 = n + 1;
        --n3;
        n3 = this.string.lastIndexOf(string, n3);
        if (n3 >= 0) {
            n2 = n3;
        }
        return n2;
    }

    public String substring(int n) {
        return this.substring(n, this.length());
    }

    public String substring(int n, int n2) {
        return this.substring(n, n2, false);
    }

    public String substring(int n, boolean bl) {
        return this.substring(n, this.length(), bl);
    }

    public String substring(int n, int n2, boolean bl) {
        String string = null;
        string = this.string.substring(n, n2);
        if (bl) {
            this.delete(n, n2);
        }
        return string;
    }

    public boolean startsWith(String ... stringArray) {
        return this.startsWith(false, stringArray);
    }

    public boolean startsWith(boolean bl, String ... stringArray) {
        boolean bl2 = false;
        if (stringArray != null) {
            for (String string : stringArray) {
                if (!this.startsWith(string, 0)) continue;
                bl2 = true;
                if (!bl) break;
                this.deleteFirst(string);
                break;
            }
        }
        return bl2;
    }

    public boolean startsWith(String string, int n) {
        Assert.errorParamMustNotBeNull("substring", string);
        return this.indexOf(string, n) == n;
    }

    public boolean endsWith(String string) {
        boolean bl = false;
        int n = 0;
        Assert.errorParamMustNotBeNull("substring", string);
        bl = string.length() == 0 ? true : (n = this.lastIndexOf(string)) >= 0 && n == this.length() - string.length();
        return bl;
    }

    public boolean endsWithAny(String ... stringArray) {
        boolean bl = false;
        if (stringArray != null) {
            for (String string : stringArray) {
                if (!this.endsWith(string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public StringWrapper append(Object object) {
        String string = null;
        string = String.valueOf(object);
        if (string.length() > 0) {
            this.string.append(string);
            this.updated();
        }
        return this;
    }

    public StringWrapper append(Object object, boolean bl) {
        if (bl) {
            this.append(object);
        }
        return this;
    }

    public StringWrapper insert(int n, Object object) {
        String string = null;
        string = String.valueOf(object);
        if (string.length() > 0) {
            this.string.insert(n, object);
            this.updated();
        }
        return this;
    }

    public StringWrapper insert(int n, Object object, boolean bl) {
        if (bl) {
            this.insert(n, object);
        }
        return this;
    }

    public StringWrapper delete(int n) {
        this.delete(n, this.length());
        return this;
    }

    public StringWrapper delete(int n, int n2) {
        this.string.delete(n, n2);
        this.updated();
        return this;
    }

    public StringWrapper deleteCharAt(int n) {
        this.string.deleteCharAt(n);
        this.updated();
        return this;
    }

    public StringWrapper replace(int n, int n2, String string) {
        Assert.errorParamMustNotBeNull("string", string);
        this.string.replace(n, n2, string);
        this.updated();
        return this;
    }

    public StringWrapper reverse() {
        this.string.reverse();
        this.updated();
        return this;
    }

    public StringWrapper toLowerCase() {
        this.replaceContent(this.toString().toLowerCase());
        return this;
    }

    public StringWrapper toUpperCase() {
        this.replaceContent(this.toString().toUpperCase());
        return this;
    }

    @Override
    public int compareTo(Object object) {
        int n = 0;
        int n2 = n = object == null ? 1 : this.toString().compareTo(object.toString());
        n = n < 0 ? -1 : (n > 0 ? 1 : n);
        return n;
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public boolean equalsIgnoreCase(Object object) {
        return this.toString().equalsIgnoreCase(String.valueOf(object));
    }

    public boolean equals(Object object) {
        return object == null ? false : this.toString().equals(object.toString());
    }

    public boolean equalsAny(String ... stringArray) {
        return this.equalsAny(false, stringArray);
    }

    public boolean equalsAny(boolean bl, String ... stringArray) {
        boolean bl2 = false;
        String string = null;
        if (stringArray != null) {
            string = this.toString();
            for (String string2 : stringArray) {
                bl2 = bl ? string.equalsIgnoreCase(string2) : string.equals(string2);
                if (bl2) break;
            }
        }
        return bl2;
    }

    public String toString() {
        return this.string.toString();
    }

    public Boolean asBoolean() {
        return Boolean.valueOf(this.string.toString());
    }

    public Integer asInteger() {
        return Integer.valueOf(this.string.toString());
    }

    public Long asLong() {
        return Long.valueOf(this.string.toString());
    }

    public boolean isWhiteSpace() {
        return this.length() == 0 ? false : this.toString().trim().length() == 0;
    }

    public int indexOfWhiteSpace() {
        return this.indexOfWhiteSpace(0);
    }

    public int indexOfWhiteSpace(int n) {
        int n2 = -1;
        StringIterator stringIterator = null;
        stringIterator = this.iterator(n);
        while (stringIterator.hasNext()) {
            if (stringIterator.next().trim().length() != 0) continue;
            n2 = stringIterator.indexOfLastReturned();
            break;
        }
        return n2;
    }

    public int indexOfNonWhiteSpace() {
        return this.indexOfNonWhiteSpace(0);
    }

    public int indexOfNonWhiteSpace(int n) {
        int n2 = -1;
        StringIterator stringIterator = null;
        String string = null;
        this.assertInBounds(n, true);
        if (!this.isEmpty() && this.inBounds(n, false)) {
            stringIterator = this.iterator(n);
            while (stringIterator.hasNext()) {
                string = stringIterator.next();
                if (string.trim().length() != 1) continue;
                n2 = stringIterator.indexOfLastReturned();
                break;
            }
        }
        return n2;
    }

    public int lastIndexOfNonWhiteSpace() {
        return this.lastIndexOfNonWhiteSpace(this.length() == 0 ? 0 : this.length() - 1);
    }

    public int lastIndexOfNonWhiteSpace(int n) {
        int n2 = -1;
        StringIterator stringIterator = null;
        String string = null;
        this.assertInBounds(n, true);
        if (!this.isEmpty() && this.inBounds(n, false)) {
            stringIterator = this.iterator(0, n + 1);
            while (stringIterator.hasPrevious()) {
                string = stringIterator.previous();
                if (string.trim().length() != 1) continue;
                n2 = stringIterator.indexOfLastReturned();
                break;
            }
        }
        return n2;
    }

    public boolean containsWhiteSpace() {
        return this.indexOfWhiteSpace() >= 0;
    }

    public String getLeadingWhiteSpace() {
        String string = null;
        int n = 0;
        n = this.indexOfNonWhiteSpace();
        if (n < 0) {
            n = this.length();
        }
        string = this.getFirst(n);
        return string;
    }

    public String getTrailingWhiteSpace() {
        String string = null;
        int n = 0;
        n = this.lastIndexOfNonWhiteSpace();
        n = n >= 0 ? n + 1 : this.length();
        string = this.substring(n);
        return string;
    }

    public boolean hasLeadingWhiteSpace() {
        boolean bl = false;
        bl = this.getLeadingWhiteSpace().length() > 0;
        return bl;
    }

    public boolean hasTrailingWhiteSpace() {
        boolean bl = false;
        bl = this.getTrailingWhiteSpace().length() > 0;
        return bl;
    }

    public StringWrapper trim() {
        if (this.length() > 0) {
            this.leftTrim();
            this.rightTrim();
        }
        return this;
    }

    public StringWrapper leftTrim() {
        this.deleteFirst(this.getLeadingWhiteSpace().length());
        return this;
    }

    public StringWrapper rightTrim() {
        this.deleteLast(this.getTrailingWhiteSpace().length());
        return this;
    }

    public StringWrapper removeWhiteSpace() {
        return this.removeWhiteSpace("");
    }

    public StringWrapper removeWhiteSpace(String string) {
        StringWrapper stringWrapper = null;
        StringIterator stringIterator = null;
        String string2 = null;
        Assert.errorParamMustNotBeNull("exceptions", string);
        if (this.length() > 0) {
            stringWrapper = new StringWrapper(string);
            stringIterator = this.iterator();
            while (stringIterator.hasNext()) {
                string2 = stringIterator.next();
                if (string2.trim().length() != 0 || stringWrapper.contains(string2)) continue;
                stringIterator.remove();
            }
        }
        return this;
    }

    public StringWrapper reduceConsecutiveSpaces() {
        return this.reduceConsecutiveSubstrings(" ");
    }

    public StringWrapper replaceWhiteSpaceCharacters(String string) {
        StringIterator stringIterator = null;
        String string2 = null;
        Assert.errorParamMustNotBeNull("substring", string);
        stringIterator = this.iterator();
        while (stringIterator.hasNext()) {
            string2 = stringIterator.next();
            if (string2.trim().length() != 0) continue;
            stringIterator.replace(string);
        }
        return this;
    }

    public StringWrapper replaceWhiteSpace(String string) {
        int n = 0;
        String string2 = null;
        Integer n2 = null;
        Integer n3 = null;
        while (n < this.length()) {
            string2 = this.substring(n, n + 1);
            if (string2.trim().length() == 1) {
                if (n2 == null) {
                    ++n;
                } else {
                    n3 = n;
                    this.replace(n2, n3, string);
                    n += string.length() - (n3 - n2) + 1;
                    n2 = null;
                    n3 = null;
                }
            } else {
                if (n2 == null) {
                    n2 = n;
                } else {
                    n3 = n;
                }
                ++n;
            }
            if (n != this.length() || n2 == null) continue;
            this.replace(n2, this.length(), string);
        }
        return this;
    }

    public boolean isEmpty() {
        return this.length() == 0;
    }

    public boolean hasContent() {
        return this.length() > 0;
    }

    public NullFreeMutableSet<Integer> allIndexesOf(String string) {
        return this.allIndexesOf(string, 0);
    }

    public NullFreeMutableSet<Integer> allIndexesOf(String string, int n) {
        NullFreeMutableSet<Integer> nullFreeMutableSet = null;
        int n2 = 0;
        Assert.errorParamMustNotBeNull("substring", string);
        nullFreeMutableSet = new NullFreeMutableSet<Integer>();
        if (this.length() > 0 && string.length() > 0 && n >= 0 && n < this.length()) {
            n2 = n;
            while ((n2 = this.indexOf(string, n2)) >= 0) {
                nullFreeMutableSet.add(n2);
                n2 += string.length();
            }
        }
        return nullFreeMutableSet;
    }

    public NullFreeMutableSet<Integer> allIndexesOfNumbers() {
        return this.allIndexesOfNumbers(ResourceText.getText((Object)ResourceTextIdentifiers.DIGITS), 0);
    }

    public NullFreeMutableSet<Integer> allIndexesOfNumbers(int n) {
        return this.allIndexesOfNumbers(ResourceText.getText((Object)ResourceTextIdentifiers.DIGITS), n);
    }

    public NullFreeMutableSet<Integer> allIndexesOfNumbers(String string, int n) {
        NullFreeMutableSet<Integer> nullFreeMutableSet = null;
        StringWrapper stringWrapper = null;
        StringIterator stringIterator = null;
        String string2 = null;
        boolean bl = false;
        Assert.errorParamMustNotBeNull("digits", string);
        nullFreeMutableSet = new NullFreeMutableSet<Integer>();
        if (this.length() > 0 && string.length() > 0 && this.inBounds(n, false)) {
            stringWrapper = new StringWrapper(string);
            stringIterator = this.iterator(n);
            while (stringIterator.hasNext()) {
                string2 = stringIterator.next();
                if (stringWrapper.contains(string2)) {
                    if (bl) continue;
                    bl = true;
                    nullFreeMutableSet.add(stringIterator.indexOfLastReturned());
                    continue;
                }
                bl = false;
            }
        }
        return nullFreeMutableSet;
    }

    public NullFreeMutableSet<Integer> allIndexesOfUpperCase() {
        return this.allIndexesOfUpperCase(0);
    }

    public NullFreeMutableSet<Integer> allIndexesOfUpperCase(int n) {
        NullFreeMutableSet<Integer> nullFreeMutableSet = null;
        StringIterator stringIterator = null;
        String string = null;
        nullFreeMutableSet = new NullFreeMutableSet<Integer>();
        if (this.length() > 0 && this.inBounds(n, false)) {
            stringIterator = this.iterator(n);
            while (stringIterator.hasNext()) {
                string = stringIterator.next();
                if (string.equals(string.toLowerCase())) continue;
                nullFreeMutableSet.add(stringIterator.indexOfLastReturned());
            }
        }
        return nullFreeMutableSet;
    }

    public int substringCount(String string) {
        return this.substringCount(string, 0);
    }

    public int substringCount(String string, int n) {
        return this.allIndexesOf(string, n).size();
    }

    public boolean contains(String string) {
        Assert.errorParamMustNotBeNull("substring", string);
        return this.indexOf(string) >= 0;
    }

    public boolean containsAll(String ... stringArray) {
        boolean bl = false;
        Assert.errorParamMustNotBeNull("substrings", stringArray);
        if (stringArray.length > 0) {
            bl = true;
            for (String string : stringArray) {
                if (this.contains(string)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public boolean containsAny(String ... stringArray) {
        boolean bl = false;
        Assert.errorParamMustNotBeNull("substrings", stringArray);
        for (String string : stringArray) {
            if (!this.contains(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean containsOnlyLetters() {
        return this.containsOnly(ResourceText.getText((Object)ResourceTextIdentifiers.ALPHABET_LOWER_CASE) + ResourceText.getText((Object)ResourceTextIdentifiers.ALPHABET_UPPER_CASE));
    }

    public boolean containsOnlyLetters(String string) {
        return this.containsOnly(string);
    }

    public boolean containsOnlyUpperCaseLetters() {
        return this.containsOnly(ResourceText.getText((Object)ResourceTextIdentifiers.ALPHABET_UPPER_CASE));
    }

    public boolean containsOnlyUpperCaseLetters(String string) {
        return this.containsOnly(string);
    }

    public boolean containsOnlyLowerCaseLetters() {
        return this.containsOnly(ResourceText.getText((Object)ResourceTextIdentifiers.ALPHABET_LOWER_CASE));
    }

    public boolean containsOnlyLowerCaseLetters(String string) {
        return this.containsOnly(string);
    }

    public boolean containsOnlyDigits() {
        return this.containsOnly(ResourceText.getText((Object)ResourceTextIdentifiers.DIGITS));
    }

    public boolean containsOnlyDigits(String string) {
        return this.containsOnly(string);
    }

    public boolean containsOnly(String string) {
        boolean bl = false;
        StringWrapper stringWrapper = null;
        Assert.errorParamMustNotBeEmpty("characters", string);
        if (this.length() > 0) {
            bl = true;
            stringWrapper = new StringWrapper(string);
            for (String string2 : this) {
                if (stringWrapper.contains(string2)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public boolean containsAnyCharacters(String string) {
        boolean bl = false;
        StringWrapper stringWrapper = null;
        Assert.errorParamMustNotBeNull("characters", string);
        if (this.length() > 0 && string.length() > 0) {
            stringWrapper = new StringWrapper(string);
            for (String string2 : this) {
                if (!stringWrapper.contains(string2)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean containsAllCharacters(String string) {
        boolean bl = true;
        StringWrapper stringWrapper = null;
        Assert.errorParamMustNotBeEmpty("characters", string);
        if (this.length() > 0 && string.length() > 0) {
            stringWrapper = new StringWrapper(string);
            for (String string2 : this) {
                stringWrapper.remove(string2);
                if (!stringWrapper.isEmpty()) continue;
                break;
            }
            bl = stringWrapper.isEmpty();
        }
        return bl;
    }

    public boolean startsWithLetter() {
        return this.startsWithLetter(ResourceText.getText((Object)ResourceTextIdentifiers.ALPHABET_LOWER_CASE) + ResourceText.getText((Object)ResourceTextIdentifiers.ALPHABET_UPPER_CASE));
    }

    public boolean startsWithLetter(String string) {
        Assert.errorParamMustNotBeEmpty("letters", string);
        return this.startsWithCharacter(string);
    }

    public boolean startsWithUpperCaseLetter() {
        return this.startsWithUpperCaseLetter(ResourceText.getText((Object)ResourceTextIdentifiers.ALPHABET_UPPER_CASE));
    }

    public boolean startsWithUpperCaseLetter(String string) {
        Assert.errorParamMustNotBeEmpty("letters", string);
        return this.startsWithCharacter(string);
    }

    public boolean startsWithLowerCaseLetter() {
        return this.startsWithLowerCaseLetter(ResourceText.getText((Object)ResourceTextIdentifiers.ALPHABET_LOWER_CASE));
    }

    public boolean startsWithLowerCaseLetter(String string) {
        Assert.errorParamMustNotBeEmpty("letters", string);
        return this.startsWithCharacter(string);
    }

    public boolean startsWithCharacter(String string) {
        boolean bl = false;
        Assert.errorParamMustNotBeNull("characters", string);
        if (this.length() > 0 && string.length() > 0) {
            bl = new StringWrapper(string).contains(this.getFirst());
        }
        return bl;
    }

    public boolean endsWithUpperCaseLetter() {
        return this.endsWithUpperCaseLetter(ResourceText.getText((Object)ResourceTextIdentifiers.ALPHABET_UPPER_CASE));
    }

    public boolean endsWithUpperCaseLetter(String string) {
        Assert.errorParamMustNotBeEmpty("letters", string);
        return this.endsWithCharacter(string);
    }

    public boolean endsWithLowerCaseLetter() {
        return this.endsWithLowerCaseLetter(ResourceText.getText((Object)ResourceTextIdentifiers.ALPHABET_LOWER_CASE));
    }

    public boolean endsWithLowerCaseLetter(String string) {
        Assert.errorParamMustNotBeEmpty("letters", string);
        return this.endsWithCharacter(string);
    }

    public boolean endsWithCharacter(String string) {
        boolean bl = false;
        Assert.errorParamMustNotBeNull("characters", string);
        if (this.length() > 0 && string.length() > 0) {
            bl = new StringWrapper(string).contains(this.getLast());
        }
        return bl;
    }

    public boolean isAllUpperCase() {
        boolean bl = false;
        boolean bl2 = false;
        if (this.length() > 0) {
            bl = true;
            for (String string : this) {
                bl2 = true;
                if (string.equals(string.toUpperCase())) continue;
                bl = false;
                break;
            }
        }
        if (!bl2) {
            bl = false;
        }
        return bl;
    }

    public boolean isAllLowerCase() {
        boolean bl = false;
        boolean bl2 = false;
        if (this.length() > 0) {
            bl = true;
            for (String string : this) {
                bl2 = true;
                if (string.equals(string.toLowerCase())) continue;
                bl = false;
                break;
            }
        }
        if (!bl2) {
            bl = false;
        }
        return bl;
    }

    public boolean isFirstCharacterUpperCase() {
        boolean bl = false;
        String string = null;
        if (this.length() > 0) {
            string = this.substring(0, 1);
            bl = string.equals(string.toUpperCase());
        }
        return bl;
    }

    public boolean isFirstCharacterLowerCase() {
        boolean bl = false;
        String string = null;
        if (this.length() > 0) {
            string = this.substring(0, 1);
            bl = string.equals(string.toLowerCase());
        }
        return bl;
    }

    public String getFirst() {
        return this.getFirst(1);
    }

    public String getFirst(int n) {
        String string = null;
        if (this.length() > 0) {
            n = n < 0 ? 0 : (n > this.length() ? this.length() : n);
            string = this.string.substring(0, n);
        } else {
            string = "";
        }
        return string;
    }

    public String getLast() {
        return this.getLast(1);
    }

    public String getLast(int n) {
        String string = null;
        if (this.length() > 0) {
            n = n < 0 ? 0 : (n > this.length() ? this.length() : n);
            string = this.substring(this.length() - n);
        } else {
            string = "";
        }
        return string;
    }

    public String fromLast(String string) {
        return this.fromLast(string, false);
    }

    public String fromLast(String string, boolean bl) {
        String string2 = null;
        int n = 0;
        n = this.lastIndexOf(string);
        if (n >= 0) {
            string2 = this.from(string, n, false, bl);
        }
        return string2;
    }

    public String from(String string) {
        return this.from(string, 0, false, false);
    }

    public String from(String string, boolean bl, boolean bl2) {
        return this.from(string, 0, bl, bl2);
    }

    public String from(String string, int n, boolean bl, boolean bl2) {
        String string2 = null;
        int n2 = 0;
        Assert.errorParamMustNotBeNull("substring", string);
        if (this.length() > 0 && string.length() > 0 && (n2 = this.indexOf(string, n)) >= 0) {
            if (bl && n2 > 0) {
                n2 = this.lastIndexOfNonWhiteSpace(n2 - 1) + 1;
            }
            string2 = this.substring(n2);
            if (bl2) {
                this.delete(n2);
            }
        }
        return string2;
    }

    public String after(int n) {
        return this.string.substring(n + 1);
    }

    public String after(String string) {
        return this.after(string, 0, false);
    }

    public String after(String string, boolean bl) {
        return this.after(string, 0, bl);
    }

    public String after(String string, int n, boolean bl) {
        String string2 = null;
        int n2 = 0;
        Assert.errorParamMustNotBeNull("substring", string);
        if (this.length() > 0 && string.length() > 0 && (n2 = this.indexOf(string, n)) >= 0) {
            string2 = this.substring(n2 += string.length());
            if (bl) {
                this.delete(n2);
            }
        }
        return string2;
    }

    public String afterLast(String string, boolean bl) {
        String string2 = null;
        int n = 0;
        n = this.lastIndexOf(string);
        if (n >= 0) {
            string2 = this.after(string, n, bl);
        }
        return string2;
    }

    public String to(String string) {
        return this.to(string, 0, false);
    }

    public String to(String string, boolean bl) {
        return this.to(string, 0, bl);
    }

    public String to(String string, int n, boolean bl) {
        String string2 = null;
        int n2 = 0;
        Assert.errorParamMustNotBeNull("substring", string);
        if (this.length() > 0 && string.length() > 0 && (n2 = this.indexOf(string, n)) >= 0) {
            string2 = this.getFirst(n2 += string.length());
            if (bl) {
                this.deleteFirst(n2);
            }
        }
        return string2;
    }

    public String before(int n) {
        return this.string.substring(0, n);
    }

    public String before(int n, boolean bl) {
        String string = null;
        if (this.length() > 0 && this.inBounds(n, true)) {
            string = this.getFirst(n);
            if (bl) {
                this.deleteFirst(n);
            }
        }
        return string;
    }

    public String before(String string) {
        return this.before(string, 0, false, false);
    }

    public String before(String string, boolean bl) {
        return this.before(string, 0, false, bl);
    }

    public String before(String string, int n, boolean bl) {
        return this.before(string, n, false, bl);
    }

    public String before(String string, boolean bl, boolean bl2) {
        return this.before(string, 0, bl, bl2);
    }

    public String before(String string, int n, boolean bl, boolean bl2) {
        String string2 = null;
        int n2 = 0;
        Assert.errorParamMustNotBeNull("substring", string);
        if (this.length() > 0 && string.length() > 0 && (n2 = this.indexOf(string, n)) >= 0) {
            if (bl && n2 > 0) {
                n2 = this.lastIndexOfNonWhiteSpace(n2 - 1) + 1;
            }
            string2 = this.getFirst(n2);
            if (bl2) {
                this.deleteFirst(n2);
            }
        }
        return string2;
    }

    public String between(String string, String string2) {
        return this.between(string, string2, 0);
    }

    public String between(String string, String string2, int n) {
        return this.between(string, string2, n, false);
    }

    public String between(String string, String string2, boolean bl) {
        return this.between(string, string2, 0, bl);
    }

    public String between(String string, String string2, int n, boolean bl) {
        String string3 = null;
        int n2 = -1;
        int n3 = -1;
        Assert.errorParamMustNotBeEmpty("startString", string);
        Assert.errorParamMustNotBeEmpty("endString", string2);
        if (this.inBounds(n, false)) {
            n2 = this.indexOf(string, n);
            if (n2 >= 0) {
                n3 = this.indexOf(string2, n2 += string.length());
            }
            if (n3 >= 0) {
                string3 = this.substring(n2, n3);
                if (bl) {
                    this.delete(n2, n3);
                }
            }
        }
        return string3;
    }

    public String between(String string, int n) {
        return this.between(string, n, 0);
    }

    public String between(String string, int n, int n2) {
        return this.between(string, n, n2, false);
    }

    public String between(String string, int n, boolean bl) {
        return this.between(string, n, 0, bl);
    }

    public String between(String string, int n, int n2, boolean bl) {
        String string2 = null;
        int n3 = -1;
        Assert.errorParamMustNotBeEmpty("startString", string);
        this.assertInBounds(n, true);
        this.assertInBounds(n2, true);
        if (this.length() >= string.length() && n2 >= 0 && n2 <= n - string.length() && (n3 = this.indexOf(string, n2)) >= 0 && (n3 += string.length()) <= n) {
            string2 = this.substring(n3, n);
            if (bl) {
                this.delete(n3, n);
            }
        }
        return string2;
    }

    public String substring(int n, String string) {
        return this.substring(n, string, n + 1, false);
    }

    public String substring(int n, String string, int n2) {
        return this.substring(n, string, n2, false);
    }

    public String substring(int n, String string, boolean bl) {
        return this.substring(n, string, n + 1, bl);
    }

    public String substring(int n, String string, int n2, boolean bl) {
        String string2 = null;
        int n3 = -1;
        this.assertInBounds(n, true);
        Assert.errorParamMustNotBeEmpty("endString", string);
        if (this.inBounds(n2, false) && (n3 = this.indexOf(string, n2)) >= 0 && n <= n3) {
            string2 = this.substring(n, n3);
            if (bl) {
                this.delete(n, n3);
            }
        }
        return string2;
    }

    public boolean surrounded(String string) {
        boolean bl = false;
        Assert.errorParamMustNotBeNull("substring", string);
        if (string.length() > 0 && this.length() >= string.length() * 2 && !this.equals(string)) {
            bl = this.startsWith(string) && this.endsWith(string);
        }
        return bl;
    }

    public NullFreeMutableList<String> split(String string) {
        return this.split(string, false, false, false, false);
    }

    public NullFreeMutableList<String> split(String string, boolean bl) {
        return this.split(string, false, false, false, bl);
    }

    public NullFreeMutableList<String> split(String string, boolean bl, boolean bl2, boolean bl3) {
        return this.split(string, bl, bl2, bl3, false);
    }

    public NullFreeMutableList<String> split(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        NullFreeMutableList<String> nullFreeMutableList = null;
        NullFreeMutableSet<Integer> nullFreeMutableSet = null;
        String string2 = null;
        int n = -1;
        int n2 = 0;
        Assert.errorParamMustNotBeEmpty("delimiter", string);
        nullFreeMutableList = new NullFreeMutableList<String>();
        nullFreeMutableSet = this.allIndexesOf(string);
        if (nullFreeMutableSet.isEmpty()) {
            nullFreeMutableList.add(this.toString());
        } else {
            if ((Integer)nullFreeMutableSet.getFirst() == 0) {
                if (bl2) {
                    nullFreeMutableList.add("");
                }
            } else {
                string2 = this.substring(0, (Integer)nullFreeMutableSet.getFirst());
                if (bl4) {
                    string2 = string2.trim();
                }
                nullFreeMutableList.add(string2);
            }
            for (Integer n3 : nullFreeMutableSet) {
                n3 = n3 + string.length();
                if (nullFreeMutableSet.isLastIndex(++n)) {
                    if (n3.intValue() == this.length()) {
                        if (!bl3) continue;
                        nullFreeMutableList.add("");
                        continue;
                    }
                    string2 = this.substring(n3);
                    if (bl4) {
                        string2 = string2.trim();
                    }
                    nullFreeMutableList.add(string2);
                    continue;
                }
                n2 = (Integer)nullFreeMutableSet.get(n + 1);
                if (n3 == n2) {
                    if (!bl) continue;
                    nullFreeMutableList.add("");
                    continue;
                }
                string2 = this.substring((int)n3, n2);
                if (bl4) {
                    string2 = string2.trim();
                }
                nullFreeMutableList.add(string2);
            }
        }
        return nullFreeMutableList;
    }

    public NullFreeMutableList<String> getLines(boolean bl, boolean bl2, boolean bl3) {
        NullFreeMutableList<String> nullFreeMutableList = null;
        java.util.ListIterator listIterator = null;
        StringWrapper stringWrapper = null;
        if (this.isEmpty()) {
            nullFreeMutableList = bl ? new NullFreeMutableList<String>("") : new NullFreeMutableList<String>();
        } else {
            nullFreeMutableList = new NullFreeMutableList<String>((Collection<String>)this.split("\n", true, true, true));
            listIterator = nullFreeMutableList.listIterator();
            while (((ListIterator)listIterator).hasNext()) {
                stringWrapper = new StringWrapper(((ListIterator)listIterator).next());
                if (bl2 && bl3) {
                    stringWrapper.trim();
                } else if (bl2) {
                    stringWrapper.leftTrim();
                } else if (bl3) {
                    stringWrapper.rightTrim();
                }
                if (bl || !stringWrapper.isEmpty()) {
                    ((ListIterator)listIterator).set(stringWrapper.toString());
                    continue;
                }
                ((ListIterator)listIterator).remove();
            }
        }
        return nullFreeMutableList;
    }

    public int getConsecutiveCountBefore(int n, String string) {
        int n2 = 0;
        StringIterator stringIterator = null;
        String string2 = null;
        StringWrapper stringWrapper = null;
        if (this.inBounds(n, true)) {
            if (!this.isEmpty() && string.length() > 0 && n > 0) {
                stringIterator = this.iterator(0, n);
                stringWrapper = new StringWrapper();
                while (stringIterator.hasPrevious()) {
                    stringWrapper.clear();
                    while (stringIterator.hasPrevious()) {
                        string2 = stringIterator.previous();
                        stringWrapper.insert(0, string2);
                        if (stringWrapper.length() != string.length()) continue;
                    }
                    if (stringWrapper.equals(string)) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
        } else {
            n2 = -1;
        }
        return n2;
    }

    public int getConsecutiveCountFrom(int n, String string) {
        int n2 = 0;
        StringIterator stringIterator = null;
        String string2 = null;
        StringWrapper stringWrapper = null;
        if (this.inBounds(n, true)) {
            if (!this.isEmpty() && string.length() > 0 && n < this.length()) {
                stringIterator = this.iterator(n);
                stringWrapper = new StringWrapper();
                while (stringIterator.hasNext()) {
                    stringWrapper.clear();
                    while (stringIterator.hasNext()) {
                        string2 = stringIterator.next();
                        stringWrapper.append(string2);
                        if (stringWrapper.length() != string.length()) continue;
                    }
                    if (stringWrapper.equals(string)) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
        } else {
            n2 = -1;
        }
        return n2;
    }

    public boolean isEscaped(int n) {
        boolean bl = false;
        this.assertInBounds(n, false);
        bl = this.getConsecutiveCountBefore(n, "\\") % 2 == 1;
        return bl;
    }

    public int indexOfNotEscaped(String string) {
        return this.indexOfNotEscaped(string, 0);
    }

    public int indexOfNotEscaped(String string, int n) {
        int n2 = -1;
        int n3 = 0;
        while ((n3 = this.indexOf(string, n)) >= 0) {
            if (this.isEscaped(n3)) {
                ++n;
                continue;
            }
            n2 = n3;
            break;
        }
        return n2;
    }

    public boolean inBounds(int n, boolean bl) {
        return n >= 0 && n <= (bl ? this.length() : this.length() - 1);
    }

    public StringWrapper clear() {
        this.string.delete(0, this.string.length());
        this.updated();
        return this;
    }

    public StringWrapper replaceContent(Object object) {
        this.string.delete(0, this.string.length());
        this.string.append(object);
        this.updated();
        return this;
    }

    public StringWrapper replace(String string, String string2) {
        int n = 0;
        Assert.errorParamMustNotBeNull("key", string);
        Assert.errorParamMustNotBeNull("value", string2);
        if (!this.isEmpty() && string.length() > 0 && (n = this.indexOf(string)) >= 0) {
            this.string.replace(n, n + string.length(), string2);
            this.updated();
        }
        return this;
    }

    public StringWrapper replaceAll(String string, String string2) {
        int n = 0;
        Assert.errorParamMustNotBeNull("key", string);
        Assert.errorParamMustNotBeNull("value", string2);
        if (!this.isEmpty() && string.length() > 0) {
            while ((n = this.indexOf(string, n)) >= 0) {
                this.replace(n, n + string.length(), string2);
                n += string2.length();
            }
        }
        return this;
    }

    public StringWrapper replaceAll(Map<String, String> map) {
        Assert.errorParamMustNotBeNull("replacementMap", map);
        for (String string : map.keySet()) {
            this.replaceAll(string, map.get(string));
        }
        return this;
    }

    public StringWrapper remove(String string) {
        this.replace(string, "");
        return this;
    }

    public StringWrapper removeAll(String string) {
        Assert.errorParamMustNotBeNull("substring", string);
        if (!this.isEmpty() && string.length() > 0) {
            this.replaceAll(string, "");
        }
        return this;
    }

    public StringWrapper reduceConsecutiveSubstrings(String string) {
        String string2 = null;
        Assert.errorParamMustNotBeEmpty("substring", string);
        if (this.length() >= string.length() * 2) {
            string2 = string + string;
            int n = this.indexOf(string2);
            while (this.indexOf(string2) >= 0) {
                this.replaceAll(string2, string);
            }
        }
        return this;
    }

    public StringWrapper retainAllCharacters(String string) {
        int n = 0;
        StringWrapper stringWrapper = null;
        StringIterator stringIterator = null;
        Assert.errorParamMustNotBeNull("characters", string);
        n = this.length();
        if (n > 0) {
            stringWrapper = new StringWrapper(string);
            stringIterator = this.iterator();
            while (stringIterator.hasNext()) {
                if (stringWrapper.contains(stringIterator.next())) continue;
                stringIterator.remove();
            }
            if (n != this.length()) {
                this.updated();
            }
        }
        return this;
    }

    public StringWrapper removeAllCharacters(String string) {
        int n = 0;
        StringWrapper stringWrapper = null;
        StringIterator stringIterator = null;
        boolean bl = false;
        Assert.errorParamMustNotBeNull("characters", string);
        n = this.length();
        if (n > 0 && string.length() > 0) {
            stringWrapper = new StringWrapper(string);
            stringIterator = this.iterator();
            while (stringIterator.hasNext()) {
                if (!stringWrapper.contains(stringIterator.next())) continue;
                stringIterator.remove();
            }
            if (n != this.length()) {
                this.updated();
            }
        }
        return this;
    }

    public StringWrapper removeLeadingNonLetters() {
        while (this.length() > 0 && !this.startsWithLetter()) {
            this.string.deleteCharAt(0);
            this.updated();
        }
        return this;
    }

    public StringWrapper removeLeadingNonLetters(String string) {
        Assert.errorParamMustNotBeNull("letters", string);
        if (string.length() > 0) {
            while (this.length() > 0 && !this.startsWithLetter(string)) {
                this.string.deleteCharAt(0);
                this.updated();
            }
        }
        return this;
    }

    public StringWrapper removeTrailingCharacters(String string) {
        Assert.errorParamMustNotBeNull("characters", string);
        if (string.length() > 0) {
            while (this.length() > 0 && this.endsWithCharacter(string)) {
                this.string.deleteCharAt(this.length() - 1);
                this.updated();
            }
        }
        return this;
    }

    public StringWrapper replaceFirst(String string) {
        return this.replaceFirst(1, string);
    }

    public StringWrapper replaceFirst(int n, String string) {
        Assert.errorParamMustBeGreaterThanOrEqualTo("quantity", n, 0L);
        Assert.errorParamMustNotBeNull("string", string);
        n = n < 0 ? 0 : (n > this.length() ? this.length() : n);
        this.replace(0, n, string);
        return this;
    }

    public StringWrapper replaceLast(String string) {
        return this.replaceLast(1, string);
    }

    public StringWrapper replaceLast(int n, String string) {
        Assert.errorParamMustNotBeNull("string", string);
        n = n < 0 ? 0 : (n > this.length() ? this.length() : n);
        this.replace(this.length() - n, this.length(), string);
        return this;
    }

    public StringWrapper deleteFirst() {
        this.deleteFirst(1, true);
        return this;
    }

    public StringWrapper deleteFirst(boolean bl) {
        this.deleteFirst(1, bl);
        return this;
    }

    public StringWrapper deleteFirst(int n) {
        this.deleteFirst(n, true);
        return this;
    }

    public StringWrapper deleteFirst(int n, boolean bl) {
        Assert.errorParamMustBeGreaterThanOrEqualTo("quantity", n, 0L);
        if (bl) {
            this.replaceFirst(n, "");
        }
        return this;
    }

    public StringWrapper deleteFirst(String string) {
        return this.deleteFirst(string, true);
    }

    public StringWrapper deleteFirst(String string, boolean bl) {
        Assert.errorParamMustNotBeNull("substring", string);
        if (bl && string.length() > 0 && this.startsWith(string)) {
            this.deleteFirst(string.length());
        }
        return this;
    }

    public StringWrapper deleteLast() {
        this.deleteLast(1, true);
        return this;
    }

    public StringWrapper deleteLast(boolean bl) {
        this.deleteLast(1, bl);
        return this;
    }

    public StringWrapper deleteLast(int n) {
        Assert.errorParamMustBeGreaterThanOrEqualTo("quantity", n, 0L);
        this.replaceLast(n, "");
        return this;
    }

    public StringWrapper deleteLast(int n, boolean bl) {
        Assert.errorParamMustBeGreaterThanOrEqualTo("quantity", n, 0L);
        if (bl) {
            this.replaceLast(n, "");
        }
        return this;
    }

    public StringWrapper deleteLast(String string) {
        return this.deleteLast(string, true);
    }

    public StringWrapper deleteLast(String string, boolean bl) {
        Assert.errorParamMustNotBeNull("substring", string);
        if (bl && string.length() > 0 && this.endsWith(string)) {
            this.deleteLast(string.length());
        }
        return this;
    }

    public StringWrapper deleteBefore(String string, boolean bl) {
        this.deleteBefore(string, 0, bl);
        return this;
    }

    public StringWrapper deleteBefore(String string, int n, boolean bl) {
        this.before(string, n, bl, true);
        return this;
    }

    public StringWrapper deleteTo(String string) {
        this.deleteTo(string, 0);
        return this;
    }

    public StringWrapper deleteTo(String string, int n) {
        this.to(string, n, true);
        return this;
    }

    public StringWrapper deleteFrom(String string) {
        this.deleteFrom(string, 0, false);
        return this;
    }

    public StringWrapper deleteFrom(String string, boolean bl) {
        this.deleteFrom(string, 0, bl);
        return this;
    }

    public StringWrapper deleteFrom(String string, int n, boolean bl) {
        this.from(string, n, bl, true);
        return this;
    }

    public StringWrapper deleteAfter(String string) {
        this.deleteAfter(string, 0);
        return this;
    }

    public StringWrapper deleteAfter(String string, int n) {
        this.after(string, n, true);
        return this;
    }

    public StringWrapper truncateRight(int n) {
        if (n >= 0 && n < this.length()) {
            this.deleteLast(this.length() - n);
        }
        return this;
    }

    public StringWrapper truncateLeft(int n) {
        if (n >= 0 && n < this.length()) {
            this.deleteFirst(this.length() - n);
        }
        return this;
    }

    public StringWrapper reverseByDelimiter(String string) {
        NullFreeMutableList<String> nullFreeMutableList = null;
        StringBuilder stringBuilder = null;
        Assert.errorParamMustNotBeEmpty("delimiter", string);
        if (this.length() > string.length() && this.contains(string)) {
            nullFreeMutableList = this.split(string, true, true, true);
            nullFreeMutableList.reverse();
            stringBuilder = new StringBuilder();
            for (String string2 : nullFreeMutableList) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(string2);
            }
            this.string = stringBuilder;
            this.updated();
        }
        return this;
    }

    public StringWrapper pad(int n, String string, boolean bl) {
        Assert.errorParamMustNotBeEmpty("paddingChar", string);
        while (this.length() < n) {
            if (bl) {
                this.string.append(string);
            } else {
                this.string.insert(0, string);
            }
            this.updated();
        }
        return this;
    }

    public StringWrapper firstCharacterToLowerCase() {
        this.replace(0, 1, this.substring(0, 1).toLowerCase());
        return this;
    }

    public StringWrapper firstCharacterToUpperCase() {
        this.replace(0, 1, this.substring(0, 1).toUpperCase());
        return this;
    }

    public StringWrapper sqlEscape() {
        this.replaceAll("'", "''");
        return this;
    }

    public StringWrapper jsEscape() {
        this.replaceAll("'", "\\'");
        return this;
    }

    public StringWrapper unescapeHtml() {
        this.string = new StringBuilder(StringEscapeUtils.unescapeHtml((String)this.toString()));
        this.updated();
        return this;
    }

    public StringWrapper surround(String string) {
        return this.surround(string, false);
    }

    public StringWrapper surround(String string, boolean bl) {
        Assert.errorParamMustNotBeNull("substring", string);
        if (!(string.length() <= 0 || bl && this.surrounded(string))) {
            this.string.insert(0, string).append(string);
            this.updated();
        }
        return this;
    }

    public StringWrapper repeat(int n) {
        return this.repeat(n, "");
    }

    public StringWrapper repeat(int n, String string) {
        String string2 = null;
        Assert.errorParamMustNotBeNull("delimiter", string);
        if (n > 0) {
            for (int i = 1; i <= n; ++i) {
                string2 = this.toString();
                this.string.append(string);
                this.string.append(string2);
            }
            this.updated();
        }
        return this;
    }

    public StringWrapper repeatOriginal(int n) {
        return this.repeatOriginal(n, "");
    }

    public StringWrapper repeatOriginal(int n, String string) {
        String string2 = null;
        Assert.errorParamMustNotBeNull("delimiter", string);
        if (n > 0) {
            string2 = this.toString();
            for (int i = 1; i <= n; ++i) {
                this.string.append(string);
                this.string.append(string2);
            }
            this.updated();
        }
        return this;
    }

    public StringIterator iterator() {
        return this.iterator(0, this.length());
    }

    public StringIterator iterator(int n) {
        return this.iterator(n, this.length());
    }

    public StringIterator iterator(int n, int n2) {
        return new StringIterator(this, n, n2);
    }

    public String getFirstCharacter() {
        String string = null;
        int n = 0;
        n = this.indexOfNonWhiteSpace();
        if (n >= 0) {
            string = this.getFirst(n + 1);
        }
        return string;
    }

    public String getFirstWord() {
        String string = null;
        StringWrapper stringWrapper = null;
        boolean bl = false;
        stringWrapper = new StringWrapper();
        for (String string2 : this) {
            if (string2.trim().length() == 0) {
                if (bl) {
                    break;
                }
            } else {
                bl = true;
            }
            stringWrapper.append(string2);
        }
        if (bl) {
            string = stringWrapper.toString();
        }
        return string;
    }

    public NullFreeMutableList<String> getPlainWords() {
        NullFreeMutableList<String> nullFreeMutableList = null;
        Words words = null;
        words = this.getWords();
        nullFreeMutableList = new NullFreeMutableList<String>(words.getCollection().size());
        for (Word word : words) {
            nullFreeMutableList.add(word.toString());
        }
        return nullFreeMutableList;
    }

    public Words getWords() {
        Words words = null;
        words = new Words(this);
        return words;
    }

    public StringWrapper deleteWord(String string, boolean bl, boolean bl2) {
        Word word = null;
        word = this.getWords().getWord(string);
        if (word != null) {
            this.delete(word.getStartIndex(bl), word.getEndIndex(bl2));
        }
        return this;
    }

    public StringWrapper spawn() {
        StringWrapper stringWrapper = null;
        stringWrapper = new StringWrapper(this);
        return stringWrapper;
    }

    protected void updated() {
    }

    private void assertInBounds(int n, boolean bl) {
        if (!this.inBounds(n, bl)) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static class Word {
        private String word;
        private int index;
        private String leadingWhiteSpace;
        private String trailingWhiteSpace;

        private Word(String string, int n, String string2, String string3) {
            this.word = string;
            this.index = n;
            this.leadingWhiteSpace = string2;
            this.trailingWhiteSpace = string3;
        }

        public String getText(boolean bl, boolean bl2) {
            return (bl ? this.leadingWhiteSpace : "") + this.word + (bl2 ? this.trailingWhiteSpace : "");
        }

        public int getStartIndex() {
            return this.getStartIndex(false);
        }

        public int getStartIndex(boolean bl) {
            return bl ? this.index - this.leadingWhiteSpace.length() : this.index;
        }

        public int getEndIndex() {
            return this.getEndIndex(false);
        }

        public int getEndIndex(boolean bl) {
            int n = 0;
            n = this.index + this.word.length();
            if (bl) {
                n += this.trailingWhiteSpace.length();
            }
            return n;
        }

        public String getLeadingWhiteSpace() {
            return this.leadingWhiteSpace;
        }

        public String getTrailingWhiteSpace() {
            return this.trailingWhiteSpace;
        }

        public boolean hasLeadingWhiteSpace() {
            return this.leadingWhiteSpace.length() > 0;
        }

        public boolean hasTrailingWhiteSpace() {
            return this.trailingWhiteSpace.length() > 0;
        }

        public boolean equals(Object object) {
            return object == null ? false : this.toString().equals(object.toString());
        }

        public String toString() {
            return this.word;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Words
    implements Iterable<Word> {
        private NullFreeMutableList<Word> words = new NullFreeMutableList();

        public Words(StringWrapper stringWrapper) {
            this(stringWrapper.toString());
        }

        public Words(String string) {
            Assert.errorParamMustNotBeNull("string", string);
            if (string.trim().length() > 0) {
                this.load(string);
            }
        }

        private void load(String string) {
            StringWrapper stringWrapper = null;
            StringWrapper stringWrapper2 = null;
            StringWrapper stringWrapper3 = null;
            StringWrapper stringWrapper4 = null;
            boolean bl = false;
            String string2 = null;
            boolean bl2 = false;
            StringContext stringContext = null;
            int n = 0;
            stringWrapper = new StringWrapper(string);
            if (!stringWrapper.isEmpty() && !stringWrapper.isWhiteSpace()) {
                stringWrapper2 = new StringWrapper();
                stringWrapper3 = new StringWrapper();
                stringWrapper4 = new StringWrapper();
                int n2 = stringWrapper.length();
                for (int i = 0; i < n2; ++i) {
                    bl = false;
                    string2 = string.substring(i, i + 1);
                    boolean bl3 = bl2 = string2.trim().length() == 0;
                    if (i == 0) {
                        if (bl2) {
                            stringContext = StringContext.LEADING_WHITE_SPACE;
                            stringWrapper3.append(string2);
                        } else {
                            stringContext = StringContext.WORD;
                            stringWrapper2.append(string2);
                        }
                    } else if (bl2) {
                        if (stringContext.isWord()) {
                            stringContext = StringContext.TRAILING_WHITE_SPACE;
                            stringWrapper4.append(string2);
                        } else if (stringContext.isTrailingWhiteSpace()) {
                            stringWrapper4.append(string2);
                        } else if (stringContext.isLeadingWhiteSpace()) {
                            stringWrapper3.append(string2);
                        }
                    } else if (stringContext.isTrailingWhiteSpace()) {
                        n = i - stringWrapper4.length() - stringWrapper2.length();
                        this.words.add(new Word(stringWrapper2.toString(), n, stringWrapper3.toString(), stringWrapper4.toString()));
                        bl = true;
                        stringWrapper3.replaceContent(stringWrapper4);
                        stringWrapper2.clear();
                        stringWrapper4.clear();
                        stringContext = StringContext.WORD;
                        stringWrapper2.append(string2);
                    } else if (stringContext.isLeadingWhiteSpace()) {
                        stringContext = StringContext.WORD;
                        stringWrapper2.append(string2);
                    } else if (stringContext.isWord()) {
                        stringWrapper2.append(string2);
                    }
                    if (i != n2 - 1 || bl) continue;
                    n = i + 1 - stringWrapper4.length() - stringWrapper2.length();
                    this.words.add(new Word(stringWrapper2.toString(), n, stringWrapper3.toString(), stringWrapper4.toString()));
                }
            }
        }

        public boolean contains(String string) {
            return this.getPlainWords().contains(string);
        }

        public Word getWord(String string) {
            return this.getWord(string, 0);
        }

        public Word getWord(String string, int n) {
            Word word = null;
            NullFreeMutableList<String> nullFreeMutableList = null;
            int n2 = 0;
            int n3 = 0;
            nullFreeMutableList = this.getPlainWords();
            while ((n2 = nullFreeMutableList.indexOf(string, n2)) >= 0) {
                if (++n3 > n) {
                    word = (Word)this.words.get(n2);
                    break;
                }
                ++n2;
            }
            return word;
        }

        public Word getWordFromLast(String string) {
            return this.getWordFromLast(string, 0);
        }

        public Word getWordFromLast(String string, int n) {
            Word word = null;
            NullFreeMutableList<String> nullFreeMutableList = null;
            int n2 = 0;
            nullFreeMutableList = this.getPlainWords();
            for (int i = 0; i < nullFreeMutableList.size(); ++i) {
                if (!((String)nullFreeMutableList.getFromLast(i)).equals(string) || ++n2 <= n) continue;
                word = (Word)this.words.getFromLast(i);
                break;
            }
            return word;
        }

        public Word getMinWord(String ... stringArray) {
            Word word = null;
            Word word2 = null;
            if (stringArray != null && stringArray.length > 0) {
                for (String string : stringArray) {
                    word2 = this.getWord(string);
                    if (word2 == null) continue;
                    if (word == null) {
                        word = word2;
                        continue;
                    }
                    if (word2.getStartIndex() >= word.getStartIndex()) continue;
                    word = word2;
                }
            }
            return word;
        }

        public Word getMaxWord(String ... stringArray) {
            Word word = null;
            Word word2 = null;
            if (stringArray != null && stringArray.length > 0) {
                for (String string : stringArray) {
                    word2 = this.getWordFromLast(string);
                    if (word2 == null) continue;
                    if (word == null) {
                        word = word2;
                        continue;
                    }
                    if (word2.getStartIndex() <= word.getStartIndex()) continue;
                    word = word2;
                }
            }
            return word;
        }

        public NullFreeMutableList<String> getPlainWords() {
            NullFreeMutableList<String> nullFreeMutableList = null;
            nullFreeMutableList = new NullFreeMutableList<String>(this.words.size());
            for (Word word : this.words) {
                nullFreeMutableList.add(word.toString());
            }
            return nullFreeMutableList;
        }

        public NullFreeMutableList<Word> getCollection() {
            return new NullFreeMutableList<Word>((Collection<Word>)this.words);
        }

        @Override
        public Iterator<Word> iterator() {
            return new NullFreeMutableList<Word>((Collection<Word>)this.words).iterator();
        }

        public int size() {
            return this.words.size();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum StringContext {
            WORD,
            LEADING_WHITE_SPACE,
            TRAILING_WHITE_SPACE;


            public boolean isWord() {
                return this == WORD;
            }

            public boolean isLeadingWhiteSpace() {
                return this == LEADING_WHITE_SPACE;
            }

            public boolean isTrailingWhiteSpace() {
                return this == TRAILING_WHITE_SPACE;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class OperationResult {
        private boolean changed;
        private int count;
        private String removed;
        private NullFreeMutableList<String> removeds;

        private OperationResult() {
        }

        public boolean changed() {
            return this.changed;
        }

        public int getCount() {
            return this.count;
        }

        public String getRemoved() {
            return this.removed;
        }

        public NullFreeMutableList<String> getRemoveds() {
            return this.removeds;
        }
    }
}

