/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.util;

import com.jronimo.collections.NullFreeMutableList;
import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.text.ResourceText;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import com.jronimo.util.StringWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameFormat {
    private static final Logger logger = Logger.getLogger(NameFormat.class);
    private Words words;

    public NameFormat(String string) {
        this.init(string, null, false);
    }

    public NameFormat(String string, Format format) {
        Assert.errorParam(format == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "format"));
        this.init(string, format, false);
    }

    public NameFormat(String string, boolean bl) {
        this.init(string, null, bl);
    }

    public NameFormat(String string, Format format, boolean bl) {
        Assert.errorParam(format == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "format"));
        this.init(string, format, bl);
    }

    private void init(String string, Format format, boolean bl) {
        if (string == null) {
            string = "";
        }
        this.words = new Words(string, format, bl);
    }

    public static String getAllowables() {
        return ResourceText.getText((Object)ResourceTextIdentifiers.DIGITS) + ResourceText.getText((Object)ResourceTextIdentifiers.ALPHABET_LOWER_CASE) + ResourceText.getText((Object)ResourceTextIdentifiers.ALPHABET_UPPER_CASE) + " -_";
    }

    public Format getFormat() {
        return this.words.getFormat();
    }

    public String getCamelCase() {
        return this.words.getCamelCase();
    }

    public String getHungarian() {
        return this.words.getHungarian();
    }

    public String getUpperCase() {
        return this.words.getUpperCase();
    }

    public String getXmlNotation() {
        return this.words.getXmlNotation();
    }

    public String getText() {
        return this.words.getText();
    }

    public int getWordCount() {
        return this.words.getWordCount();
    }

    public List<String> getWords() {
        return CollectionUtils.collectionToList(this.words.getWords());
    }

    public NameFormat getPlural() {
        NameFormat nameFormat = null;
        StringWrapper stringWrapper = null;
        stringWrapper = new StringWrapper(this.getCamelCase());
        nameFormat = !stringWrapper.endsWithLowerCaseLetter() ? new NameFormat(stringWrapper.append("s").toString()) : (stringWrapper.endsWith("s") ? new NameFormat(stringWrapper.append("es").toString()) : (stringWrapper.endsWith("y") ? new NameFormat(stringWrapper.deleteLast().append("ies").toString()) : new NameFormat(stringWrapper.append("s").toString())));
        return nameFormat;
    }

    public String toString() {
        StringBuilder stringBuilder = null;
        stringBuilder = new StringBuilder();
        stringBuilder.append("\ncamelCase: " + this.getCamelCase());
        stringBuilder.append("\nhungarian: " + this.getHungarian());
        stringBuilder.append("\nupperCase: " + this.getUpperCase());
        stringBuilder.append("\nxmlNotation: " + this.getXmlNotation());
        stringBuilder.append("\ntext: " + this.getText());
        return stringBuilder.toString();
    }

    private static boolean isTextFormat(StringWrapper stringWrapper, boolean bl) {
        return NameFormat.isRecognizedFormat(stringWrapper, Separator.SPACE, bl);
    }

    private static boolean isUpperCaseFormat(StringWrapper stringWrapper, boolean bl) {
        return NameFormat.isRecognizedFormat(stringWrapper, Separator.UNDERSCORE, bl);
    }

    private static boolean isXmlNotation(StringWrapper stringWrapper, boolean bl) {
        return NameFormat.isRecognizedFormat(stringWrapper, Separator.HYPHEN, bl);
    }

    private static boolean isRecognizedFormat(StringWrapper stringWrapper, Separator separator, boolean bl) {
        boolean bl2;
        block25: {
            StringWrapper stringWrapper2;
            NullFreeMutableList<String> nullFreeMutableList;
            boolean bl3;
            boolean bl4;
            boolean bl5;
            block23: {
                block24: {
                    bl2 = true;
                    bl5 = false;
                    bl4 = false;
                    bl3 = false;
                    nullFreeMutableList = null;
                    stringWrapper2 = null;
                    switch (separator) {
                        case SPACE: {
                            bl3 = true;
                            break;
                        }
                        case UNDERSCORE: {
                            bl5 = true;
                            break;
                        }
                        case HYPHEN: {
                            bl4 = true;
                        }
                    }
                    if (!stringWrapper.contains(Separator.SPACE.toString())) break block23;
                    if (!separator.isSpace()) break block24;
                    if (bl) break block25;
                    bl2 = true;
                    break block25;
                }
                bl2 = false;
                break block25;
            }
            if (separator.isSpace() && !stringWrapper.contains(Separator.SPACE.toString())) {
                bl2 = false;
            } else if (separator.isUnderscore() && !stringWrapper.contains(Separator.UNDERSCORE.toString())) {
                bl2 = stringWrapper.isAllUpperCase() ? !bl : false;
            } else if (separator.isHyphen() && !stringWrapper.contains(Separator.HYPHEN.toString())) {
                bl2 = false;
            } else {
                nullFreeMutableList = stringWrapper.split(separator.toString(), true, true, true);
                for (String string : nullFreeMutableList) {
                    stringWrapper2 = new StringWrapper(string);
                    if (stringWrapper2.isEmpty()) {
                        bl2 = false;
                    } else if (stringWrapper2.startsWith(Separator.getSeparators()) || stringWrapper2.endsWithCharacter(Separator.getSeparators())) {
                        bl2 = false;
                    } else if (bl5 && !stringWrapper2.isAllUpperCase()) {
                        bl2 = false;
                    } else if (bl4 && !stringWrapper2.isAllLowerCase()) {
                        bl2 = false;
                    } else if (bl3) {
                        if (stringWrapper2.length() == 1) {
                            bl2 = stringWrapper2.isAllUpperCase();
                        } else {
                            boolean bl6 = bl2 = stringWrapper2.startsWithUpperCaseLetter() && stringWrapper2.startsWithLowerCaseLetter();
                        }
                    }
                    if (bl2) continue;
                    break;
                }
            }
        }
        return bl2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FinalWord {
        private Format format;
        private boolean isSpecifiedFormat;
        private boolean isMessy;
        private boolean isFirstWord;
        private List<WordCharacter> characters;
        private String camelCase;
        private String hungarian;
        private String upperCase;
        private String xmlNotation;
        private String text;

        private FinalWord(List<WordCharacter> list, Format format, boolean bl, boolean bl2) {
            int n = 0;
            boolean bl3 = false;
            this.format = format;
            this.isSpecifiedFormat = bl;
            this.isMessy = bl2;
            this.characters = new ArrayList<WordCharacter>(8);
            for (WordCharacter wordCharacter : list) {
                if (++n == 1) {
                    boolean bl4 = this.isFirstWord = !wordCharacter.hasPreviousCharacter();
                }
                if (bl3) {
                    if (wordCharacter.isWordStart()) break;
                    if (wordCharacter.isSeparator()) continue;
                    this.characters.add(wordCharacter);
                    continue;
                }
                if (!wordCharacter.isWordStart()) continue;
                this.characters.add(wordCharacter);
                bl3 = true;
            }
            if (n < list.size()) {
                --n;
            }
            for (int i = 1; i <= n; ++i) {
                list.remove(0);
            }
        }

        public String getCamelCase(boolean bl) {
            String string = null;
            StringBuilder stringBuilder = null;
            int n = 0;
            if (bl) {
                string = this.camelCase;
            }
            if (string == null) {
                stringBuilder = new StringBuilder();
                for (WordCharacter wordCharacter : this.characters) {
                    if (++n == 1 && bl && wordCharacter.hasPreviousCharacter() && wordCharacter.getPreviousCharacter().isSeparator()) {
                        stringBuilder.append((Object)wordCharacter.getPreviousCharacter().getSeparator());
                    }
                    if (this.isMessy) {
                        if (n == 1) {
                            stringBuilder.append(wordCharacter.toUpperCase());
                            continue;
                        }
                        stringBuilder.append(wordCharacter.toLowerCase());
                        continue;
                    }
                    if (this.format.isCamelCase() && this.isSpecifiedFormat) {
                        stringBuilder.append(wordCharacter);
                        continue;
                    }
                    if (this.format.isHungarian() && this.isSpecifiedFormat) {
                        stringBuilder.append(this.isFirstWord ? wordCharacter.toUpperCase() : wordCharacter);
                        continue;
                    }
                    if (this.format.isText() || this.format.isXmlNotation()) {
                        if (n == 1) {
                            stringBuilder.append(wordCharacter.toUpperCase());
                            continue;
                        }
                        stringBuilder.append(wordCharacter);
                        continue;
                    }
                    if (this.isMessy) {
                        if (n == 1) {
                            stringBuilder.append(wordCharacter.toUpperCase());
                            continue;
                        }
                        stringBuilder.append(wordCharacter.toLowerCase());
                        continue;
                    }
                    if (this.format.isCamelCase()) {
                        if (n == 1) {
                            stringBuilder.append(this.isSpecifiedFormat ? wordCharacter : wordCharacter.toUpperCase());
                            continue;
                        }
                        stringBuilder.append(this.isSpecifiedFormat ? wordCharacter : wordCharacter.toLowerCase());
                        continue;
                    }
                    if (this.format.isHungarian()) {
                        if (n == 1) {
                            stringBuilder.append(wordCharacter.toUpperCase());
                            continue;
                        }
                        stringBuilder.append(this.isSpecifiedFormat ? wordCharacter : wordCharacter.toLowerCase());
                        continue;
                    }
                    if (n == 1) {
                        stringBuilder.append(wordCharacter.toUpperCase());
                        continue;
                    }
                    stringBuilder.append(wordCharacter.toLowerCase());
                }
                string = stringBuilder.toString();
                if (bl) {
                    this.camelCase = string;
                }
            }
            return string;
        }

        public String getHungarian(boolean bl) {
            String string = null;
            if (bl) {
                string = this.hungarian;
            }
            if (string == null) {
                string = this.getCamelCase(bl);
                if (this.isFirstWord) {
                    string = string.toLowerCase();
                }
                if (bl) {
                    this.hungarian = string;
                }
            }
            return string;
        }

        public String getUpperCase(boolean bl) {
            String string = null;
            StringBuilder stringBuilder = null;
            int n = 0;
            if (bl) {
                string = this.upperCase;
            }
            if (string == null) {
                stringBuilder = new StringBuilder();
                for (WordCharacter wordCharacter : this.characters) {
                    ++n;
                    if (bl) {
                        if (wordCharacter.hasPreviousCharacter() && wordCharacter.getPreviousCharacter().isSeparator() && wordCharacter.getPreviousCharacter().getSeparator() != Separator.UNDERSCORE) {
                            stringBuilder.append(wordCharacter.getPreviousCharacter().toString());
                        } else if (n == 1 && !this.isFirstWord) {
                            stringBuilder.append((Object)Separator.UNDERSCORE);
                        }
                    }
                    if (this.isMessy) {
                        stringBuilder.append(wordCharacter.toUpperCase());
                        continue;
                    }
                    if (this.format.isUpperCase() && this.isSpecifiedFormat) {
                        stringBuilder.append(wordCharacter);
                        continue;
                    }
                    stringBuilder.append(wordCharacter.toUpperCase());
                }
                string = stringBuilder.toString();
                if (bl) {
                    this.upperCase = string;
                }
            }
            return string;
        }

        public String getXmlNotation(boolean bl) {
            String string = null;
            StringBuilder stringBuilder = null;
            int n = 0;
            if (bl) {
                string = this.xmlNotation;
            }
            if (string == null) {
                stringBuilder = new StringBuilder();
                for (WordCharacter wordCharacter : this.characters) {
                    ++n;
                    if (bl) {
                        if (wordCharacter.hasPreviousCharacter() && wordCharacter.getPreviousCharacter().isSeparator() && wordCharacter.getPreviousCharacter().getSeparator() != Separator.HYPHEN) {
                            stringBuilder.append(wordCharacter.getPreviousCharacter().toString());
                        } else if (n == 1 && !this.isFirstWord) {
                            stringBuilder.append((Object)Separator.HYPHEN);
                        }
                    }
                    if (this.isMessy) {
                        stringBuilder.append(wordCharacter.toLowerCase());
                        continue;
                    }
                    if (this.format.isXmlNotation() && this.isSpecifiedFormat) {
                        stringBuilder.append(wordCharacter);
                        continue;
                    }
                    stringBuilder.append(wordCharacter.toLowerCase());
                }
                string = stringBuilder.toString();
                if (bl) {
                    this.xmlNotation = string;
                }
            }
            return string;
        }

        public String getText(boolean bl) {
            String string = null;
            StringBuilder stringBuilder = null;
            int n = 0;
            if (bl) {
                string = this.text;
            }
            if (string == null) {
                stringBuilder = new StringBuilder();
                for (WordCharacter wordCharacter : this.characters) {
                    ++n;
                    if (bl) {
                        if (wordCharacter.hasPreviousCharacter() && wordCharacter.getPreviousCharacter().isSeparator() && wordCharacter.getPreviousCharacter().getSeparator() != Separator.SPACE) {
                            stringBuilder.append(wordCharacter.getPreviousCharacter().toString());
                        } else if (n == 1 && !this.isFirstWord) {
                            stringBuilder.append((Object)Separator.SPACE);
                        }
                    }
                    if (this.isMessy) {
                        if (n == 1) {
                            stringBuilder.append(wordCharacter.toUpperCase());
                            continue;
                        }
                        stringBuilder.append(wordCharacter.toLowerCase());
                        continue;
                    }
                    if ((this.format.isText() || this.format.isCamelCase()) && this.isSpecifiedFormat) {
                        stringBuilder.append(wordCharacter);
                        continue;
                    }
                    if (this.format.isHungarian() && this.isSpecifiedFormat) {
                        if (n == 1 && this.isFirstWord) {
                            stringBuilder.append(wordCharacter.toUpperCase());
                            continue;
                        }
                        stringBuilder.append(wordCharacter);
                        continue;
                    }
                    if (n == 1) {
                        stringBuilder.append(wordCharacter.toUpperCase());
                        continue;
                    }
                    stringBuilder.append(wordCharacter.toLowerCase());
                }
                string = stringBuilder.toString();
                if (bl) {
                    this.text = string;
                }
            }
            return string;
        }

        public String toString() {
            String string = null;
            if (this.format.isCamelCase()) {
                string = this.getCamelCase(false);
            } else if (this.format.isHungarian()) {
                string = this.getHungarian(false);
            } else if (this.format.isUpperCase()) {
                string = this.getUpperCase(false);
            } else if (this.format.isXmlNotation()) {
                string = this.getXmlNotation(false);
            } else if (this.format.isText()) {
                string = this.getText(false);
            }
            return string;
        }
    }

    private static class WordCharacter {
        private static final String separators = " -_";
        private WordCharacter previousCharacter;
        private String string;
        private WordCharacter nextCharacter;
        private boolean isSeparator;
        private boolean isLetter;
        private boolean isDigit;
        private boolean isUpperCase;
        private boolean isLowerCase;
        private boolean isWordStart;

        private WordCharacter(String string, boolean bl) {
            this(null, string, null, null, bl);
        }

        private WordCharacter(WordCharacter wordCharacter, String string, String string2, Boolean bl, boolean bl2) {
            StringWrapper stringWrapper = null;
            Assert.errorParamMustNotBeNull("currentCharacter", string);
            this.previousCharacter = wordCharacter;
            this.string = string;
            if (bl != null && bl.booleanValue()) {
                this.isWordStart = true;
            }
            if (string2 != null) {
                this.nextCharacter = new WordCharacter(string2, bl2);
            }
            if (separators.indexOf(string) >= 0) {
                this.isSeparator = true;
            } else {
                stringWrapper = new StringWrapper(string);
                if (stringWrapper.containsOnlyLetters()) {
                    this.isLetter = true;
                    this.isUpperCase = stringWrapper.containsOnlyUpperCaseLetters();
                    this.isLowerCase = !this.isUpperCase;
                }
                boolean bl3 = this.isDigit = !this.isLetter;
                if (wordCharacter == null || wordCharacter.isSeparator()) {
                    this.isWordStart = true;
                } else if (this.isDigit && wordCharacter.isLetter()) {
                    this.isWordStart = true;
                } else if (this.isUpperCase) {
                    if (wordCharacter.isDigit()) {
                        this.isWordStart = true;
                    } else if (wordCharacter.isLowerCase()) {
                        this.isWordStart = true;
                    } else if (wordCharacter.isUpperCase() && this.nextCharacter.isLowerCase()) {
                        this.isWordStart = true;
                    }
                } else if (this.isLowerCase && wordCharacter.isDigit()) {
                    this.isWordStart = true;
                }
            }
        }

        public boolean hasPreviousCharacter() {
            return this.previousCharacter != null;
        }

        public WordCharacter getPreviousCharacter() {
            return this.previousCharacter;
        }

        public boolean hasNextCharacter() {
            return this.nextCharacter != null;
        }

        public WordCharacter getNextCharacter() {
            return this.nextCharacter;
        }

        public boolean isLetter() {
            return this.isLetter;
        }

        public boolean isDigit() {
            return this.isDigit;
        }

        public boolean isUpperCase() {
            return this.isUpperCase;
        }

        public boolean isLowerCase() {
            return this.isLowerCase;
        }

        public boolean isWordStart() {
            return this.isWordStart;
        }

        public boolean isSeparator() {
            return this.isSeparator;
        }

        public String toUpperCase() {
            return this.string.toUpperCase();
        }

        public String toLowerCase() {
            return this.string.toLowerCase();
        }

        public Separator getSeparator() {
            return this.isSeparator ? Separator.get(this.string) : null;
        }

        public String toString() {
            return this.string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Words {
        private String originalString;
        private Format specifiedFormat;
        private boolean isMessy;
        private String cleanString;
        private Format format;
        private String camelCase;
        private String hungarian;
        private String upperCase;
        private String xmlNotation;
        private String text;
        private List<FinalWord> words;
        private List<String> wordsAsStrings;

        private Words(String string, Format format, boolean bl) {
            this.originalString = string;
            this.specifiedFormat = format;
            this.isMessy = bl;
            this.cleanString();
            this.loadWords();
        }

        public String getOriginalString() {
            return this.originalString;
        }

        public String getCleanString() {
            return this.cleanString;
        }

        public Format getFormat() {
            return this.format;
        }

        public synchronized String getCamelCase() {
            String string = null;
            StringBuilder stringBuilder = null;
            string = this.camelCase;
            if (string == null) {
                stringBuilder = new StringBuilder();
                for (FinalWord finalWord : this.words) {
                    stringBuilder.append(finalWord.getCamelCase(true));
                }
                this.camelCase = string = stringBuilder.toString();
            }
            return string;
        }

        public synchronized String getHungarian() {
            String string = null;
            StringBuilder stringBuilder = null;
            string = this.hungarian;
            if (string == null) {
                stringBuilder = new StringBuilder();
                for (FinalWord finalWord : this.words) {
                    stringBuilder.append(finalWord.getHungarian(true));
                }
                this.hungarian = string = stringBuilder.toString();
            }
            return string;
        }

        public synchronized String getUpperCase() {
            String string = null;
            StringBuilder stringBuilder = null;
            string = this.upperCase;
            if (string == null) {
                stringBuilder = new StringBuilder();
                for (FinalWord finalWord : this.words) {
                    stringBuilder.append(finalWord.getUpperCase(true));
                }
                this.upperCase = string = stringBuilder.toString();
            }
            return string;
        }

        public synchronized String getXmlNotation() {
            String string = null;
            StringBuilder stringBuilder = null;
            string = this.xmlNotation;
            if (string == null) {
                stringBuilder = new StringBuilder();
                for (FinalWord finalWord : this.words) {
                    stringBuilder.append(finalWord.getXmlNotation(true));
                }
                this.xmlNotation = string = stringBuilder.toString();
            }
            return string;
        }

        public synchronized String getText() {
            String string = null;
            StringBuilder stringBuilder = null;
            string = this.text;
            if (string == null) {
                stringBuilder = new StringBuilder();
                for (FinalWord finalWord : this.words) {
                    stringBuilder.append(finalWord.getText(true));
                }
                this.text = string = stringBuilder.toString();
            }
            return string;
        }

        public int getWordCount() {
            return this.words.size();
        }

        public List<String> getWords() {
            List<String> list = null;
            list = this.wordsAsStrings;
            if (list == null) {
                list = new ArrayList<String>(this.words.size());
                for (FinalWord finalWord : this.words) {
                    list.add(finalWord.toString());
                }
                this.wordsAsStrings = list;
            }
            return list;
        }

        private void cleanString() {
            String string = NameFormat.getAllowables();
            StringWrapper stringWrapper = null;
            stringWrapper = new StringWrapper(this.originalString.trim());
            if (stringWrapper.isEmpty()) {
                this.cleanString = stringWrapper.toString();
                this.format = Format.CAMEL_CASE;
            } else {
                if (this.isMessy) {
                    stringWrapper.unescapeHtml();
                }
                stringWrapper.retainAllCharacters(string);
                stringWrapper.trim();
                stringWrapper.removeLeadingNonLetters();
                stringWrapper.removeTrailingCharacters(Separator.getSeparators());
                this.cleanUpSeparators(stringWrapper);
                stringWrapper.trim();
                this.determineFormat(stringWrapper);
                this.cleanString = stringWrapper.toString();
            }
        }

        private void cleanUpSeparators(StringWrapper stringWrapper) {
            Map map = null;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            map = CollectionUtils.getOrderedMap(new HashMap());
            if (!stringWrapper.isEmpty()) {
                if (this.specifiedFormat == null) {
                    if (stringWrapper.contains(Separator.SPACE.toString())) {
                        bl = true;
                    } else if (stringWrapper.isAllLowerCase()) {
                        bl3 = true;
                    } else {
                        bl2 = true;
                    }
                } else {
                    if (this.isMessy) {
                        if (!this.specifiedFormat.isText()) {
                            stringWrapper.replaceAll(Separator.SPACE.toString(), "");
                        }
                        if (!this.specifiedFormat.isUpperCase()) {
                            stringWrapper.replaceAll(Separator.UNDERSCORE.toString(), "");
                        }
                        if (!this.specifiedFormat.isXmlNotation()) {
                            stringWrapper.replaceAll(Separator.HYPHEN.toString(), "");
                        }
                    }
                    if (this.specifiedFormat.isText()) {
                        bl = true;
                    } else if (this.specifiedFormat.isXmlNotation()) {
                        bl3 = true;
                    } else {
                        bl2 = this.specifiedFormat.isUpperCase() ? true : true;
                    }
                }
                if (bl) {
                    map.put("  ", " ");
                    map.put("--", "-");
                    map.put("__", "_");
                    map.put(" -", " ");
                    map.put(" _", " ");
                    map.put("- ", " ");
                    map.put("_ ", " ");
                    map.put("-_", "_");
                    map.put("_-", "_");
                } else {
                    map.put(" ", "");
                    if (bl2) {
                        map.put("--", "-");
                        map.put("__", "_");
                        map.put("-_", "_");
                        map.put("_-", "_");
                    } else if (bl3) {
                        map.put("--", "-");
                        map.put("__", "_");
                        map.put("-_", "-");
                        map.put("_-", "-");
                    } else {
                        throw new UnexpectedErrorException();
                    }
                }
                stringWrapper.replaceAll(map);
                stringWrapper.trim();
            }
        }

        private void determineFormat(StringWrapper stringWrapper) {
            if (this.specifiedFormat == null) {
                if (stringWrapper.isEmpty()) {
                    this.format = Format.CAMEL_CASE;
                } else if (stringWrapper.length() == 1) {
                    this.format = stringWrapper.isAllUpperCase() ? Format.CAMEL_CASE : Format.HUNGARIAN;
                } else if (NameFormat.isTextFormat(stringWrapper, this.isMessy)) {
                    this.format = Format.TEXT;
                } else {
                    stringWrapper.replaceAll(Separator.SPACE.toString(), "");
                    if (NameFormat.isUpperCaseFormat(stringWrapper, this.isMessy)) {
                        this.format = Format.UPPER_CASE;
                    } else {
                        if (this.isMessy) {
                            stringWrapper.replaceAll(Separator.UNDERSCORE.toString(), "");
                        }
                        if (NameFormat.isXmlNotation(stringWrapper, this.isMessy)) {
                            this.format = Format.XML_NOTATION;
                        } else {
                            if (this.isMessy) {
                                stringWrapper.replaceAll(Separator.HYPHEN.toString(), "");
                            }
                            this.format = stringWrapper.startsWithUpperCaseLetter() ? Format.CAMEL_CASE : Format.HUNGARIAN;
                        }
                    }
                }
            } else {
                this.format = this.specifiedFormat;
            }
        }

        private void loadWords() {
            List<WordCharacter> list = null;
            int n = 0;
            if (this.words == null) {
                list = this.getWordCharacters();
                this.words = new ArrayList<FinalWord>(5);
                while (list.size() > 0) {
                    this.words.add(new FinalWord(list, this.format, ++n == 1, this.isMessy));
                }
            }
        }

        private List<WordCharacter> getWordCharacters() {
            ArrayList<WordCharacter> arrayList = null;
            String string = null;
            String string2 = null;
            boolean bl = false;
            Boolean bl2 = false;
            WordCharacter wordCharacter = null;
            WordCharacter wordCharacter2 = null;
            String string3 = null;
            if (this.format.getSeparator() != null) {
                string = this.format.getSeparator().toString();
            }
            arrayList = new ArrayList<WordCharacter>(this.cleanString.length());
            int n = this.cleanString.length();
            for (int i = 0; i < n; ++i) {
                bl2 = i == 0 || bl ? Boolean.valueOf(true) : null;
                string2 = this.cleanString.substring(i, i + 1);
                if (string2.equals(string)) {
                    bl = true;
                    continue;
                }
                bl = false;
                if (i + 1 < n) {
                    string3 = this.cleanString.substring(i + 1, i + 2);
                }
                wordCharacter2 = new WordCharacter(wordCharacter, string2, string3, bl2, this.isMessy);
                arrayList.add(wordCharacter2);
                wordCharacter = wordCharacter2;
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        CAMEL_CASE(null),
        HUNGARIAN(null),
        UPPER_CASE(Separator.UNDERSCORE),
        XML_NOTATION(Separator.HYPHEN),
        TEXT(Separator.SPACE);

        private Separator separator;

        private Format(Separator separator) {
            this.separator = separator;
        }

        public boolean hasSeparator() {
            return this.separator != null;
        }

        public Separator getSeparator() {
            return this.separator;
        }

        public boolean isCamelCase() {
            return this == CAMEL_CASE;
        }

        public boolean isHungarian() {
            return this == HUNGARIAN;
        }

        public boolean isUpperCase() {
            return this == UPPER_CASE;
        }

        public boolean isXmlNotation() {
            return this == XML_NOTATION;
        }

        public boolean isText() {
            return this == TEXT;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Separator {
        SPACE(" "),
        UNDERSCORE("_"),
        HYPHEN("-");

        private String character;

        private Separator(String string2) {
            this.character = string2;
        }

        public boolean isSpace() {
            return this == SPACE;
        }

        public boolean isUnderscore() {
            return this == UNDERSCORE;
        }

        public boolean isHyphen() {
            return this == HYPHEN;
        }

        public String toString() {
            return this.character;
        }

        public static Separator get(String string) {
            Separator separator = null;
            for (Separator separator2 : Separator.values()) {
                if (!separator2.character.equals(string)) continue;
                separator = separator2;
                break;
            }
            return separator;
        }

        public static String getSeparators() {
            return SPACE.toString() + UNDERSCORE.toString() + HYPHEN.toString();
        }
    }
}

