/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.util;

import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import com.jronimo.util.Methods;
import java.lang.reflect.Method;
import java.util.ArrayList;

public final class MethodInvoker {
    private static final Logger logger = Logger.getLogger(MethodInvoker.class);
    private Class clazz;
    private Object instance;
    private String methodName;
    private Class[] argClasses;
    private Object[] argValues;

    public MethodInvoker(Class clazz, Object object, String string, Class[] classArray, Object[] objectArray) {
        Assert.errorParam(clazz == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "clazz"));
        Assert.errorParam(string == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "methodName"));
        this.clazz = clazz;
        this.instance = object;
        this.methodName = string;
        this.argClasses = classArray;
        this.argValues = objectArray;
        this.init();
    }

    private void init() {
        Method[] methodArray = null;
        ArrayList<Method> arrayList = null;
        if (this.argClasses == null) {
            arrayList = new ArrayList<Method>(1);
            for (Method method : methodArray = this.clazz.getMethods()) {
                if (!method.getName().equals(this.methodName)) continue;
                arrayList.add(method);
            }
            Assert.errorParam(arrayList.size() == 0, new ResourceTextPointer((Object)ResourceTextIdentifiers.METHOD_NOT_FOUND, this.methodName));
            Assert.errorParam(arrayList.size() > 1, new ResourceTextPointer((Object)ResourceTextIdentifiers.MULTIPLE_METHODS_FOUND, this.methodName));
            this.argClasses = ((Method)arrayList.get(0)).getParameterTypes();
        }
        if (this.argValues == null) {
            this.argValues = new Object[0];
        }
    }

    public Object invoke() {
        return this._invoke(this.instance, this.argValues);
    }

    public Object invoke(Object object) {
        return this._invoke(object, this.argValues);
    }

    public Object invoke(Object[] objectArray) {
        return this._invoke(this.instance, objectArray);
    }

    public Object invoke(Object object, Object[] objectArray) {
        return this._invoke(object, objectArray);
    }

    private Object _invoke(Object object, Object[] objectArray) {
        return Methods.executeViaReflection(this.clazz, object, this.methodName, true, this.argClasses, objectArray);
    }

    public static class Thread
    extends java.lang.Thread {
        private MethodInvoker methodInvoker;
        private long delay;
        private boolean cancelled;

        public Thread(MethodInvoker methodInvoker) {
            this.methodInvoker = methodInvoker;
        }

        public Thread(MethodInvoker methodInvoker, long l) {
            this.methodInvoker = methodInvoker;
            this.delay = l;
        }

        public MethodInvoker getMethodInvoker() {
            return this.methodInvoker;
        }

        public long getDelay() {
            return this.delay;
        }

        public void setDelay(long l) {
            this.delay = l;
        }

        public void run() {
            if (this.delay > 0L) {
                Methods.sleep(this.delay);
            }
            if (!this.cancelled) {
                this.methodInvoker.invoke();
            }
        }

        public void cancel() {
            this.cancelled = true;
        }
    }
}

