/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.util;

import com.jronimo.collections.MutableList;
import com.jronimo.collections.MutableSet;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.util.Logger;
import com.jronimo.util.StringWrapper;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Email {
    private static final Logger logger = Logger.getLogger(Email.class);
    public static final String CONTENT_TYPE_TEXT_PLAIN = "text/plain";
    public static final String CONTENT_TYPE_TEXT_HTML = "text/html";
    private String from;
    private String subject;
    private String message;
    private String contentType;
    private final Set<String> toRecipients = new MutableSet<String>(2);
    private final Set<String> ccRecipients = new MutableSet<String>(2);
    private final Set<String> bccRecipients = new MutableSet<String>(2);
    private final List<Attachment> attachments = new MutableList<Attachment>(2);
    private int sendCount;

    public Email(String string, String string2, String string3) {
        this(string, string2, string3, CONTENT_TYPE_TEXT_PLAIN);
    }

    public Email(String string, String string2, String string3, String string4) {
        this.from = string;
        this.subject = string2;
        this.message = string3;
        this.contentType = string4;
    }

    public String getFrom() {
        return this.from;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getMessage() {
        return this.message;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Set<String> getToRecipients() {
        return this.toRecipients;
    }

    public Set<String> getCcRecipients() {
        return this.ccRecipients;
    }

    public Set<String> getBccRecipients() {
        return this.bccRecipients;
    }

    public boolean hasCcRecipients() {
        return !this.ccRecipients.isEmpty();
    }

    public boolean hasBccRecipients() {
        return !this.bccRecipients.isEmpty();
    }

    public Collection<Attachment> getAttachments() {
        return this.attachments;
    }

    public void addToRecipient(String string) {
        this.toRecipients.add(string);
    }

    public void addToRecipients(String ... stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                this.toRecipients.add(string);
            }
        }
    }

    public void addToRecipients(Collection<String> collection) {
        if (collection != null) {
            this.toRecipients.addAll(collection);
        }
    }

    public void addCcRecipient(String string) {
        this.ccRecipients.add(string);
    }

    public void addCcRecipients(String ... stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                this.ccRecipients.add(string);
            }
        }
    }

    public void addCcRecipients(Collection<String> collection) {
        if (collection != null) {
            this.ccRecipients.addAll(collection);
        }
    }

    public void addBccRecipient(String string) {
        this.bccRecipients.add(string);
    }

    public void addBccRecipients(String ... stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                this.bccRecipients.add(string);
            }
        }
    }

    public void addBccRecipients(Collection<String> collection) {
        if (collection != null) {
            this.bccRecipients.addAll(collection);
        }
    }

    public synchronized int getSendCount() {
        return this.sendCount;
    }

    public synchronized boolean isSent() {
        return this.sendCount > 0;
    }

    public synchronized void send(Session session) {
        MimeMessage mimeMessage = null;
        try {
            mimeMessage = new MimeMessage(session);
            mimeMessage.setFrom((Address)new InternetAddress(this.from));
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])Email.toInternetAddress(this.toRecipients));
            if (this.hasCcRecipients()) {
                mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])Email.toInternetAddress(this.ccRecipients));
            }
            if (this.hasBccRecipients()) {
                mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])Email.toInternetAddress(this.bccRecipients));
            }
            mimeMessage.setSubject(this.subject);
            mimeMessage.setContent((Object)this.message, this.contentType);
            Transport.send((Message)mimeMessage);
            ++this.sendCount;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new UnexpectedErrorException(exception);
        }
    }

    public void asynchSend(final Session session) {
        final Email email = this;
        new Thread(new Runnable(){

            public void run() {
                email.send(session);
            }
        }).start();
    }

    public String toString() {
        StringWrapper stringWrapper = new StringWrapper();
        stringWrapper.append("from: ");
        stringWrapper.append(this.from);
        stringWrapper.append(";");
        if (!this.toRecipients.isEmpty()) {
            stringWrapper.append("toRecipients: ");
            stringWrapper.append(((MutableSet)this.toRecipients).toString(","));
            stringWrapper.append(";");
        }
        if (!this.ccRecipients.isEmpty()) {
            stringWrapper.append("toRecipients: ");
            stringWrapper.append(((MutableSet)this.ccRecipients).toString(","));
            stringWrapper.append(";");
        }
        if (!this.bccRecipients.isEmpty()) {
            stringWrapper.append("toRecipients: ");
            stringWrapper.append(((MutableSet)this.bccRecipients).toString(","));
            stringWrapper.append(";");
        }
        stringWrapper.append("subject: ");
        stringWrapper.append(this.subject);
        stringWrapper.append(";");
        stringWrapper.append("message: ");
        stringWrapper.append(this.message);
        stringWrapper.append(";");
        return stringWrapper.toString();
    }

    public static InternetAddress[] toInternetAddress(String ... stringArray) throws AddressException {
        InternetAddress[] internetAddressArray = null;
        int n = 0;
        internetAddressArray = new InternetAddress[stringArray.length];
        for (String string : stringArray) {
            internetAddressArray[n++] = new InternetAddress(string);
        }
        return internetAddressArray;
    }

    public static InternetAddress[] toInternetAddress(Collection<String> collection) throws AddressException {
        InternetAddress[] internetAddressArray = null;
        int n = 0;
        internetAddressArray = new InternetAddress[collection.size()];
        for (String string : collection) {
            internetAddressArray[n++] = new InternetAddress(string);
        }
        return internetAddressArray;
    }

    public static class Attachment {
    }
}

