/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.util;

import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.DateUtils;
import java.util.Date;

public class DateRange {
    private Date startDate;
    private Date endDate;

    public DateRange(Date date, Date date2) {
        if (date != null) {
            this.startDate = DateUtils.createZeroTimeDate(date);
        }
        if (date2 != null) {
            this.endDate = DateUtils.createZeroTimeDate(date2);
        }
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public boolean isOrdered(boolean bl) {
        boolean bl2 = false;
        bl2 = this.before(this.endDate, this.startDate, bl);
        return bl2;
    }

    public boolean encompasses(DateRange dateRange, boolean bl, boolean bl2) {
        boolean bl3 = false;
        Assert.errorParam(dateRange == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "dateRange"));
        bl3 = this.after(this.startDate, dateRange.getStartDate(), bl) && this.before(this.endDate, dateRange.getEndDate(), bl2);
        return bl3;
    }

    public boolean isEncompassedBy(DateRange dateRange, boolean bl, boolean bl2) {
        boolean bl3 = false;
        Assert.errorParam(dateRange == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "dateRange"));
        bl3 = this.before(this.startDate, dateRange.getStartDate(), bl) && this.after(this.endDate, dateRange.getEndDate(), bl2);
        return bl3;
    }

    public boolean before(DateRange dateRange, boolean bl) {
        boolean bl2 = false;
        Assert.errorParam(dateRange == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "dateRange"));
        bl2 = this.after(this.startDate, dateRange.getEndDate(), bl);
        return bl2;
    }

    public boolean after(DateRange dateRange, boolean bl) {
        boolean bl2 = false;
        Assert.errorParam(dateRange == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "dateRange"));
        bl2 = this.before(this.endDate, dateRange.getStartDate(), bl);
        return bl2;
    }

    public boolean overlapsLeft(DateRange dateRange, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = false;
        Assert.errorParam(dateRange == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "dateRange"));
        bl4 = this.after(this.startDate, dateRange.getStartDate(), bl) && this.before(this.startDate, dateRange.getEndDate(), bl2) && this.after(this.endDate, dateRange.getEndDate(), bl3);
        return bl4;
    }

    public boolean overlapsRight(DateRange dateRange, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = false;
        Assert.errorParam(dateRange == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "dateRange"));
        bl4 = this.before(this.startDate, dateRange.getStartDate(), bl) && this.after(this.endDate, dateRange.getStartDate(), bl2) && this.before(this.endDate, dateRange.getEndDate(), bl3);
        return bl4;
    }

    public boolean isIn(Date date, boolean bl, boolean bl2) {
        boolean bl3 = true;
        if (date != null) {
            date = DateUtils.createZeroTimeDate(date);
        }
        bl3 = this.before(this.startDate, date, bl) && this.after(this.endDate, date, bl2);
        return bl3;
    }

    public int hashCode() {
        int n = 17;
        if (this.startDate == null && this.endDate == null) {
            n = String.valueOf(System.currentTimeMillis()).hashCode();
        } else {
            if (this.startDate != null) {
                n = n * 37 + this.startDate.hashCode();
            }
            if (this.endDate != null) {
                n = n * 37 + this.endDate.hashCode();
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        DateRange dateRange = null;
        if (object instanceof DateRange) {
            dateRange = (DateRange)object;
            bl = this.areEqual(this.startDate, dateRange.startDate);
            if (bl) {
                bl = this.areEqual(this.endDate, dateRange.endDate);
            }
        }
        return bl;
    }

    private boolean areEqual(Date date, Date date2) {
        boolean bl = true;
        if (date2 != null || date != null) {
            bl = date2 == null || date == null ? false : DateUtils.identical(date, date2);
        }
        return bl;
    }

    private boolean before(Date date, Date date2, boolean bl) {
        boolean bl2 = false;
        bl2 = bl ? (date == null && date2 == null ? true : (date != null && date2 != null ? !DateUtils.before(date, date2) : date2 != null)) : (date == null && date2 == null ? false : (date != null && date2 != null ? DateUtils.after(date, date2) : date2 != null));
        return bl2;
    }

    private boolean after(Date date, Date date2, boolean bl) {
        boolean bl2 = false;
        bl2 = bl ? (date == null && date2 == null ? true : (date != null && date2 != null ? !DateUtils.after(date, date2) : date2 != null)) : (date == null && date2 == null ? false : (date != null && date2 != null ? DateUtils.before(date, date2) : date2 != null));
        return bl2;
    }
}

