/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.util;

import com.jezhumble.javasysmon.CpuTimes;
import com.jezhumble.javasysmon.JavaSysMon;
import com.jezhumble.javasysmon.MemoryStats;
import com.jronimo.util.Logger;
import com.jronimo.util.Methods;

public final class ComputerResourceUsage {
    private static final ComputerResourceUsage instance = new ComputerResourceUsage();
    private static final Logger logger = Logger.getLogger(ComputerResourceUsage.class);
    private CpuTimes cpuTimes = new JavaSysMon().cpuTimes();
    private MonitorThread monitorThread = new MonitorThread(this, 10000L);
    private Byte memoryUsage;
    private Byte cpuUsage;

    private ComputerResourceUsage() {
        this.monitorThread.start();
    }

    public static ComputerResourceUsage getInstance() {
        return instance;
    }

    public void destroy() {
        try {
            this.monitorThread.finish();
        }
        catch (Exception exception) {
            logger.error(exception);
        }
    }

    public Byte getCpuUsage() {
        return this.cpuUsage;
    }

    public Byte getMemoryUsage() {
        return this.memoryUsage;
    }

    private synchronized void update(CpuTimes cpuTimes) {
        int n = 0;
        String string = null;
        n = (int)Math.floor(100.0 * ((double)(cpuTimes.getIdleMillis() - this.cpuTimes.getIdleMillis()) / (double)(cpuTimes.getTotalMillis() - this.cpuTimes.getTotalMillis())));
        this.cpuUsage = (byte)(100 - n);
        this.cpuTimes = cpuTimes;
        string = "CPU usage: " + this.cpuUsage;
        logger.info(string);
    }

    private synchronized void update(MemoryStats memoryStats) {
        String string = null;
        this.memoryUsage = (byte)Math.ceil(100.0 * ((double)(memoryStats.getTotalBytes() - memoryStats.getFreeBytes()) / (double)memoryStats.getTotalBytes()));
        string = "Memory usage: " + this.memoryUsage;
        logger.info(string);
    }

    private static final class MonitorThread
    extends Thread {
        private ComputerResourceUsage parent;
        private long delay;
        private JavaSysMon systemMonitor;
        private boolean finished;

        MonitorThread(ComputerResourceUsage computerResourceUsage, long l) {
            this.parent = computerResourceUsage;
            this.delay = l;
            this.systemMonitor = new JavaSysMon();
        }

        public void run() {
            try {
                while (!this.finished) {
                    Methods.sleep(this.delay);
                    this.parent.update(this.systemMonitor.cpuTimes());
                    this.parent.update(this.systemMonitor.physical());
                }
                this.finished = true;
            }
            catch (Throwable throwable) {
                logger.error(throwable);
            }
        }

        void finish() {
            this.finished = true;
            this.interrupt();
        }

        boolean isFinished() {
            return this.finished;
        }
    }
}

