/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.util;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.SetUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassHierarchy {
    private Class subjectClass;
    private Set<Class> classes;

    public ClassHierarchy(Class clazz) {
        this.subjectClass = clazz;
        this.classes = SetUtils.orderedSet(new HashSet());
        this.assembleClassHierarchy(clazz, this.classes);
    }

    private void assembleClassHierarchy(Class clazz, Set<Class> set) {
        set.add(clazz);
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            this.assembleClassHierarchy(clazz2, set);
        }
        if (clazz.getSuperclass() != null) {
            this.assembleClassHierarchy(clazz.getSuperclass(), set);
        }
    }

    public Class getSubjectClass() {
        return this.subjectClass;
    }

    public Set<Class> getClasses() {
        return SetUtils.orderedSet(new HashSet<Class>(this.classes));
    }

    public boolean hasClass(Class clazz) {
        return this.classes.contains(clazz);
    }
}

