/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.util;

import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Methods;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Assert {
    protected Assert() {
    }

    public static void errorParam(boolean bl, ResourceTextPointer resourceTextPointer) {
        if (bl) {
            Assert.errorParam(resourceTextPointer);
        }
    }

    public static void errorParam(ResourceTextPointer resourceTextPointer) {
        throw new IllegalArgumentException(resourceTextPointer.getText());
    }

    public static void errorParam(boolean bl, ResourceTextPointer resourceTextPointer, Class clazz) {
        if (bl) {
            throw (RuntimeException)Methods.instantiateViaReflection(clazz, String.class, resourceTextPointer.getText());
        }
    }

    public static void errorParam(boolean bl, Class clazz) {
        if (bl) {
            throw (RuntimeException)Methods.instantiateViaReflection(clazz);
        }
    }

    public static void errorParamMustNotBeNull(String string, Object object) {
        Assert.errorParam(object == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, string));
    }

    public static void errorParamMustNotBeEmpty(String string, boolean bl) {
        Assert.errorParam(bl, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_EMPTY, string));
    }

    public static void errorParamMustNotBeEmpty(String string, String string2) {
        Assert.errorParamMustNotBeNull(string, string2);
        Assert.errorParam(string2.length() == 0, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_EMPTY, string));
    }

    public static void errorParamMustNotBeEmpty(String string, Collection<?> collection) {
        Assert.errorParamMustNotBeNull(string, collection);
        Assert.errorParam(collection.isEmpty(), new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_EMPTY, string));
    }

    public static void errorParamMustNotBeEmpty(String string, Object[] objectArray) {
        Assert.errorParamMustNotBeNull(string, objectArray);
        Assert.errorParam(objectArray.length == 0, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_EMPTY, string));
    }

    public static void errorParamMustBeGreaterThanOrEqualTo(String string, long l, long l2) {
        Assert.errorParam(l < l2, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_BE_GREATER_THAN_OR_EQUAL_TO, string, l, l2));
        Assert.errorParamMustBeGreaterThanOrEqualTo(string, l, l2, l2);
    }

    public static void errorParamMustBeGreaterThanOrEqualTo(String string, long l, long l2, Object object) {
        Assert.errorParam(l < l2, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_BE_GREATER_THAN_OR_EQUAL_TO, string, l, object));
    }

    public static void errorParamMustBeLessThanOrEqualTo(String string, long l, long l2) {
        Assert.errorParam(l > l2, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_BE_LESS_THAN_OR_EQUAL_TO, string, l, l2));
        Assert.errorParamMustBeLessThanOrEqualTo(string, l, l2, l2);
    }

    public static void errorParamMustBeLessThanOrEqualTo(String string, long l, long l2, Object object) {
        Assert.errorParam(l > l2, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_BE_LESS_THAN_OR_EQUAL_TO, string, l, object));
    }

    public static void errorParamMustExistIn(String string, Object object, Collection<?> collection) {
        Assert.errorParam(!collection.contains(object), new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_EXIST_IN_COLLECTION, string));
    }

    public static void errorState(boolean bl, ResourceTextPointer resourceTextPointer) {
        if (bl) {
            throw new IllegalStateException(resourceTextPointer.getText());
        }
    }

    public static void errorStateMustNotBeNull(String string, Object object) {
        Assert.errorState(object == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, string));
    }

    public static void unexpected(boolean bl, ResourceTextPointer resourceTextPointer) {
        if (bl) {
            throw new UnexpectedErrorException(resourceTextPointer.getText());
        }
    }

    public static void unexpected(boolean bl, String string) {
        if (bl) {
            throw new UnexpectedErrorException(string);
        }
    }

    public static void notNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    public static void notEmpty(Collection<?> collection, String string) {
        Assert.errorParam(collection.isEmpty(), new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_EMPTY, string));
    }

    public static void notEmpty(Object[] objectArray, String string) {
        Assert.errorParam(objectArray.length == 0, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_EMPTY, string));
    }
}

