/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.temporal;

import com.jronimo.collections.NullFreeMutableList;
import com.jronimo.temporal.Constants;
import com.jronimo.temporal.ResourceTextIdentifiers;
import com.jronimo.temporal.StringFormat;
import com.jronimo.temporal.TemporalUtils;
import com.jronimo.temporal.ValueStruct;
import com.jronimo.text.ResourceText;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import com.jronimo.util.StringWrapperWithVoidRegions;
import java.math.BigInteger;

public final class Time
implements Comparable {
    private static final Logger logger = Logger.getLogger(Time.class);
    private byte negativeMultiplier = 1;
    private long hour;
    private byte minute;
    private byte second;
    private short millisecond;
    private long temporalValue;
    private long millisecondValue;

    public Time(String string) {
        this(new ValueStruct(string));
    }

    public Time(ValueStruct valueStruct) {
        Assert.errorParam(valueStruct == null, new ResourceTextPointer((Object)com.jronimo.text.ResourceTextIdentifiers.MUST_NOT_BE_NULL, "struct"));
        valueStruct = this.ratifyStruct(valueStruct);
        if (valueStruct.stringValue != null) {
            this.initFromStringValue(valueStruct.stringValue);
        } else if (valueStruct.temporalValue != null) {
            this.initFromTemporalValue(valueStruct.temporalValue);
        } else if (valueStruct.millisecondValue != null) {
            this.initFromMillisecondsValue(valueStruct.millisecondValue);
        } else {
            throw new IllegalArgumentException(ResourceText.getText((Object)com.jronimo.text.ResourceTextIdentifiers.INVALID_STRUCT, (Object[])new String[]{"struct"}));
        }
    }

    private ValueStruct ratifyStruct(ValueStruct valueStruct) {
        ValueStruct valueStruct2 = null;
        StringWrapperWithVoidRegions stringWrapperWithVoidRegions = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        valueStruct2 = valueStruct.clone();
        if (valueStruct2.stringValue != null) {
            stringWrapperWithVoidRegions = new StringWrapperWithVoidRegions(valueStruct2.stringValue);
            if (stringWrapperWithVoidRegions.length() < 3) {
                string = ResourceText.getText((Object)ResourceTextIdentifiers.NOT_LONG_ENOUGH);
            } else if (!stringWrapperWithVoidRegions.containsOnlyCharacters("0123456789-.: ")) {
                string = ResourceText.getText((Object)ResourceTextIdentifiers.INVALID_CHARACTERS);
            } else if (!stringWrapperWithVoidRegions.contains(":")) {
                string = ResourceText.getText((Object)ResourceTextIdentifiers.NO_TIME_PART_SEPARATOR);
            } else if (stringWrapperWithVoidRegions.substringCount(" ") > (valueStruct.isTimeOfDay ? 1 : 0)) {
                string = ResourceText.getText((Object)ResourceTextIdentifiers.TOO_MANY_PORTIONS);
            }
        } else if (valueStruct2.temporalValue != null) {
            if (Math.abs(valueStruct2.temporalValue) > 9223372036845959999L) {
                string2 = ResourceText.getText((Object)ResourceTextIdentifiers.VALUE_CANNOT_BE_GREATER_THAN_ABS_VALUE, (Object[])new String[]{"9223372036845959999"});
            }
        } else if (valueStruct2.millisecondValue != null && Math.abs(valueStruct2.millisecondValue) > 3320413933265999999L) {
            string3 = ResourceText.getText((Object)ResourceTextIdentifiers.VALUE_CANNOT_BE_GREATER_THAN_ABS_VALUE, (Object[])new String[]{"3320413933265999999"});
        }
        if (string != null) {
            throw new IllegalArgumentException(ResourceText.getText((Object)ResourceTextIdentifiers.INVALID_STRING_VALUE, (Object[])new String[]{valueStruct2.stringValue, "Time", string}));
        }
        if (string2 != null) {
            throw new IllegalArgumentException(ResourceText.getText((Object)ResourceTextIdentifiers.INVALID_TEMPORAL_VALUE, (Object[])new String[]{String.valueOf(valueStruct2.temporalValue), "Time", string2}));
        }
        if (string3 != null) {
            throw new IllegalArgumentException(ResourceText.getText((Object)ResourceTextIdentifiers.INVALID_MILLISECOND_VALUE, (Object[])new String[]{String.valueOf(valueStruct2.millisecondValue), "Time", string3}));
        }
        return valueStruct2;
    }

    private void ratifyParts(Object object, long l, long l2, long l3, long l4) {
        if (l < 0L || l > 922337203684L) {
            throw new IllegalArgumentException(ResourceText.getText((Object)ResourceTextIdentifiers.INVALID_NUMBER_OF_HOURS, (Object[])new String[]{object.toString()}));
        }
        if (l2 < 0L || l2 > 59L) {
            throw new IllegalArgumentException(ResourceText.getText((Object)ResourceTextIdentifiers.INVALID_NUMBER_OF_MINUTES, (Object[])new String[]{object.toString()}));
        }
        if (l3 < 0L || l3 > 59L) {
            throw new IllegalArgumentException(ResourceText.getText((Object)ResourceTextIdentifiers.INVALID_NUMBER_OF_SECONDS, (Object[])new String[]{object.toString()}));
        }
        if (l4 < 0L || l4 > 999L) {
            throw new IllegalArgumentException(ResourceText.getText((Object)ResourceTextIdentifiers.INVALID_NUMBER_OF_MILLISECONDS, (Object[])new String[]{object.toString()}));
        }
    }

    private void initFromStringValue(String string) {
        String string2 = null;
        NullFreeMutableList<String> nullFreeMutableList = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        String string6 = null;
        try {
            string2 = (String)new StringWrapperWithVoidRegions(string).split(" ").getFirst();
            if (string2.startsWith("-")) {
                this.negativeMultiplier = (byte)-1;
                string2 = string2.substring(1);
            }
            nullFreeMutableList = new StringWrapperWithVoidRegions(string2).split(".");
            string3 = (String)nullFreeMutableList.getFirst();
            string4 = nullFreeMutableList.size() == 1 ? "000" : (String)nullFreeMutableList.get(1);
            nullFreeMutableList = new StringWrapperWithVoidRegions(string3).split(":", true, true, true);
            string5 = nullFreeMutableList.size() == 2 ? "00" : (String)nullFreeMutableList.get(2);
            l4 = Long.parseLong((String)nullFreeMutableList.getFirst());
            l3 = Long.parseLong((String)nullFreeMutableList.get(1));
            l2 = Long.parseLong(string5);
            l = Long.parseLong(string4);
            this.ratifyParts(string, l4, l3, l2, l);
            this.millisecond = (short)l;
            this.second = (byte)l2;
            this.minute = (byte)l3;
            this.hour = l4;
            string6 = this.hour + new StringWrapperWithVoidRegions(this.minute).pad(2, "0", false).toString() + new StringWrapperWithVoidRegions(this.second).pad(2, "0", false) + new StringWrapperWithVoidRegions(this.millisecond).pad(3, "0", false);
            this.temporalValue = (long)this.negativeMultiplier * Long.parseLong(string6);
            this.millisecondValue = (long)this.negativeMultiplier * (this.hour * (long)Constants.UnitOfTime.HOUR.getMilliseconds() + (long)(this.minute * Constants.UnitOfTime.MINUTE.getMilliseconds()) + (long)(this.second * Constants.UnitOfTime.SECOND.getMilliseconds()) + (long)this.millisecond);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            string6 = ResourceText.getText((Object)ResourceTextIdentifiers.UNSPECIFIED_ISSUE);
            throw new IllegalArgumentException(ResourceText.getText((Object)ResourceTextIdentifiers.INVALID_STRING_VALUE, (Object[])new String[]{string, "Time", string6}));
        }
    }

    private void initFromTemporalValue(long l) {
        long l2 = 0L;
        StringWrapperWithVoidRegions stringWrapperWithVoidRegions = null;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        String string = null;
        try {
            this.temporalValue = l;
            l2 = l;
            if (l2 < 0L) {
                this.negativeMultiplier = (byte)-1;
                l2 = Math.abs(l2);
            }
            stringWrapperWithVoidRegions = new StringWrapperWithVoidRegions(l2).pad(9, "0", false);
            l3 = Long.parseLong(stringWrapperWithVoidRegions.getLast(3));
            stringWrapperWithVoidRegions.deleteLast(3);
            l4 = Long.parseLong(stringWrapperWithVoidRegions.getLast(2));
            stringWrapperWithVoidRegions.deleteLast(2);
            l5 = Long.parseLong(stringWrapperWithVoidRegions.getLast(2));
            stringWrapperWithVoidRegions.deleteLast(2);
            l6 = Long.parseLong(stringWrapperWithVoidRegions.toString());
            this.ratifyParts(l, l6, l5, l4, l3);
            this.millisecond = (short)l3;
            this.second = (byte)l4;
            this.minute = (byte)l5;
            this.hour = l6;
            this.millisecondValue = (long)this.negativeMultiplier * (this.hour * (long)Constants.UnitOfTime.HOUR.getMilliseconds() + (long)(this.minute * Constants.UnitOfTime.MINUTE.getMilliseconds()) + (long)(this.second * Constants.UnitOfTime.SECOND.getMilliseconds()) + (long)this.millisecond);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            string = ResourceText.getText((Object)ResourceTextIdentifiers.UNSPECIFIED_ISSUE);
            throw new IllegalArgumentException(ResourceText.getText((Object)ResourceTextIdentifiers.INVALID_TEMPORAL_VALUE, (Object[])new String[]{String.valueOf(l), "Time", string}));
        }
    }

    private void initFromMillisecondsValue(long l) {
        long l2 = 0L;
        TemporalUtils.TimeParts timeParts = null;
        String string = null;
        try {
            this.millisecondValue = l;
            l2 = l;
            if (l2 < 0L) {
                this.negativeMultiplier = (byte)-1;
                l2 = Math.abs(l2);
            }
            timeParts = TemporalUtils.getTimeParts(l2);
            this.hour = timeParts.hour;
            this.minute = timeParts.minute;
            this.second = timeParts.second;
            this.millisecond = timeParts.millisecond;
            this.ratifyParts(l, this.hour, this.minute, this.second, this.millisecond);
            this.temporalValue = (long)this.negativeMultiplier * Long.parseLong(this.hour + new StringWrapperWithVoidRegions(this.minute).pad(2, "0", false).toString() + new StringWrapperWithVoidRegions(this.second).pad(2, "0", false) + new StringWrapperWithVoidRegions(this.millisecond).pad(3, "0", false));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            string = ResourceText.getText((Object)ResourceTextIdentifiers.UNSPECIFIED_ISSUE);
            throw new IllegalArgumentException(ResourceText.getText((Object)ResourceTextIdentifiers.INVALID_MILLISECOND_VALUE, (Object[])new String[]{String.valueOf(l), "Time", string}));
        }
    }

    public String getString(StringFormat stringFormat) {
        StringBuilder stringBuilder = null;
        String string = null;
        stringFormat = stringFormat == null ? new StringFormat() : stringFormat.clone();
        stringFormat.setTimeFormatIfNull(new StringFormat.TimeFormat(true));
        if (stringFormat.getTimeFormat().includeTime()) {
            stringFormat.getTimeFormat().setTimeFormatIfNull(Constants.TimeFormat.HHMMSSMMM);
            if (stringFormat.getTimeFormat().getPadHour() == null) {
                stringFormat.getTimeFormat().setPadHour(false);
            }
        }
        stringBuilder = new StringBuilder();
        if (stringFormat.getTimeFormat().includeTime()) {
            string = stringFormat.getTimeFormat().getTimeFormat().toString();
            stringBuilder.append(this.isNegative() ? "-" : "");
            if (stringFormat.getTimeFormat().getPadHour().booleanValue()) {
                stringBuilder.append(new StringWrapperWithVoidRegions(this.hour).pad(2, "0", false));
            } else {
                stringBuilder.append(this.hour);
            }
            stringBuilder.append((Object)stringFormat.getTimeFormat().getSeparator());
            stringBuilder.append(new StringWrapperWithVoidRegions(this.minute).pad(2, "0", false));
            if (string.indexOf("ss") >= 0) {
                stringBuilder.append((Object)stringFormat.getTimeFormat().getSeparator());
                stringBuilder.append(new StringWrapperWithVoidRegions(this.second).pad(2, "0", false));
                if (string.indexOf("mmm") >= 0) {
                    if (!stringFormat.getTimeFormat().getSeparator().equals((Object)Constants.TimeSeparator.NONE)) {
                        stringBuilder.append(".");
                    }
                    stringBuilder.append(new StringWrapperWithVoidRegions(this.millisecond).pad(3, "0", false));
                }
            }
        }
        return stringBuilder.toString();
    }

    public long getTemporalValue() {
        return this.temporalValue;
    }

    public long getMillisecondValue() {
        return this.millisecondValue;
    }

    public boolean isNegative() {
        return this.negativeMultiplier == -1;
    }

    public long getDays() {
        return (long)Math.floor(this.millisecondValue / (long)Constants.UnitOfTime.DAY.getMilliseconds());
    }

    public long getHour() {
        return this.hour;
    }

    public byte getMinute() {
        return this.minute;
    }

    public byte getSecond() {
        return this.second;
    }

    public short getMillisecond() {
        return this.millisecond;
    }

    public boolean equalTo(Time time) {
        return this.compareTo(time) == 0;
    }

    public boolean lessThan(Time time) {
        return this.compareTo(time) < 0;
    }

    public boolean lessThanOrEqualTo(Time time) {
        return this.compareTo(time) <= 0;
    }

    public boolean greaterThan(Time time) {
        return this.compareTo(time) > 0;
    }

    public boolean greaterThanOrEqualTo(Time time) {
        return this.compareTo(time) >= 0;
    }

    public Time difference(Time time) {
        Time time2 = null;
        ValueStruct valueStruct = null;
        Assert.errorParam(time == null, new ResourceTextPointer((Object)com.jronimo.text.ResourceTextIdentifiers.MUST_NOT_BE_NULL, "instance"));
        valueStruct = new ValueStruct();
        valueStruct.millisecondValue = this.millisecondValue - time.millisecondValue;
        time2 = new Time(valueStruct);
        return time2;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        Time time = null;
        if (object instanceof Time) {
            time = (Time)object;
            bl = this.temporalValue == time.temporalValue;
        }
        return bl;
    }

    public String toString() {
        return this.getString(null);
    }

    public int compareTo(Object object) {
        int n = 0;
        Time time = null;
        if (object instanceof Time) {
            time = (Time)object;
            n = Long.valueOf(this.millisecondValue).compareTo(time.millisecondValue);
        } else {
            n = 1;
        }
        return n;
    }

    public static Time addHours(Time time, long l) {
        Time time2 = null;
        BigInteger bigInteger = null;
        bigInteger = BigInteger.valueOf(l).abs();
        Assert.errorParam((bigInteger = bigInteger.multiply(BigInteger.valueOf(3600000L))).compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0, new ResourceTextPointer((Object)ResourceTextIdentifiers.AMOUNT_OUT_OF_RANGE));
        time2 = Time.addMilliseconds(time, (long)(l < 0L ? -1 : 1) * bigInteger.longValue());
        return time2;
    }

    public static Time addMinutes(Time time, long l) {
        Time time2 = null;
        BigInteger bigInteger = null;
        bigInteger = BigInteger.valueOf(l).abs();
        Assert.errorParam((bigInteger = bigInteger.multiply(BigInteger.valueOf(60000L))).compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0, new ResourceTextPointer((Object)ResourceTextIdentifiers.AMOUNT_OUT_OF_RANGE));
        time2 = Time.addMilliseconds(time, (long)(l < 0L ? -1 : 1) * bigInteger.longValue());
        return time2;
    }

    public static Time addSeconds(Time time, long l) {
        Time time2 = null;
        BigInteger bigInteger = null;
        bigInteger = BigInteger.valueOf(l).abs();
        Assert.errorParam((bigInteger = bigInteger.multiply(BigInteger.valueOf(1000L))).compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0, new ResourceTextPointer((Object)ResourceTextIdentifiers.AMOUNT_OUT_OF_RANGE));
        time2 = Time.addMilliseconds(time, (long)(l < 0L ? -1 : 1) * bigInteger.longValue());
        return time2;
    }

    public static Time addMilliseconds(Time time, long l) {
        Time time2 = null;
        BigInteger bigInteger = null;
        ValueStruct valueStruct = null;
        bigInteger = BigInteger.valueOf(l);
        Assert.errorParam((bigInteger = bigInteger.add(BigInteger.valueOf(time.getMillisecondValue()))).abs().compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0, new ResourceTextPointer((Object)ResourceTextIdentifiers.AMOUNT_PLUS_VALUE_OUT_OF_RANGE));
        valueStruct = new ValueStruct();
        valueStruct.millisecondValue = time.getMillisecondValue() + l;
        time2 = new Time(valueStruct);
        return time2;
    }
}

