/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.temporal;

import com.jronimo.temporal.Constants;
import com.jronimo.temporal.ResourceTextIdentifiers;
import com.jronimo.temporal.StringFormat;
import com.jronimo.temporal.Timezone;
import com.jronimo.temporal.ValueStruct;
import com.jronimo.text.ResourceText;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import com.jronimo.util.StringWrapper;
import java.util.Calendar;

public final class TemporalUtils {
    private static final Logger logger = Logger.getLogger(TemporalUtils.class);

    private TemporalUtils() {
    }

    public static boolean checkDaysValue(int n, int n2, long l) {
        boolean bl = false;
        Constants.Month month = null;
        month = Constants.Month.getMonthByNumber(n2);
        bl = n > 0 && n <= month.getNumberOfDays(l);
        return bl;
    }

    public static boolean isLeapYear(long l) {
        boolean bl = false;
        boolean bl2 = false;
        Assert.errorParam(l == 0L, new ResourceTextPointer((Object)ResourceTextIdentifiers.YEAR_CANNOT_BE_ZERO));
        if (l < 0L) {
            l = Math.abs(l) - 1L;
            bl2 = true;
        }
        bl = bl2 || l < 1600L ? l % 4L == 0L : (l % 100L == 0L ? l % 400L == 0L : l % 4L == 0L);
        return bl;
    }

    public static String calendarToString(Calendar calendar) {
        return TemporalUtils.calendarToString(calendar, null);
    }

    public static String calendarToString(Calendar calendar, StringFormat stringFormat) {
        StringWrapper stringWrapper = null;
        int n = 0;
        long l = 0L;
        Constants.Month month = null;
        boolean bl = false;
        StringWrapper stringWrapper2 = null;
        String string = null;
        String string2 = null;
        Timezone timezone = null;
        if (calendar != null) {
            stringWrapper = new StringWrapper();
            stringFormat = stringFormat == null ? new StringFormat() : stringFormat.clone();
            stringFormat.setDateFormatIfNull(new StringFormat.DateFormat(true));
            stringFormat.setTimeFormatIfNull(new StringFormat.TimeFormat(true));
            stringFormat.setTimezoneFormatIfNull(new StringFormat.TimezoneFormat());
            if (stringFormat.getDateFormat().includeDate()) {
                stringFormat.getDateFormat().setSeparatorIfNull(Constants.DateSeparator.HYPHEN);
                stringFormat.getDateFormat().setUseAdBcIfNull(false);
                stringFormat.getDateFormat().setMonthFormatIfNull(Constants.MonthFormat.NUMBER);
            }
            if (stringFormat.getTimeFormat().includeTime()) {
                stringFormat.getTimeFormat().setTimeFormatIfNull(Constants.TimeFormat.HHMMSSMMM);
            }
            stringFormat.getTimezoneFormat().setIncludeTimezoneIdIfNull(false);
            stringFormat.getTimezoneFormat().setIncludeTimezoneNameIfNull(false);
            if (stringFormat.getDateFormat().includeDate()) {
                n = calendar.get(2) + 1;
                l = calendar.get(1);
                month = Constants.Month.getMonthByNumber(n);
                bl = calendar.get(0) == 0;
                stringWrapper2 = new StringWrapper(l).pad(4, "0", false);
                if (bl) {
                    if (stringFormat.getDateFormat().useAdBc().booleanValue()) {
                        stringWrapper2.append(" BC");
                    } else {
                        stringWrapper2.insert(0, "-");
                    }
                } else if (stringFormat.getDateFormat().useAdBc().booleanValue()) {
                    stringWrapper2.append(" AD");
                }
                string = stringFormat.getDateFormat().getMonthFormat() == Constants.MonthFormat.NAME ? month.getName() : (stringFormat.getDateFormat().getMonthFormat() == Constants.MonthFormat.ABBREVIATION ? month.getAbbreviation() : new StringWrapper(n).pad(2, "0", false).toString());
                stringWrapper.append(stringWrapper2);
                stringWrapper.append(stringFormat.getDateFormat().getSeparator().toString());
                stringWrapper.append(string);
                stringWrapper.append(stringFormat.getDateFormat().getSeparator().toString());
                stringWrapper.append(new StringWrapper(calendar.get(5)).pad(2, "0", false));
            }
            if (stringFormat.getTimeFormat().includeTime()) {
                string2 = stringFormat.getTimeFormat().getTimeFormat().toString();
                if (stringWrapper.length() > 0) {
                    stringWrapper.append(" ");
                }
                stringWrapper.append(new StringWrapper(calendar.get(11)).pad(2, "0", false));
                stringWrapper.append(":");
                stringWrapper.append(new StringWrapper(calendar.get(12)).pad(2, "0", false));
                if (string2.indexOf("ss") >= 0) {
                    stringWrapper.append(":");
                    stringWrapper.append(new StringWrapper(calendar.get(13)).pad(2, "0", false));
                    if (string2.indexOf("mmm") >= 0) {
                        stringWrapper.append(".");
                        stringWrapper.append(new StringWrapper(calendar.get(14)).pad(3, "0", false));
                    }
                }
            }
            if (stringFormat.getTimezoneFormat().includeTimezone().booleanValue()) {
                timezone = Timezone.getTimezoneByJavaId(calendar.getTimeZone().getID());
                if (stringFormat.getTimezoneFormat().includeTimezoneName().booleanValue()) {
                    if (stringWrapper.length() > 0) {
                        stringWrapper.append(" ");
                    }
                    stringWrapper.append(timezone == null ? calendar.getTimeZone().getID() : timezone.getText());
                } else if (stringFormat.getTimezoneFormat().includeTimezoneId().booleanValue() && timezone != null) {
                    if (stringWrapper.length() > 0) {
                        stringWrapper.append(" ");
                    }
                    stringWrapper.append(timezone.getId());
                }
            }
        }
        return stringWrapper == null ? null : stringWrapper.toString();
    }

    static void add(Calendar calendar, int n, long l) {
        int n2 = 1;
        if (l < 0L) {
            n2 = -1;
            l = Math.abs(l);
        }
        int n3 = (int)(l / Integer.MAX_VALUE);
        for (int i = 1; i <= n3; ++i) {
            calendar.add(n, n2 * Integer.MAX_VALUE);
        }
        calendar.add(n, (int)((long)n2 * (l % Integer.MAX_VALUE)));
    }

    static TimeParts getTimeParts(long l) {
        TimeParts timeParts = null;
        int n = 1;
        long l2 = 0L;
        timeParts = new TimeParts();
        if (l < 0L) {
            n = -1;
        }
        l2 = Math.abs(l);
        timeParts.hour = l2 / (long)Constants.UnitOfTime.HOUR.getMilliseconds();
        timeParts.hour *= (long)n;
        timeParts.minute = (byte)((l2 -= timeParts.hour * (long)Constants.UnitOfTime.HOUR.getMilliseconds()) / (long)Constants.UnitOfTime.MINUTE.getMilliseconds());
        timeParts.second = (byte)((l2 -= (long)(timeParts.minute * Constants.UnitOfTime.MINUTE.getMilliseconds())) / (long)Constants.UnitOfTime.SECOND.getMilliseconds());
        timeParts.millisecond = (short)(l2 -= (long)(timeParts.second * Constants.UnitOfTime.SECOND.getMilliseconds()));
        return timeParts;
    }

    static Timezone getTimezone(ValueStruct valueStruct) {
        Timezone timezone = null;
        String[] stringArray = null;
        String string = null;
        String string2 = null;
        long l = 0L;
        Integer n = null;
        if (valueStruct.stringValue != null) {
            stringArray = valueStruct.stringValue.trim().split(" ");
            if (stringArray.length > 1 && (string = stringArray[stringArray.length - 1]).indexOf(":") < 0) {
                if (!new StringWrapper(string).containsOnlyDigits()) {
                    string2 = ResourceText.getText((Object)com.jronimo.text.ResourceTextIdentifiers.MUST_CONTAIN_DIGITS_ONLY, (Object[])new String[]{"timezoneId", string});
                } else {
                    l = Long.parseLong(string);
                    if (l > 127L) {
                        string2 = ResourceText.getText((Object)com.jronimo.text.ResourceTextIdentifiers.MUST_NOT_BE_GREATER_THAN, (Object[])new String[]{"timezoneId", string, "127"});
                    }
                }
                if (string2 == null) {
                    n = (int)l;
                }
            }
            if (string2 != null) {
                throw new IllegalArgumentException(ResourceText.getText((Object)ResourceTextIdentifiers.INVALID_TIMEZONE_VALUE, (Object[])new String[]{valueStruct.stringValue, "TimeOfDay", string2}));
            }
        }
        if (n == null) {
            n = valueStruct.timezoneId;
        }
        if (n == null) {
            n = 0;
            valueStruct.isExplicitTimezone = false;
        } else {
            valueStruct.isExplicitTimezone = true;
        }
        timezone = Timezone.getTimezone(n);
        if (timezone == null) {
            logger.warning(new ResourceTextPointer((Object)ResourceTextIdentifiers.UNRECOGNIZED_TIMEZONE_ID, n.toString()).getText());
            valueStruct.isExplicitTimezone = false;
            timezone = Timezone.getTimezone(0);
        }
        return timezone;
    }

    public static class TimeParts {
        public long hour;
        public byte minute;
        public byte second;
        public short millisecond;
    }
}

