/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.temporal;

import com.jronimo.temporal.Date;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;

public class DateRange
implements Comparable {
    private Date startDate;
    private Date endDate;

    public DateRange(Date date, Date date2) {
        if (date != null && date2 != null && date2.lessThan(date)) {
            this.startDate = date2;
            this.endDate = date;
        } else {
            this.startDate = date;
            this.endDate = date2;
        }
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public boolean encompasses(Date date) {
        boolean bl = false;
        Assert.errorParam(date == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "date"));
        bl = !DateRange.before(date, this.startDate) && !DateRange.after(date, this.endDate);
        return bl;
    }

    public boolean encompasses(DateRange dateRange) {
        boolean bl = false;
        Assert.errorParam(dateRange == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "dateRange"));
        bl = DateRange.encompasses(this, dateRange.startDate, true) && DateRange.encompasses(this, dateRange.endDate, false);
        return bl;
    }

    public boolean encompassedBy(DateRange dateRange) {
        return dateRange.encompasses(this);
    }

    public boolean overlappedLeftBy(DateRange dateRange) {
        boolean bl = false;
        Assert.errorParam(dateRange == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "dateRange"));
        bl = DateRange.before(dateRange.startDate, this.startDate) && DateRange.encompasses(this, dateRange.endDate, false);
        return bl;
    }

    public boolean overlappedRightBy(DateRange dateRange) {
        boolean bl = false;
        Assert.errorParam(dateRange == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "dateRange"));
        bl = DateRange.encompasses(this, dateRange.startDate, true) && DateRange.after(dateRange.endDate, this.endDate);
        return bl;
    }

    public boolean overlappedBy(DateRange dateRange) {
        return this.overlappedLeftBy(dateRange) || this.overlappedRightBy(dateRange);
    }

    public boolean before(DateRange dateRange) {
        boolean bl = false;
        Assert.errorParam(dateRange == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "dateRange"));
        bl = this.endDate != null && dateRange.startDate != null && this.endDate.lessThan(dateRange.startDate);
        return bl;
    }

    public boolean after(DateRange dateRange) {
        boolean bl = false;
        Assert.errorParam(dateRange == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "dateRange"));
        bl = this.startDate != null && dateRange.endDate != null && this.startDate.greaterThan(dateRange.endDate);
        return bl;
    }

    public int hashCode() {
        int n = 17;
        if (this.startDate == null && this.endDate == null) {
            n = String.valueOf(System.currentTimeMillis()).hashCode();
        } else {
            if (this.startDate != null) {
                n = n * 37 + this.startDate.hashCode();
            }
            if (this.endDate != null) {
                n = n * 37 + this.endDate.hashCode();
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        DateRange dateRange = null;
        if (object instanceof DateRange) {
            dateRange = (DateRange)object;
            bl = (this.startDate == null && dateRange.startDate == null || this.startDate != null && this.startDate.equals(dateRange.startDate)) && (this.endDate == null && dateRange.endDate == null || this.endDate != null && this.endDate.equals(dateRange.endDate));
        }
        return bl;
    }

    public int compareTo(Object object) {
        int n = 0;
        DateRange dateRange = null;
        if (object instanceof DateRange) {
            dateRange = (DateRange)object;
            if (DateRange.before(this.startDate, dateRange.startDate)) {
                n = -1;
            } else if (DateRange.before(dateRange.startDate, this.startDate)) {
                n = 1;
            } else if (DateRange.after(this.endDate, dateRange.endDate)) {
                n = 1;
            } else if (DateRange.after(dateRange.endDate, this.endDate)) {
                n = -1;
            }
        } else {
            n = 1;
        }
        return n;
    }

    private static boolean encompasses(DateRange dateRange, Date date, boolean bl) {
        boolean bl2 = false;
        bl2 = date == null ? (bl ? dateRange.startDate == null : dateRange.endDate == null) : !DateRange.before(date, dateRange.startDate) && !DateRange.after(date, dateRange.endDate);
        return bl2;
    }

    private static boolean before(Date date, Date date2) {
        return date2 != null && (date == null || date.lessThan(date2));
    }

    private static boolean after(Date date, Date date2) {
        return date2 != null && (date == null || date.greaterThan(date2));
    }
}

