/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.temporal;

import com.jronimo.collections.NullFreeMutableList;
import com.jronimo.temporal.Constants;
import com.jronimo.temporal.PublicHolidayLookup;
import com.jronimo.temporal.ResourceTextIdentifiers;
import com.jronimo.temporal.StringFormat;
import com.jronimo.temporal.TemporalUtils;
import com.jronimo.temporal.Time;
import com.jronimo.temporal.Timezone;
import com.jronimo.temporal.ValueStruct;
import com.jronimo.text.ResourceText;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import com.jronimo.util.StringWrapperWithVoidRegions;
import java.util.Calendar;

public final class Date
implements Comparable {
    private static final Logger logger = Logger.getLogger(Date.class);
    private byte negativeMultiplier = 1;
    private int year;
    private byte month;
    private byte day;
    private long temporalValue;
    private Timezone timezone;
    private boolean hasExplicitTimezone;
    private Calendar calendar;
    private long maxYearValue;

    public Date(String string) {
        this(new ValueStruct(string));
    }

    public Date(String string, Integer n) {
        this(new ValueStruct(string, n));
    }

    public Date(long l) {
        this(new ValueStruct(l));
    }

    public Date(long l, Integer n) {
        this(new ValueStruct(l, n));
    }

    public Date(int n) {
        this(new ValueStruct(n));
    }

    public Date(int n, Integer n2) {
        this(new ValueStruct(n, n2));
    }

    public Date(ValueStruct valueStruct) {
        Assert.errorParam(valueStruct == null, new ResourceTextPointer((Object)com.jronimo.text.ResourceTextIdentifiers.MUST_NOT_BE_NULL, "struct"));
        valueStruct = this.ratifyStruct(valueStruct);
        this.timezone = TemporalUtils.getTimezone(valueStruct);
        this.hasExplicitTimezone = valueStruct.isExplicitTimezone;
        if (valueStruct.stringValue != null) {
            this.initFromStringValue(valueStruct.stringValue);
        } else if (valueStruct.temporalValue != null) {
            this.initFromTemporalValue(valueStruct.temporalValue.intValue());
        } else {
            throw new IllegalArgumentException(ResourceText.getText((Object)com.jronimo.text.ResourceTextIdentifiers.INVALID_STRUCT, (Object[])new String[]{"struct"}));
        }
    }

    private ValueStruct ratifyStruct(ValueStruct valueStruct) {
        ValueStruct valueStruct2 = null;
        StringWrapperWithVoidRegions stringWrapperWithVoidRegions = null;
        String string = null;
        String string2 = null;
        long l = 0L;
        valueStruct2 = valueStruct.clone();
        this.maxYearValue = valueStruct2.isDateTime ? 922337L : 214748L;
        if (valueStruct2.stringValue != null) {
            stringWrapperWithVoidRegions = new StringWrapperWithVoidRegions(valueStruct2.stringValue);
            if (stringWrapperWithVoidRegions.length() < 5) {
                string = ResourceText.getText((Object)ResourceTextIdentifiers.NOT_LONG_ENOUGH);
            } else if (!stringWrapperWithVoidRegions.containsOnlyCharacters("0123456789-/.: ")) {
                string = ResourceText.getText((Object)ResourceTextIdentifiers.INVALID_CHARACTERS);
            } else if (stringWrapperWithVoidRegions.substringCount(" ") > 2) {
                string = ResourceText.getText((Object)ResourceTextIdentifiers.TOO_MANY_PORTIONS);
            }
        } else if (valueStruct2.temporalValue != null) {
            l = Math.abs(valueStruct2.temporalValue);
            if (String.valueOf(l).length() < 5) {
                string2 = ResourceText.getText((Object)ResourceTextIdentifiers.NOT_LONG_ENOUGH);
            } else if (l < 10101L) {
                string2 = ResourceText.getText((Object)ResourceTextIdentifiers.VALUE_CANNOT_BE_LESS_THAN_ABS_VALUE, (Object[])new String[]{"10101"});
            } else if (l > Long.parseLong(this.maxYearValue + "1231")) {
                string2 = ResourceText.getText((Object)ResourceTextIdentifiers.VALUE_CANNOT_BE_GREATER_THAN_ABS_VALUE, (Object[])new String[]{this.maxYearValue + "1231"});
            }
        }
        if (string != null) {
            throw new IllegalArgumentException(ResourceText.getText((Object)ResourceTextIdentifiers.INVALID_STRING_VALUE, (Object[])new String[]{valueStruct2.stringValue, "Date", string}));
        }
        if (string2 != null) {
            throw new IllegalArgumentException(ResourceText.getText((Object)ResourceTextIdentifiers.INVALID_TEMPORAL_VALUE, (Object[])new String[]{String.valueOf(valueStruct2.temporalValue), "Date", string2}));
        }
        return valueStruct2;
    }

    private void ratifyParts(Object object, long l, long l2, long l3) {
        if (l == 0L || Math.abs(l) > this.maxYearValue) {
            throw new IllegalArgumentException(ResourceText.getText((Object)ResourceTextIdentifiers.INVALID_NUMBER_OF_YEARS, (Object[])new String[]{object.toString()}));
        }
        if (l2 < 1L || l2 > 12L) {
            throw new IllegalArgumentException(ResourceText.getText((Object)ResourceTextIdentifiers.INVALID_NUMBER_OF_MONTHS, (Object[])new String[]{object.toString()}));
        }
        if (l3 < 1L || l3 > 31L) {
            throw new IllegalArgumentException(ResourceText.getText((Object)ResourceTextIdentifiers.INVALID_NUMBER_OF_DAYS, (Object[])new String[]{object.toString()}));
        }
        if (!TemporalUtils.checkDaysValue((int)l3, (int)l2, l)) {
            throw new IllegalArgumentException(ResourceText.getText((Object)ResourceTextIdentifiers.INVALID_NUMBER_OF_DAYS_FOR_MONTH, (Object[])new String[]{object.toString()}));
        }
    }

    private void initFromStringValue(String string) {
        StringWrapperWithVoidRegions stringWrapperWithVoidRegions = null;
        NullFreeMutableList<String> nullFreeMutableList = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        String string2 = null;
        try {
            stringWrapperWithVoidRegions = new StringWrapperWithVoidRegions(new StringWrapperWithVoidRegions(string).split(" ").getFirst());
            string = stringWrapperWithVoidRegions.toString();
            if (stringWrapperWithVoidRegions.startsWith("-")) {
                this.negativeMultiplier = (byte)-1;
                stringWrapperWithVoidRegions.deleteFirst();
            }
            stringWrapperWithVoidRegions.replaceAll("/", "-");
            stringWrapperWithVoidRegions.replaceAll(".", "-");
            nullFreeMutableList = stringWrapperWithVoidRegions.split("-", true, true, true);
            if (nullFreeMutableList.size() != 3) {
                throw new IllegalArgumentException(ResourceText.getText((Object)ResourceTextIdentifiers.INVALID_STRING_VALUE, (Object[])new String[]{string, "Date", "Incorrect number of date separators."}));
            }
            l = Long.parseLong((String)nullFreeMutableList.get(0));
            l2 = Long.parseLong((String)nullFreeMutableList.get(1));
            l3 = Long.parseLong((String)nullFreeMutableList.get(2));
            this.ratifyParts(string, (long)this.negativeMultiplier * l, l2, l3);
            this.year = (int)l;
            this.month = (byte)l2;
            this.day = (byte)l3;
            string2 = new StringWrapperWithVoidRegions(this.year).pad(4, "0", false).toString() + new StringWrapperWithVoidRegions(this.month).pad(2, "0", false) + new StringWrapperWithVoidRegions(this.day).pad(2, "0", false);
            this.temporalValue = (long)this.negativeMultiplier * Long.parseLong(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            string2 = ResourceText.getText((Object)ResourceTextIdentifiers.UNSPECIFIED_ISSUE);
            throw new IllegalArgumentException(ResourceText.getText((Object)ResourceTextIdentifiers.INVALID_STRING_VALUE, (Object[])new String[]{string, "Date", string2}));
        }
    }

    private void initFromTemporalValue(long l) {
        long l2 = 0L;
        StringWrapperWithVoidRegions stringWrapperWithVoidRegions = null;
        String string = null;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        try {
            l2 = this.temporalValue = l;
            if (l2 < 0L) {
                this.negativeMultiplier = (byte)-1;
                l2 = Math.abs(l2);
            }
            stringWrapperWithVoidRegions = new StringWrapperWithVoidRegions(l2).pad(5, "0", false);
            l5 = Long.parseLong(stringWrapperWithVoidRegions.getLast(2));
            stringWrapperWithVoidRegions.deleteLast(2);
            l4 = Long.parseLong(stringWrapperWithVoidRegions.getLast(2));
            stringWrapperWithVoidRegions.deleteLast(2);
            l3 = Long.parseLong(stringWrapperWithVoidRegions.toString());
            this.ratifyParts(l, (long)this.negativeMultiplier * l3, l4, l5);
            this.year = (int)l3;
            this.month = (byte)l4;
            this.day = (byte)l5;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            string = ResourceText.getText((Object)ResourceTextIdentifiers.UNSPECIFIED_ISSUE);
            throw new IllegalArgumentException(ResourceText.getText((Object)ResourceTextIdentifiers.INVALID_TEMPORAL_VALUE, (Object[])new String[]{String.valueOf(l), "Date", string}));
        }
    }

    public String getString(StringFormat stringFormat) {
        StringBuilder stringBuilder = null;
        Constants.Month month = null;
        String string = null;
        stringFormat = stringFormat == null ? new StringFormat() : stringFormat.clone();
        stringFormat.setDateFormatIfNull(new StringFormat.DateFormat(true));
        stringFormat.setTimezoneFormatIfNull(new StringFormat.TimezoneFormat(this.hasExplicitTimezone));
        if (stringFormat.getDateFormat().includeDate()) {
            stringFormat.getDateFormat().setSeparatorIfNull(Constants.DateSeparator.HYPHEN);
            stringFormat.getDateFormat().setUseAdBcIfNull(false);
            stringFormat.getDateFormat().setMonthFormatIfNull(Constants.MonthFormat.NUMBER);
        }
        stringFormat.getTimezoneFormat().setIncludeTimezoneIdIfNull(false);
        stringFormat.getTimezoneFormat().setIncludeTimezoneNameIfNull(false);
        stringBuilder = new StringBuilder();
        if (stringFormat.getDateFormat().includeDate()) {
            month = Constants.Month.getMonthByNumber(this.month);
            if (this.isNegative() && !stringFormat.getDateFormat().useAdBc().booleanValue()) {
                stringBuilder.append("-");
            }
            string = stringFormat.getDateFormat().getMonthFormat() == Constants.MonthFormat.NAME ? month.getName() : (stringFormat.getDateFormat().getMonthFormat() == Constants.MonthFormat.ABBREVIATION ? month.getAbbreviation() : new StringWrapperWithVoidRegions(this.month).pad(2, "0", false).toString());
            stringBuilder.append(new StringWrapperWithVoidRegions(this.year).pad(4, "0", false));
            stringBuilder.append((Object)stringFormat.getDateFormat().getSeparator());
            stringBuilder.append(string);
            stringBuilder.append((Object)stringFormat.getDateFormat().getSeparator());
            stringBuilder.append(new StringWrapperWithVoidRegions(this.day).pad(2, "0", false));
            if (stringFormat.getDateFormat().useAdBc().booleanValue()) {
                stringBuilder.append(this.isNegative() ? " BC" : " AD");
            }
        }
        if (stringFormat.getTimezoneFormat().includeTimezone().booleanValue()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            if (stringFormat.getTimezoneFormat().includeTimezoneName().booleanValue()) {
                stringBuilder.append(this.timezone.getText());
            } else if (stringFormat.getTimezoneFormat().includeTimezoneId().booleanValue()) {
                stringBuilder.append(this.timezone.getId());
            }
        }
        return stringBuilder.toString();
    }

    public long getTemporalValue() {
        return this.temporalValue;
    }

    public boolean isNegative() {
        return this.negativeMultiplier == -1;
    }

    public int getYear() {
        return this.negativeMultiplier * this.year;
    }

    public byte getMonth() {
        return this.month;
    }

    public byte getDay() {
        return this.day;
    }

    public Timezone getTimezone() {
        return this.timezone;
    }

    public boolean hasExplicitTimezone() {
        return this.hasExplicitTimezone;
    }

    public boolean equalTo(Date date) {
        return this.compareTo(date) == 0;
    }

    public boolean lessThan(Date date) {
        return this.compareTo(date) < 0;
    }

    public boolean lessThanOrEqualTo(Date date) {
        return this.compareTo(date) <= 0;
    }

    public boolean greaterThan(Date date) {
        return this.compareTo(date) > 0;
    }

    public boolean greaterThanOrEqualTo(Date date) {
        return this.compareTo(date) >= 0;
    }

    public Time difference(Date date) {
        Time time = null;
        Calendar calendar = null;
        Calendar calendar2 = null;
        ValueStruct valueStruct = null;
        Assert.errorParam(date == null, new ResourceTextPointer((Object)com.jronimo.text.ResourceTextIdentifiers.MUST_NOT_BE_NULL, "instance"));
        calendar = this.getCalendar();
        calendar.setTimeZone(Timezone.getTimezone(0).getJavaTimeZone());
        calendar2 = date.getCalendar();
        calendar2.setTimeZone(Timezone.getTimezone(0).getJavaTimeZone());
        valueStruct = new ValueStruct();
        valueStruct.millisecondValue = calendar.getTime().getTime() - calendar2.getTime().getTime();
        time = new Time(valueStruct);
        return time;
    }

    public synchronized Calendar getCalendar() {
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance(this.timezone.getJavaTimeZone());
            this.calendar.set(this.year, this.month - 1, this.day, 0, 0, 0);
            this.calendar.set(14, 0);
            if (this.isNegative()) {
                this.calendar.set(0, 0);
            }
        }
        return (Calendar)this.calendar.clone();
    }

    public int getDayOfWeekNumber() {
        int n = 0;
        n = this.getCalendar().get(7) - 1;
        if (n == 0) {
            n = 7;
        }
        return n;
    }

    public String getDayOfWeekName() {
        return Constants.DayOfWeek.getDayByNumber(this.getDayOfWeekNumber()).getName();
    }

    public String getDayOfWeekShortName() {
        return Constants.DayOfWeek.getDayByNumber(this.getDayOfWeekNumber()).getAbbreviation();
    }

    public boolean isWeekDay() {
        return Constants.DayOfWeek.getDayByNumber(this.getDayOfWeekNumber()).isWeekDay();
    }

    public boolean isPublicHoliday(PublicHolidayLookup publicHolidayLookup) {
        Assert.errorParam(publicHolidayLookup == null, new ResourceTextPointer((Object)com.jronimo.text.ResourceTextIdentifiers.MUST_NOT_BE_NULL, "lookup"));
        return publicHolidayLookup.isPublicHoliday(this);
    }

    public byte getWeekNumber() {
        byte by = 0;
        Calendar calendar = null;
        Date date = null;
        int n = 1;
        calendar = Calendar.getInstance(Timezone.getTimezone(0).getJavaTimeZone());
        calendar.set(this.year, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        while (calendar.get(7) != 2) {
            calendar.roll(5, true);
        }
        date = new Date(TemporalUtils.calendarToString(calendar, new StringFormat(new StringFormat.DateFormat(true))));
        while (date.lessThanOrEqualTo(this)) {
            ++n;
            date = Date.addDays(date, 7);
        }
        by = (byte)(n - 1);
        return by;
    }

    public byte getDaysInMonth() {
        return (byte)Constants.Month.getMonthByNumber(this.month).getNumberOfDays(this.year);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        Date date = null;
        if (object instanceof Date) {
            date = (Date)object;
            if (this.temporalValue == date.temporalValue && this.timezone.equals(date.timezone)) {
                bl = true;
            }
        }
        return bl;
    }

    public String toString() {
        return this.getString(null);
    }

    public int compareTo(Object object) {
        int n = 0;
        Date date = null;
        if (object instanceof Date) {
            date = (Date)object;
            n = Integer.valueOf(this.getYear()).compareTo(date.getYear());
            if (n == 0) {
                n = Integer.valueOf(this.getMonth()).compareTo(Integer.valueOf(date.getMonth()));
            }
            if (n == 0) {
                n = Integer.valueOf(this.getDay()).compareTo(Integer.valueOf(date.getDay()));
            }
        } else {
            n = 1;
        }
        return n;
    }

    public static Date now(boolean bl) {
        return Date.now(bl, null);
    }

    public static Date now(boolean bl, Integer n) {
        Date date = null;
        int n2 = 0;
        if (bl) {
            n2 = Timezone.getTimezoneByJavaId(Calendar.getInstance().getTimeZone().getID()).getId();
        }
        if (n == null) {
            n = n2;
        }
        date = Date.now(n2, n);
        return date;
    }

    public static Date now(int n) {
        return Date.now(n, null);
    }

    public static Date now(int n, Integer n2) {
        Date date = null;
        Timezone timezone = null;
        Calendar calendar = null;
        StringFormat stringFormat = null;
        timezone = Timezone.getTimezone(n);
        Assert.errorParam(timezone == null, new ResourceTextPointer((Object)com.jronimo.text.ResourceTextIdentifiers.UNRECOGNIZED_VALUE, "nowTimezoneId", String.valueOf(n)));
        if (n2 == null) {
            n2 = n;
        }
        calendar = Calendar.getInstance(timezone.getJavaTimeZone());
        stringFormat = new StringFormat(new StringFormat.DateFormat(true));
        date = new Date(TemporalUtils.calendarToString(calendar, stringFormat) + " " + n2);
        return date;
    }

    public static Date addYears(Date date, int n) {
        return Date.add(date, 1, n);
    }

    public static Date addMonths(Date date, int n) {
        return Date.add(date, 2, n);
    }

    public static Date addDays(Date date, int n) {
        return Date.add(date, 6, n);
    }

    private static Date add(Date date, int n, int n2) {
        Date date2 = null;
        Calendar calendar = null;
        StringFormat stringFormat = null;
        calendar = date.getCalendar();
        calendar.add(n, n2);
        stringFormat = new StringFormat(new StringFormat.DateFormat(true), new StringFormat.TimezoneFormat(date.hasExplicitTimezone()));
        date2 = new Date(TemporalUtils.calendarToString(calendar, stringFormat));
        return date2;
    }
}

