/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration.persister;

import com.jronimo.systemconfiguration.BusinessObject;
import com.jronimo.systemconfiguration.BusinessObjectOperation;
import com.jronimo.systemconfiguration.BusinessObjectPermission;
import com.jronimo.systemconfiguration.Constants;
import com.jronimo.systemconfiguration.ConstraintSet;
import com.jronimo.systemconfiguration.DataSource;
import com.jronimo.systemconfiguration.Entity;
import com.jronimo.systemconfiguration.EntityOperationsConfiguration;
import com.jronimo.systemconfiguration.EntityPermission;
import com.jronimo.systemconfiguration.EntityPermissionSecurityClause;
import com.jronimo.systemconfiguration.Field;
import com.jronimo.systemconfiguration.Key;
import com.jronimo.systemconfiguration.Language;
import com.jronimo.systemconfiguration.Permission;
import com.jronimo.systemconfiguration.RefDataCategory;
import com.jronimo.systemconfiguration.RefDataItem;
import com.jronimo.systemconfiguration.Relationship;
import com.jronimo.systemconfiguration.SystemConfiguration;
import com.jronimo.systemconfiguration.SystemField;
import com.jronimo.systemconfiguration.SystemRole;
import com.jronimo.systemconfiguration.TextElement;
import com.jronimo.systemconfiguration.TextGroup;
import com.jronimo.util.Logger;
import com.jronimo.util.Methods;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlPersister {
    private static final Logger logger = Logger.getLogger(XmlPersister.class);
    private SystemConfiguration system;
    private File saveFile;
    private XmlElement relationshipsElement;
    private List<XmlElement> textGroupElements;
    private List<XmlElement> refDataElements;

    public XmlPersister(SystemConfiguration systemConfiguration, File file) {
        this(systemConfiguration, file, null);
    }

    public XmlPersister(SystemConfiguration systemConfiguration, File file, Map<String, List<XmlElement>> map) {
        this.system = systemConfiguration;
        this.saveFile = file;
        if (map != null) {
            if (map.containsKey("relationships")) {
                this.relationshipsElement = map.get("relationships").get(0);
            }
            this.textGroupElements = map.get("text-groups");
            this.refDataElements = map.get("ref-data-categories");
        }
    }

    public void execute() throws Exception {
        XmlElement xmlElement = null;
        xmlElement = XmlElementFactory.create("system");
        xmlElement.addElement("identifier").setText(this.system.getIdentifier());
        this.populateLanguagesElement(xmlElement.addElement("languages"));
        this.populateSystemRolesElement(xmlElement.addElement("system-roles"));
        this.populateRepositoryElement(xmlElement.addElement("repository"));
        xmlElement.save(this.saveFile);
    }

    private void populateLanguagesElement(XmlElement xmlElement) throws Exception {
        XmlElement xmlElement2 = null;
        xmlElement2 = xmlElement.addElement("default-language");
        xmlElement2.addElement("code").setText(this.system.getDefaultLanguageCode());
        xmlElement2.addElement("variation").setText(this.system.getDefaultLanguageVariationCode());
        for (Language language : this.system.getLanguages()) {
            this.populateLanguageElement(xmlElement.addElement("language"), language);
        }
    }

    private void populateLanguageElement(XmlElement xmlElement, Language language) throws Exception {
        xmlElement.addElement("code").setText(language.getCode());
        if (language.hasVariations()) {
            for (String string : language.getVariations()) {
                xmlElement.addElement("variation").setText(string);
            }
        }
    }

    private void populateRepositoryElement(XmlElement xmlElement) throws Exception {
        this.populateDataSourcesElement(xmlElement.addElement("data-sources"));
        this.populateEntitiesElement(xmlElement.addElement("entities"));
        this.populateRelationshipsElement(xmlElement);
        this.populateBusinessObjectsElement(xmlElement.addElement("business-objects"));
        this.populateTextGroupsElement(xmlElement.addElement("text-groups"));
        this.populateRefDataCategoriesElement(xmlElement.addElement("ref-data-categories"));
        this.populateSecurityConfigurationElement(xmlElement.addElement("security-configuration"));
    }

    private void populateDataSourcesElement(XmlElement xmlElement) throws Exception {
        for (DataSource dataSource : this.system.getRepository().getDataSources()) {
            this.populateDataSourceElement(xmlElement.addElement("data-source"), dataSource);
        }
    }

    private void populateDataSourceElement(XmlElement xmlElement, DataSource dataSource) throws Exception {
        XmlElement xmlElement2 = null;
        XmlElement xmlElement3 = null;
        xmlElement.addElement("name").setText(dataSource.getName());
        xmlElement.addElement("is-default").setBoolean(dataSource.isDefault());
        xmlElement.addElement("type").setText(dataSource.getType().getIdentifier());
        if (dataSource.getType() == Constants.DataSourceType.RDBMS) {
            xmlElement2 = xmlElement.addElement("rdbms");
            xmlElement2.addElement("default-schema").setText(dataSource.getDefaultSchema());
            xmlElement2.addElement("audit-schema").setText(dataSource.getAuditSchema());
            xmlElement3 = xmlElement2.addElement("other-schemas");
            for (String string : dataSource.getOtherSchemas()) {
                xmlElement3.addElement("schema").setText(string);
            }
            if (dataSource.hasSequenceDetails()) {
                xmlElement3 = xmlElement2.addElement("sequences");
                xmlElement3.addElement("sequence-type").setText(dataSource.getSequenceDetails().sequenceType.getIdentifier());
                xmlElement3.addElement("sequence-table-name").setText(dataSource.getSequenceDetails().sequenceTableName);
                xmlElement3.addElement("grouping-sequence-name").setText(dataSource.getSequenceDetails().groupingSequenceName);
            }
        }
    }

    private void populateEntitiesElement(XmlElement xmlElement) throws Exception {
        for (Entity entity : this.system.getRepository().getSortedEntityList()) {
            this.populateEntityElement(xmlElement.addElement("entity"), entity);
        }
    }

    private void populateEntityElement(XmlElement xmlElement, Entity entity) throws Exception {
        XmlElement xmlElement2 = null;
        xmlElement.addElement("id").setLong(entity.getId());
        xmlElement.addElement("name").setText(entity.getName());
        xmlElement.addElement("persistence-identifier").setText(entity.getPersistenceIdentifier());
        if (entity.getDataSource() != null) {
            xmlElement2 = xmlElement.addElement("data-source");
            xmlElement2.addElement("name").setText(entity.getDataSource().name);
            if (entity.getDataSource().schema != null) {
                xmlElement2.addElement("schema").setText(entity.getDataSource().schema);
            }
        }
        xmlElement.addElement("comments").setText(entity.getComments());
        this.populateEntityFieldsElement(xmlElement.addElement("fields"), entity);
        this.populateEntityPrimaryKeyElement(xmlElement.addElement("primary-key"), entity);
        this.populateEntityKeysElement(xmlElement.addElement("keys"), entity);
        this.populateEntitySystemFieldsElement(xmlElement.addElement("system-fields"), entity);
        this.populateEntityConstraintSetsElement(xmlElement.addElement("constraint-sets"), entity);
        this.populateEntityOperationsElement(xmlElement.addElement("operations"), entity);
    }

    private void populateEntityFieldsElement(XmlElement xmlElement, Entity entity) throws Exception {
        for (Field field : entity.getFields()) {
            this.populateEntityFieldElement(xmlElement.addElement("field"), field);
        }
    }

    private void populateEntitySystemFieldsElement(XmlElement xmlElement, Entity entity) throws Exception {
        for (SystemField systemField : entity.getSystemFields()) {
            this.populateEntityFieldElement(xmlElement.addElement("system-field"), systemField);
        }
    }

    private void populateEntityFieldElement(XmlElement xmlElement, Field field) throws Exception {
        xmlElement.addElement("id").setLong(field.getId());
        if (field instanceof SystemField) {
            xmlElement.addElement("system-field-type").setText(((SystemField)field).getSystemFieldType().getIdentifier());
        }
        xmlElement.addElement("name").setText(field.getName());
        xmlElement.addElement("persistence-identifier").setText(field.getPersistenceIdentifier());
        xmlElement.addElement("comments").setText(field.getComments());
        this.populateEntityFieldTypeElement(xmlElement.addElement("type"), field.getTypeDetails());
        xmlElement.addElement("default-value").setText(field.getDefaultValue().getValue());
    }

    private void populateEntityFieldTypeElement(XmlElement xmlElement, Field.TypeDetails typeDetails) throws Exception {
        XmlElement xmlElement2 = null;
        XmlElement xmlElement3 = null;
        xmlElement.addElement("data-type").setText(typeDetails.getDataType().getName());
        xmlElement.addElement("code-type").setText(typeDetails.getCodeType().getIdentifier());
        xmlElement2 = xmlElement.addElement("data-source-types");
        for (Constants.DataSourceEngine object : typeDetails.getDataSourceFieldTypes().keySet()) {
            xmlElement3 = xmlElement2.addElement("data-source-type");
            xmlElement3.addElement("engine").setText(object.getIdentifier());
            xmlElement3.addElement("type").setText(typeDetails.getDataSourceFieldTypes().get((Object)object).getPersistenceDefinition());
        }
        if (!Methods.isEmpty(typeDetails.getParameters())) {
            for (String string : typeDetails.getParameters().keySet()) {
                xmlElement.addElement(string).setText(typeDetails.getParameters().get(string));
            }
        }
    }

    private void populateEntityPrimaryKeyElement(XmlElement xmlElement, Entity entity) throws Exception {
        XmlElement xmlElement2 = null;
        xmlElement.addElement("type").setText(entity.getPrimaryKey().getType().getIdentifier());
        if (entity.getPrimaryKey().getSequenceName() != null) {
            xmlElement.addElement("sequence-name").setText(entity.getPersistenceIdentifier());
        }
        xmlElement2 = xmlElement.addElement("fields");
        for (String string : entity.getPrimaryKey().getFieldNames()) {
            xmlElement2.addElement("field-name").setText(string);
        }
    }

    private void populateEntityKeysElement(XmlElement xmlElement, Entity entity) throws Exception {
        for (Key key : entity.getKeys()) {
            this.populateEntityKeyElement(xmlElement.addElement("key"), key);
        }
    }

    private void populateEntityKeyElement(XmlElement xmlElement, Key key) throws Exception {
        XmlElement xmlElement2 = null;
        xmlElement.addElement("name").setText(key.getName());
        xmlElement2 = xmlElement.addElement("fields");
        for (String string : key.getFields()) {
            xmlElement2.addElement("field-name").setText(string);
        }
    }

    private void populateEntityConstraintSetsElement(XmlElement xmlElement, Entity entity) throws Exception {
        for (ConstraintSet constraintSet : entity.getConstraintSets().values()) {
            this.populateEntityConstraintSetElement(xmlElement.addElement("constraint-set"), constraintSet);
        }
    }

    private void populateEntityConstraintSetElement(XmlElement xmlElement, ConstraintSet constraintSet) throws Exception {
        xmlElement.addElement("name").setText(constraintSet.getName());
        if (constraintSet.hasValidator()) {
            xmlElement.addElement("validation-class").setText(constraintSet.getValidator().getClass().getName());
        }
        xmlElement = xmlElement.addElement("fields");
        for (String string : constraintSet.getConstraints().keySet()) {
            this.populateEntityFieldConstraintsElement(xmlElement.addElement("field"), string, constraintSet.getConstraints(string));
        }
    }

    private void populateEntityFieldConstraintsElement(XmlElement xmlElement, String string, Set<ConstraintSet.Constraint> set) throws Exception {
        xmlElement.addElement("field-name").setText(string);
        xmlElement = xmlElement.addElement("constraints");
        for (ConstraintSet.Constraint constraint : set) {
            this.populateEntityFieldConstraintsElement(xmlElement.addElement("constraint"), constraint);
        }
    }

    private void populateEntityFieldConstraintsElement(XmlElement xmlElement, ConstraintSet.Constraint constraint) throws Exception {
        XmlElement xmlElement2 = null;
        xmlElement.addElement("name").setText(constraint.getName());
        if (constraint.hasValue()) {
            xmlElement.addElement("value").setText(constraint.getOriginalValue());
        } else if (constraint.hasValues()) {
            for (String string : constraint.getOriginalValues()) {
                xmlElement.addElement("value").setText(string);
            }
        }
        if (constraint.hasAdditional()) {
            for (String string : constraint.getOriginalAdditional().keySet()) {
                xmlElement2 = xmlElement.addElement("additional");
                xmlElement2.addElement("name").setText(string);
                xmlElement2.addElement("value").setText(constraint.getOriginalAdditional().get(string));
            }
        }
    }

    private void populateEntityOperationsElement(XmlElement xmlElement, Entity entity) throws Exception {
        EntityOperationsConfiguration entityOperationsConfiguration = null;
        XmlElement xmlElement2 = null;
        entityOperationsConfiguration = entity.getEntityOperationsConfiguration();
        xmlElement2 = xmlElement.addElement("supported-operations");
        for (Constants.EntityOperation object : entityOperationsConfiguration.getSupportedOperations()) {
            xmlElement2.addElement("operation").setText(object.getIdentifier());
        }
        xmlElement.addElement("supports-list-where-clause").setText(String.valueOf(entityOperationsConfiguration.supportsListWhereClause()).toLowerCase());
        xmlElement2 = xmlElement.addElement("fields-hidden-from-read-operations");
        for (String string : entityOperationsConfiguration.getReadHiddenFields()) {
            xmlElement2.addElement("field-name").setText(string);
        }
        xmlElement2 = xmlElement.addElement("fields-hidden-from-write-operations");
        for (String string : entityOperationsConfiguration.getWriteHiddenFields()) {
            xmlElement2.addElement("field-name").setText(string);
        }
        xmlElement2 = xmlElement.addElement("lazy-fields");
        for (String string : entityOperationsConfiguration.getLazyFields()) {
            xmlElement2.addElement("field-name").setText(string);
        }
        xmlElement2 = xmlElement.addElement("list-return-fields");
        for (String string : entityOperationsConfiguration.getListReturnFields()) {
            xmlElement2.addElement("field-name").setText(string);
        }
        xmlElement2 = xmlElement.addElement("get-return-fields");
        for (String string : entityOperationsConfiguration.getGetReturnFields()) {
            xmlElement2.addElement("field-name").setText(string);
        }
    }

    private void populateRelationshipsElement(XmlElement xmlElement) throws Exception {
        XmlElement xmlElement2 = null;
        if (this.relationshipsElement == null) {
            xmlElement2 = xmlElement.addElement("relationships");
            for (Relationship relationship : this.system.getRepository().getRelationships()) {
                this.populateRelationshipElement(xmlElement2.addElement("relationship"), relationship);
            }
        } else {
            xmlElement.addElement(this.relationshipsElement);
        }
    }

    private void populateRelationshipElement(XmlElement xmlElement, Relationship relationship) throws Exception {
        XmlElement xmlElement2 = null;
        xmlElement.addElement("name").setText(relationship.getName());
        xmlElement.addElement("type").setText(relationship.getType());
        xmlElement2 = xmlElement.addElement("entity-types");
        xmlElement2.addElement("name").setText(relationship.getEntityTypeA());
        xmlElement2.addElement("name").setText(relationship.getEntityTypeB());
        if (relationship.getCascadeDelete()) {
            xmlElement.addElement("cascade-delete").setText("true");
        }
        this.populateRelationshipLinkElement(xmlElement.addElement("link"), relationship.getLink());
        this.populateRelationshipVirtualFieldsElement(xmlElement.addElement("virtual-fields"), relationship.getVirtualFields());
        xmlElement.addElement("comments").setText(relationship.getComments());
    }

    private void populateRelationshipLinkElement(XmlElement xmlElement, Relationship.Link link) throws Exception {
        xmlElement.addElement("type").setText(link.getType());
        if (link.getLinkEntity() != null) {
            xmlElement.addElement("link-entity").setText(link.getLinkEntity());
        }
        if (link.getHoldingEntity() != null) {
            xmlElement.addElement("holding-entity").setText(link.getHoldingEntity());
        }
        this.populateRelationshipLinkMappingsElement(xmlElement.addElement("mappings"), link.getMappings());
    }

    private void populateRelationshipLinkMappingsElement(XmlElement xmlElement, List<Relationship.Mapping> list) throws Exception {
        for (Relationship.Mapping mapping : list) {
            this.populateRelationshipLinkMappingElement(xmlElement.addElement("mapping"), mapping);
        }
    }

    private void populateRelationshipLinkMappingElement(XmlElement xmlElement, Relationship.Mapping mapping) throws Exception {
        for (Relationship.MappingMemberStruct mappingMemberStruct : mapping.getMembers()) {
            this.populateRelationshipLinkMappingMemberElement(xmlElement.addElement("member"), mappingMemberStruct);
        }
    }

    private void populateRelationshipLinkMappingMemberElement(XmlElement xmlElement, Relationship.MappingMemberStruct mappingMemberStruct) throws Exception {
        xmlElement.addElement("entity-name").setText(mappingMemberStruct.entityName);
        xmlElement.addElement("field-name").setText(mappingMemberStruct.fieldName);
    }

    private void populateRelationshipVirtualFieldsElement(XmlElement xmlElement, List<Relationship.VirtualField> list) throws Exception {
        for (Relationship.VirtualField virtualField : list) {
            this.populateRelationshipVirtualFieldElement(xmlElement.addElement("virtual-field"), virtualField);
        }
    }

    private void populateRelationshipVirtualFieldElement(XmlElement xmlElement, Relationship.VirtualField virtualField) throws Exception {
        xmlElement.addElement("entity-name").setText(virtualField.getEntityName());
        xmlElement.addElement("field-name").setText(virtualField.getFieldName());
    }

    private void populateBusinessObjectsElement(XmlElement xmlElement) throws Exception {
        for (BusinessObject businessObject : this.system.getRepository().getBusinessObjects()) {
            this.populateBusinessObjectElement(xmlElement.addElement("business-object"), businessObject);
        }
    }

    private void populateBusinessObjectElement(XmlElement xmlElement, BusinessObject businessObject) throws Exception {
        xmlElement.addElement("identifier").setText(businessObject.getIdentifier());
        xmlElement.addElement("comments").setText(businessObject.getComments());
        this.populateBusinessObjectOperationsElement(xmlElement.addElement("operations"), businessObject);
    }

    private void populateBusinessObjectOperationsElement(XmlElement xmlElement, BusinessObject businessObject) throws Exception {
        for (BusinessObjectOperation businessObjectOperation : businessObject.getOperations()) {
            this.populateBusinessObjectOperationElement(xmlElement.addElement("operation"), businessObjectOperation);
        }
    }

    private void populateBusinessObjectOperationElement(XmlElement xmlElement, BusinessObjectOperation businessObjectOperation) throws Exception {
        XmlElement xmlElement2 = null;
        xmlElement.addElement("name").setText(businessObjectOperation.getName());
        xmlElement.addElement("comments").setText(businessObjectOperation.getComments());
        xmlElement2 = xmlElement.addElement("protocols");
        for (String string : businessObjectOperation.getProtocols()) {
            xmlElement2.addElement("protocol").setText(string);
        }
        this.populateBusinessObjectOperationParametersElement(xmlElement.addElement("parameters"), businessObjectOperation);
    }

    private void populateBusinessObjectOperationParametersElement(XmlElement xmlElement, BusinessObjectOperation businessObjectOperation) throws Exception {
        for (BusinessObjectOperation.Parameter parameter : businessObjectOperation.getParameters()) {
            this.populateBusinessObjectOperationParameterElement(xmlElement.addElement("parameter"), parameter);
        }
    }

    private void populateBusinessObjectOperationParameterElement(XmlElement xmlElement, BusinessObjectOperation.Parameter parameter) throws Exception {
        xmlElement.addElement("name").setText(parameter.getName());
        xmlElement.addElement("type").setText(parameter.getType());
    }

    private void populateTextGroupsElement(XmlElement xmlElement) throws Exception {
        if (this.textGroupElements == null) {
            for (TextGroup textGroup : this.system.getRepository().getTextGroups()) {
                this.populateTextGroupElement(xmlElement.addElement("text-group"), textGroup);
            }
        } else {
            for (XmlElement xmlElement2 : this.textGroupElements) {
                xmlElement.addElement(xmlElement2);
            }
        }
    }

    private void populateTextGroupElement(XmlElement xmlElement, TextGroup textGroup) throws Exception {
        XmlElement xmlElement2 = null;
        xmlElement.addElement("id").setLong(textGroup.getId());
        xmlElement.addElement("identifier").setText(textGroup.getIdentifier());
        xmlElement2 = xmlElement.addElement("text-elements");
        for (TextElement textElement : textGroup.getTextElements()) {
            this.populateTextElementElement(xmlElement2.addElement("text-element"), textElement);
        }
    }

    private void populateTextElementElement(XmlElement xmlElement, TextElement textElement) throws Exception {
        xmlElement.addElement("id").setLong(textElement.getId());
        xmlElement.addElement("identifier").setText(textElement.getIdentifier());
        xmlElement.addElement("default-value").setText(textElement.getDefaultValue());
    }

    private void populateRefDataCategoriesElement(XmlElement xmlElement) throws Exception {
        if (this.refDataElements == null) {
            for (RefDataCategory refDataCategory : this.system.getRepository().getRefDataCategories()) {
                this.populateRefDataCategoryElement(xmlElement.addElement("category"), refDataCategory);
            }
        } else {
            for (XmlElement xmlElement2 : this.refDataElements) {
                xmlElement.addElement(xmlElement2);
            }
        }
    }

    private void populateRefDataCategoryElement(XmlElement xmlElement, RefDataCategory refDataCategory) throws Exception {
        XmlElement xmlElement2 = null;
        xmlElement.addElement("id").setText(String.valueOf(refDataCategory.getId()));
        xmlElement.addElement("identifier").setText(refDataCategory.getIdentifier());
        xmlElement.addElement("parent-identifier").setText(refDataCategory.getParentIdentifier());
        xmlElement.addElement("display-text-identifier").setText(refDataCategory.getDisplayTextIdentifier());
        xmlElement.addElement("status").setText(refDataCategory.getStatus());
        if (refDataCategory.getProperties().size() > 0) {
            xmlElement2 = xmlElement.addElement("properties");
            for (RefDataCategory.PropertyStruct object : refDataCategory.getProperties()) {
                this.populateRefDataCategoryPropertyElement(xmlElement2.addElement("property"), object);
            }
        }
        for (RefDataItem refDataItem : refDataCategory.getRefDataItems()) {
            this.populateRefDataItemElement(xmlElement.addElement("item"), refDataItem);
        }
    }

    private void populateRefDataCategoryPropertyElement(XmlElement xmlElement, RefDataCategory.PropertyStruct propertyStruct) throws Exception {
        xmlElement.addElement("name").setText(String.valueOf(propertyStruct.name));
        xmlElement.addElement("type").setText(String.valueOf(propertyStruct.type));
    }

    private void populateRefDataItemElement(XmlElement xmlElement, RefDataItem refDataItem) throws Exception {
        XmlElement xmlElement2 = null;
        xmlElement.addElement("id").setLong(refDataItem.getId());
        xmlElement.addElement("identifier").setText(refDataItem.getIdentifier());
        xmlElement.addElement("value-text-identifier").setText(refDataItem.getValueTextIdentifier());
        xmlElement.addElement("status").setText(refDataItem.getStatus());
        if (refDataItem.getProperties().size() > 0) {
            xmlElement2 = xmlElement.addElement("properties");
            for (RefDataItem.PropertyStruct propertyStruct : refDataItem.getProperties()) {
                this.populateRefDataItemPropertyElement(xmlElement2.addElement("property"), propertyStruct);
            }
        }
    }

    private void populateRefDataItemPropertyElement(XmlElement xmlElement, RefDataItem.PropertyStruct propertyStruct) throws Exception {
        xmlElement.addElement("name").setText(String.valueOf(propertyStruct.name));
        xmlElement.addElement("value").setText(String.valueOf(propertyStruct.value));
    }

    private void populateSystemRolesElement(XmlElement xmlElement) throws Exception {
        for (SystemRole systemRole : this.system.getSystemRoles()) {
            this.populateSystemRoleElement(xmlElement.addElement("system-role"), systemRole);
        }
    }

    private void populateSystemRoleElement(XmlElement xmlElement, SystemRole systemRole) throws Exception {
        xmlElement.addElement("id").setLong(systemRole.getId());
        xmlElement.addElement("name").setText(systemRole.getName());
    }

    private void populateSecurityConfigurationElement(XmlElement xmlElement) throws Exception {
        this.populateSecurityConfigurationPermissionsElement(xmlElement.addElement("permissions"));
    }

    private void populateSecurityConfigurationPermissionsElement(XmlElement xmlElement) throws Exception {
        for (Permission permission : this.system.getRepository().getSecurityConfiguration().getPermissions()) {
            this.populateSecurityConfigurationPermissionElement(xmlElement.addElement("permission"), permission);
        }
    }

    private void populateSecurityConfigurationPermissionElement(XmlElement xmlElement, Permission permission) throws Exception {
        XmlElement xmlElement2 = null;
        xmlElement.addElement("id").setLong(permission.getId());
        xmlElement2 = xmlElement.addElement("system-roles");
        for (SystemRole systemRole : permission.getSystemRoles()) {
            xmlElement2.addElement("system-role").setText(systemRole.getName());
        }
        if (permission.getEntityPermissions().size() > 0) {
            this.populateSecurityConfigurationEntityPermissionsElement(xmlElement.addElement("entity-permissions"), permission);
        }
        if (permission.getBusinessObjectPermissions().size() > 0) {
            this.populateSecurityConfigurationBusinessObjectPermissionsElement(xmlElement.addElement("business-object-permissions"), permission);
        }
    }

    private void populateSecurityConfigurationEntityPermissionsElement(XmlElement xmlElement, Permission permission) throws Exception {
        for (EntityPermission entityPermission : permission.getEntityPermissions()) {
            this.populateSecurityConfigurationEntityPermissionElement(xmlElement.addElement("entity-permission"), entityPermission);
        }
    }

    private void populateSecurityConfigurationEntityPermissionElement(XmlElement xmlElement, EntityPermission entityPermission) throws Exception {
        XmlElement xmlElement2 = null;
        XmlElement xmlElement3 = null;
        xmlElement.addElement("id").setLong(entityPermission.getId());
        xmlElement.addElement("entity-name").setText(entityPermission.getEntityName());
        for (EntityPermissionSecurityClause entityPermissionSecurityClause : entityPermission.getSecurityClauses()) {
            xmlElement2 = xmlElement.addElement("security-clause");
            xmlElement2.addElement("id").setLong(entityPermissionSecurityClause.getId());
            xmlElement2.addElement("clause").setText(entityPermissionSecurityClause.getClause());
            xmlElement3 = xmlElement2.addElement("operations");
            for (Constants.EntityOperation entityOperation : entityPermissionSecurityClause.getSupportedOperations()) {
                xmlElement3.addElement("operation-name").setText(entityOperation.getIdentifier());
            }
            xmlElement3 = xmlElement2.addElement("read-fields");
            for (String string : entityPermissionSecurityClause.getReadFields()) {
                xmlElement3.addElement("field-name").setText(string);
            }
            xmlElement3 = xmlElement2.addElement("update-fields");
            for (String string : entityPermissionSecurityClause.getUpdateFields()) {
                xmlElement3.addElement("field-name").setText(string);
            }
            xmlElement3 = xmlElement2.addElement("create-fields");
            for (String string : entityPermissionSecurityClause.getCreateFields()) {
                xmlElement3.addElement("field-name").setText(string);
            }
        }
    }

    private void populateSecurityConfigurationBusinessObjectPermissionsElement(XmlElement xmlElement, Permission permission) throws Exception {
        for (BusinessObjectPermission businessObjectPermission : permission.getBusinessObjectPermissions()) {
            this.populateSecurityConfigurationBusinessObjectPermissionElement(xmlElement.addElement("business-object-permission"), businessObjectPermission);
        }
    }

    private void populateSecurityConfigurationBusinessObjectPermissionElement(XmlElement xmlElement, BusinessObjectPermission businessObjectPermission) throws Exception {
        XmlElement xmlElement2 = null;
        xmlElement.addElement("business-object-name").setText(businessObjectPermission.getBusinessObjectName());
        xmlElement2 = xmlElement.addElement("operations");
        for (String string : businessObjectPermission.getSupportedOperations()) {
            xmlElement2.addElement("operation-name").setText(string);
        }
    }
}

