/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration.loader.xml;

import com.jronimo.systemconfiguration.Repository;
import com.jronimo.systemconfiguration.SecurityConfiguration;
import com.jronimo.systemconfiguration.SystemConfiguration;
import com.jronimo.systemconfiguration.loader.nodeloaders.BusinessObjectNodeLoader;
import com.jronimo.systemconfiguration.loader.nodeloaders.DataSourcesNodeLoader;
import com.jronimo.systemconfiguration.loader.nodeloaders.EntityNodeLoader;
import com.jronimo.systemconfiguration.loader.nodeloaders.LanguagesNodeLoader;
import com.jronimo.systemconfiguration.loader.nodeloaders.RefDataCategoryNodeLoader;
import com.jronimo.systemconfiguration.loader.nodeloaders.RelationshipNodeLoader;
import com.jronimo.systemconfiguration.loader.nodeloaders.SecurityConfigurationNodeLoader;
import com.jronimo.systemconfiguration.loader.nodeloaders.SystemRolesNodeLoader;
import com.jronimo.systemconfiguration.loader.nodeloaders.TextGroupNodeLoader;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;

public class XmlLoader {
    private static final Logger logger = Logger.getLogger(XmlLoader.class);
    private File systemXmlFile;

    public XmlLoader(File file) {
        this.systemXmlFile = file;
    }

    public SystemConfiguration execute() throws Exception {
        SystemConfiguration systemConfiguration = null;
        XmlElement xmlElement = null;
        LanguagesNodeLoader languagesNodeLoader = null;
        xmlElement = XmlElementFactory.load(this.systemXmlFile);
        languagesNodeLoader = new LanguagesNodeLoader(xmlElement.getElement("languages"));
        languagesNodeLoader.execute();
        systemConfiguration = new SystemConfiguration(xmlElement.getText("identifier"), languagesNodeLoader.getDefaultLanguageCode(), languagesNodeLoader.getDefaultLanguageVariationCode());
        systemConfiguration.setLanguages(languagesNodeLoader.getLanguages());
        systemConfiguration.setSystemRoles(new SystemRolesNodeLoader(xmlElement.getElement("system-roles")).execute());
        this.loadRepository(xmlElement.getElement("repository"), systemConfiguration);
        return systemConfiguration;
    }

    private void loadRepository(XmlElement xmlElement, SystemConfiguration systemConfiguration) throws Exception {
        Repository repository = null;
        repository = new Repository();
        systemConfiguration.setRepository(repository);
        repository.setDataSources(new DataSourcesNodeLoader(xmlElement.getElement("data-sources")).execute());
        this.loadEntities(xmlElement.getElement("entities"), repository);
        this.loadRelationships(xmlElement.getElement("relationships"), repository);
        this.loadBusinessObjects(xmlElement.getElement("business-objects"), repository);
        this.loadTextGroups(xmlElement.getElement("text-groups"), repository);
        this.loadRefDataCategories(xmlElement.getElement("ref-data-categories"), repository);
        this.loadSecurityConfiguration(xmlElement.getElement("security-configuration"), repository, systemConfiguration);
    }

    private void loadEntities(XmlElement xmlElement, Repository repository) throws Exception {
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("entity")) {
            repository.addEntity(new EntityNodeLoader(xmlElement2).execute());
        }
    }

    private void loadRelationships(XmlElement xmlElement, Repository repository) throws Exception {
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("relationship")) {
            repository.addRelationship(new RelationshipNodeLoader(xmlElement2).execute());
        }
    }

    private void loadBusinessObjects(XmlElement xmlElement, Repository repository) throws Exception {
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("business-object")) {
            repository.addBusinessObject(new BusinessObjectNodeLoader(xmlElement2).execute());
        }
    }

    private void loadTextGroups(XmlElement xmlElement, Repository repository) throws Exception {
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("text-group")) {
            repository.addTextGroup(new TextGroupNodeLoader(xmlElement2).execute());
        }
    }

    private void loadRefDataCategories(XmlElement xmlElement, Repository repository) throws Exception {
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("category")) {
            repository.addRefDataCategory(new RefDataCategoryNodeLoader(xmlElement2).execute());
        }
    }

    private void loadSecurityConfiguration(XmlElement xmlElement, Repository repository, SystemConfiguration systemConfiguration) throws Exception {
        SecurityConfiguration securityConfiguration = null;
        securityConfiguration = new SecurityConfigurationNodeLoader(xmlElement, systemConfiguration).execute();
        repository.setSecurityConfiguration(securityConfiguration);
    }
}

