/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration.loader.nodeloaders;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.systemconfiguration.SystemRole;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemRolesNodeLoader {
    private static final Logger logger = Logger.getLogger(SystemRolesNodeLoader.class);
    private XmlElement element;

    public SystemRolesNodeLoader(XmlElement xmlElement) {
        this.element = xmlElement;
    }

    public Collection<SystemRole> execute() throws Exception {
        Set set = null;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        nullFreeCollection = this.element.getOptionalElements("system-role");
        set = CollectionUtils.getOrderedSet(new HashSet(nullFreeCollection.size()));
        for (XmlElement xmlElement : nullFreeCollection) {
            set.add(this.loadSystemRole(xmlElement));
        }
        return set;
    }

    private SystemRole loadSystemRole(XmlElement xmlElement) throws Exception {
        SystemRole systemRole = null;
        systemRole = new SystemRole(xmlElement.getLong("id"), xmlElement.getText("name"));
        return systemRole;
    }
}

