/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration.loader.nodeloaders;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.systemconfiguration.Language;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguagesNodeLoader {
    private static final Logger logger = Logger.getLogger(LanguagesNodeLoader.class);
    private XmlElement element;
    private String defaultLanguageCode;
    private String defaultLanguageVariationCode;
    private Collection<Language> languages = CollectionUtils.getOrderedSet(new HashSet(5));

    public LanguagesNodeLoader(XmlElement xmlElement) {
        this.element = xmlElement;
    }

    public String getDefaultLanguageCode() {
        return this.defaultLanguageCode;
    }

    public String getDefaultLanguageVariationCode() {
        return this.defaultLanguageVariationCode;
    }

    public Collection<Language> getLanguages() {
        return this.languages;
    }

    public void execute() throws Exception {
        this.defaultLanguageCode = this.element.getText("default-language/code");
        this.defaultLanguageVariationCode = this.element.getText("default-language/variation");
        for (XmlElement xmlElement : this.element.getElements("language")) {
            this.languages.add(this.loadLanguage(xmlElement));
        }
    }

    private Language loadLanguage(XmlElement xmlElement) throws Exception {
        Language language = null;
        String string = null;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        Set set = null;
        string = xmlElement.getText("code");
        nullFreeCollection = xmlElement.getOptionalElements("variation");
        if (nullFreeCollection.size() > 0) {
            set = CollectionUtils.getOrderedSet(new HashSet(2));
            for (XmlElement xmlElement2 : nullFreeCollection) {
                set.add(xmlElement2.getText());
            }
        }
        language = new Language(string, set);
        return language;
    }
}

