/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration.loader.nodeloaders;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.systemconfiguration.Constants;
import com.jronimo.systemconfiguration.ConstraintSet;
import com.jronimo.systemconfiguration.DataSourceFieldType;
import com.jronimo.systemconfiguration.DataType;
import com.jronimo.systemconfiguration.DefaultValue;
import com.jronimo.systemconfiguration.Entity;
import com.jronimo.systemconfiguration.EntityOperationsConfiguration;
import com.jronimo.systemconfiguration.Field;
import com.jronimo.systemconfiguration.Key;
import com.jronimo.systemconfiguration.PrimaryKey;
import com.jronimo.systemconfiguration.ResourceTextIdentifiers;
import com.jronimo.systemconfiguration.SystemField;
import com.jronimo.systemconfiguration.SystemFieldType;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import com.jronimo.util.Methods;
import com.jronimo.xml.XmlElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityNodeLoader {
    private static final Logger logger = Logger.getLogger(EntityNodeLoader.class);
    private XmlElement element;

    public EntityNodeLoader(XmlElement xmlElement) {
        this.element = xmlElement;
    }

    public Entity execute() throws Exception {
        Entity entity = null;
        entity = new Entity(this.element.getLong("id"), this.element.getText("name"), this.element.getText("persistence-identifier"), this.element.getText("comments"));
        this.loadDataSourceElement(this.element, entity);
        this.loadFieldsElement(this.element.getElement("fields"), entity);
        this.loadPrimaryKeyElement(this.element.getElement("primary-key"), entity);
        this.loadKeysElement(this.element.getElement("keys"), entity);
        this.loadSystemFieldsElement(this.element.getElement("system-fields"), entity);
        this.loadConstraintSetsElement(this.element.getElement("constraint-sets"), entity);
        this.loadOperationsElement(this.element.getElement("operations"), entity);
        return entity;
    }

    private void loadDataSourceElement(XmlElement xmlElement, Entity entity) throws Exception {
        XmlElement xmlElement2 = null;
        Entity.DataSource dataSource = null;
        if (xmlElement.hasElement("data-source")) {
            xmlElement2 = xmlElement.getElement("data-source");
            dataSource = new Entity.DataSource();
            dataSource.name = xmlElement2.getText("name");
            dataSource.schema = xmlElement2.getOptionalText("schema");
            entity.setDataSource(dataSource);
        }
    }

    private void loadFieldsElement(XmlElement xmlElement, Entity entity) throws Exception {
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("field")) {
            this.loadFieldElement(xmlElement2, entity, false);
        }
    }

    private void loadSystemFieldsElement(XmlElement xmlElement, Entity entity) throws Exception {
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("system-field")) {
            this.loadFieldElement(xmlElement2, entity, true);
        }
    }

    private void loadFieldElement(XmlElement xmlElement, Entity entity, boolean bl) throws Exception {
        Long l = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        SystemFieldType systemFieldType = null;
        Field field = null;
        l = bl ? 0L : xmlElement.getLong("id");
        string = xmlElement.getText("name");
        string2 = xmlElement.getText("persistence-identifier");
        string3 = xmlElement.getText("comments");
        if (bl) {
            systemFieldType = SystemFieldType.find(xmlElement.getText("system-field-type"));
            field = new SystemField(systemFieldType, l, string, string2, string3);
        } else {
            field = new Field(l, string, string2, string3);
        }
        new DefaultValue(xmlElement.getText("default-value"), field);
        this.loadFieldTypeElement(xmlElement.getElement("type"), field);
        if (bl) {
            entity.addSystemField((SystemField)field);
        } else {
            entity.addField(field);
        }
    }

    private void loadFieldTypeElement(XmlElement xmlElement, Field field) throws Exception {
        Constants.DataSourceEngine dataSourceEngine = null;
        DataSourceFieldType dataSourceFieldType = null;
        Field.TypeDetails typeDetails = null;
        Map map = null;
        String string = null;
        typeDetails = new Field.TypeDetails(xmlElement.getText("data-type"), xmlElement.getText("code-type"));
        for (XmlElement object : xmlElement.getOptionalElements("data-source-types/data-source-type")) {
            dataSourceEngine = Constants.DataSourceEngine.get(object.getText("engine"));
            if (dataSourceEngine == Constants.DataSourceEngine.MY_SQL) {
                dataSourceFieldType = DataSourceFieldType.createMySqlInstance(object.getText("type"));
            }
            typeDetails.addDataSourceFieldType(dataSourceEngine, dataSourceFieldType);
        }
        field.setTypeDetails(typeDetails);
        map = CollectionUtils.getOrderedMap(new HashMap(field.getDataType().getParameters().size()));
        for (DataType.Parameter parameter : field.getDataType().getParameters()) {
            string = xmlElement.getOptionalText(parameter.name);
            Assert.unexpected(parameter.mandatory && Methods.isEmpty(string), new ResourceTextPointer((Object)ResourceTextIdentifiers.FIELD_PARAMETER_NOT_FOUND, parameter.name));
            map.put(parameter.name, string);
        }
        typeDetails.setParameters(map);
    }

    private void loadPrimaryKeyElement(XmlElement xmlElement, Entity entity) throws Exception {
        Constants.PrimaryKeyType primaryKeyType = null;
        PrimaryKey primaryKey = null;
        primaryKeyType = Constants.PrimaryKeyType.get(xmlElement.getText("type"));
        primaryKey = new PrimaryKey(primaryKeyType, xmlElement.getOptionalText("sequence-name"));
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("fields/field-name")) {
            primaryKey.addFieldName(xmlElement2.getText());
        }
        entity.setPrimaryKey(primaryKey);
    }

    private void loadKeysElement(XmlElement xmlElement, Entity entity) throws Exception {
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("key")) {
            this.loadKeyElement(xmlElement2, entity);
        }
    }

    private void loadKeyElement(XmlElement xmlElement, Entity entity) throws Exception {
        Key key = null;
        key = new Key(xmlElement.getText("name"));
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("fields/field-name")) {
            key.addFieldName(xmlElement2.getText());
        }
        entity.addKey(key);
    }

    private void loadConstraintSetsElement(XmlElement xmlElement, Entity entity) throws Exception {
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("constraint-set")) {
            this.loadConstraintSetElement(xmlElement2, entity);
        }
    }

    private void loadConstraintSetElement(XmlElement xmlElement, Entity entity) throws Exception {
        ConstraintSet constraintSet = null;
        constraintSet = new ConstraintSet(xmlElement.getText("name"), xmlElement.getOptionalText("validation-class"));
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("fields/field")) {
            this.loadConstraintSetFieldElement(xmlElement2, constraintSet, entity);
        }
        entity.addConstraintSet(constraintSet);
    }

    private void loadConstraintSetFieldElement(XmlElement xmlElement, ConstraintSet constraintSet, Entity entity) throws Exception {
        Field field = null;
        field = entity.getField(xmlElement.getText("field-name"));
        constraintSet.add(field.getName());
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("constraints/constraint")) {
            this.loadConstraintElement(xmlElement2, constraintSet, field);
        }
    }

    private void loadConstraintElement(XmlElement xmlElement, ConstraintSet constraintSet, Field field) throws Exception {
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        Map<String, String> map = null;
        Set set = null;
        ConstraintSet.Constraint constraint = null;
        nullFreeCollection = xmlElement.getOptionalElements("value");
        map = this.getAdditional(xmlElement, field);
        if (nullFreeCollection.size() == 0) {
            constraint = new ConstraintSet.Constraint(xmlElement.getText("name"), map);
        } else if (nullFreeCollection.size() == 1) {
            for (XmlElement xmlElement2 : nullFreeCollection) {
                constraint = new ConstraintSet.Constraint(xmlElement.getText("name"), xmlElement2.getText(), map, field);
            }
        } else {
            set = CollectionUtils.getOrderedSet(new HashSet());
            for (XmlElement xmlElement3 : nullFreeCollection) {
                set.add(xmlElement3.getText());
            }
            constraint = new ConstraintSet.Constraint(xmlElement.getText("name"), set, map, field);
        }
        constraintSet.add(field.getName(), constraint);
    }

    private Map<String, String> getAdditional(XmlElement xmlElement, Field field) throws Exception {
        Map map = null;
        NullFreeCollection<XmlElement> nullFreeCollection = null;
        nullFreeCollection = xmlElement.getOptionalElements("additional");
        if (nullFreeCollection.size() > 0) {
            map = CollectionUtils.getOrderedMap(new HashMap(nullFreeCollection.size()));
            for (XmlElement xmlElement2 : nullFreeCollection) {
                map.put(xmlElement2.getText("name"), xmlElement2.getText("value"));
            }
        }
        return map;
    }

    private void loadOperationsElement(XmlElement xmlElement, Entity entity) throws Exception {
        EntityOperationsConfiguration entityOperationsConfiguration = null;
        entityOperationsConfiguration = new EntityOperationsConfiguration();
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("supported-operations/operation")) {
            entityOperationsConfiguration.addSupportedOperation(Constants.EntityOperation.get(xmlElement2.getText()));
        }
        entityOperationsConfiguration.setSupportsListWhereClause(xmlElement.getBoolean("supports-list-where-clause"));
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("fields-hidden-from-read-operations/field-name")) {
            entityOperationsConfiguration.addReadHiddenField(xmlElement2.getText());
        }
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("fields-hidden-from-write-operations/field-name")) {
            entityOperationsConfiguration.addWriteHiddenField(xmlElement2.getText());
        }
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("lazy-fields/field-name")) {
            entityOperationsConfiguration.addLazyField(xmlElement2.getText());
        }
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("list-return-fields/field-name")) {
            entityOperationsConfiguration.addListReturnField(xmlElement2.getText());
        }
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("get-return-fields/field-name")) {
            entityOperationsConfiguration.addGetReturnField(xmlElement2.getText());
        }
        entity.setEntityOperationsConfiguration(entityOperationsConfiguration);
    }
}

